/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.library.util;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class PlayerUtil {
    public static void swapArmorStand(ArmorStand stand, Player player, InteractionHand hand) {
        ItemStack heldPlayer = player.m_21120_(hand).m_41777_();
        ItemStack heldStand = stand.m_21120_(hand).m_41777_();
        EquipmentSlot slot = hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
        stand.m_8061_(slot, heldPlayer);
        player.m_8061_(slot, heldStand);
    }

    public static boolean isTamedByPlayer(AbstractHorse horse, Player dmgOwner) {
        return horse.m_30614_() && horse.m_21805_() != null && horse.m_21805_().equals(dmgOwner.m_20148_());
    }

    public static boolean isTamedByPlayer(TamableAnimal horse, Player dmgOwner) {
        return horse.m_21824_() && horse.m_21805_() != null && horse.m_21805_().equals(dmgOwner.m_20148_());
    }

    public static void clearAllExp(Player player) {
        player.f_36080_ = 0.0f;
        player.f_36078_ = 0;
        player.f_36079_ = 0;
    }

    public static double getExpTotal(Player player) {
        int level = player.f_36078_;
        double totalExp = PlayerUtil.getXpForLevel(level);
        double progress = Math.round((float)player.m_36323_() * player.f_36080_);
        return totalExp += (double)((int)progress);
    }

    public static boolean isPlayerCrouching(Entity entity) {
        return entity instanceof Player && ((Player)entity).m_6047_();
    }

    public static int getXpForLevel(int level) {
        int totalExp = 0;
        totalExp = level <= 15 ? level * level + 6 * level : (level <= 30 ? (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0) : (int)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0));
        return totalExp;
    }

    public static ItemStack getPlayerItemIfHeld(Player player) {
        ItemStack wand = player.m_21205_();
        if (wand.m_41619_()) {
            wand = player.m_21206_();
        }
        return wand;
    }

    public static int getFirstSlotWithBlock(Player player, BlockState targetState) {
        int ret = -1;
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (stack.m_41619_() || stack.m_41720_() == null || Block.m_49814_((Item)stack.m_41720_()) != targetState.m_60734_()) continue;
            return i;
        }
        return ret;
    }

    public static BlockState getBlockstateFromSlot(Player player, int slot) {
        ItemStack stack = player.m_150109_().m_8020_(slot);
        if (!stack.m_41619_() && stack.m_41720_() != null && Block.m_49814_((Item)stack.m_41720_()) != null) {
            Block b = Block.m_49814_((Item)stack.m_41720_());
            return b.m_49966_();
        }
        return null;
    }

    public static void decrStackSize(Player player, int slot) {
        if (!player.m_7500_() && slot >= 0) {
            player.m_150109_().m_7407_(slot, 1);
        }
    }

    public static Item getItemArmorSlot(Player player, EquipmentSlot slot) {
        ItemStack inslot = (ItemStack)player.m_150109_().f_35975_.get(slot.m_20749_());
        Item item = inslot.m_41619_() ? null : inslot.m_41720_();
        return item;
    }

    public static Optional<Vec3> getPlayerHome(ServerPlayer player) {
        BlockPos respawnPos = player.m_8961_();
        Optional optional = Optional.empty();
        if (respawnPos != null) {
            optional = Player.m_36130_((ServerLevel)((ServerLevel)player.m_9236_()), (BlockPos)respawnPos, (float)0.0f, (boolean)true, (boolean)true);
        }
        return optional;
    }
}

