/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.library.util;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemStackUtil {
    public static final String NBT_LORE = "Lore";
    public static final String NBT_DISPLAY = "display";

    public static void addLoreToStack(ItemStack crafting, String lore, String color) {
        CompoundTag displayTag = new CompoundTag();
        ListTag tagList = new ListTag();
        if (color == null) {
            color = "gold";
        }
        String escaped = "{\"text\":\"" + lore + "\",\"color\":\"" + color + "\"}";
        tagList.add((Object)StringTag.m_129297_((String)escaped));
        displayTag.m_128365_(NBT_LORE, (Tag)tagList);
        crafting.m_41783_().m_128365_(NBT_DISPLAY, (Tag)displayTag);
    }

    public static void applyRandomEnch(RandomSource random, ItemStack crafting) {
        crafting = EnchantmentHelper.m_220292_((RandomSource)random, (ItemStack)crafting, (int)1, (boolean)false);
    }

    public static void applyRandomEnch(RandomSource random, ItemStack crafting, int level, boolean allowTreasure) {
        ItemStackUtil.applyRandomEnch(random, crafting);
    }

    public static int countEmptySlots(IItemHandler handler) {
        if (handler == null) {
            return 0;
        }
        int empty = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (!handler.getStackInSlot(i).m_41619_()) continue;
            ++empty;
        }
        return empty;
    }

    public static ItemStack findItem(String id) {
        Item head = (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.m_135820_((String)id));
        if (head != null) {
            return new ItemStack((ItemLike)head);
        }
        return ItemStack.f_41583_;
    }

    public static void dropAll(IItemHandler items, Level world, BlockPos pos) {
        if (items == null) {
            return;
        }
        for (int i = 0; i < items.getSlots(); ++i) {
            Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)items.getStackInSlot(i));
        }
    }

    public static void repairItem(ItemStack s) {
        ItemStackUtil.repairItem(s, 1);
    }

    public static void repairItem(ItemStack s, int amount) {
        s.m_41721_(Math.max(0, s.m_41773_() - amount));
    }

    public static void damageItem(LivingEntity player, ItemStack stack) {
        ItemStackUtil.damageItem(player, stack, InteractionHand.MAIN_HAND);
    }

    public static void damageItem(LivingEntity player, ItemStack stack, InteractionHand hand) {
        if (!stack.m_41763_()) {
            return;
        }
        if (player == null) {
            stack.m_41721_(stack.m_41773_() + 1);
        } else {
            stack.m_41622_(1, player, p -> p.m_21190_(InteractionHand.MAIN_HAND));
        }
        if (stack.m_41773_() >= stack.m_41776_()) {
            stack.m_41774_(1);
            stack = ItemStack.f_41583_;
        }
    }

    public static void damageItemRandomly(LivingEntity player, ItemStack stack) {
        if (player.m_9236_().f_46441_.m_188500_() < 0.001) {
            ItemStackUtil.damageItem(player, stack);
        }
    }

    public static void drop(Level world, BlockPos pos, Block drop) {
        if (!world.f_46443_) {
            world.m_7967_((Entity)new ItemEntity(world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), new ItemStack((ItemLike)drop.m_5456_())));
        }
    }

    public static void drop(Level world, BlockPos pos, ItemStack drop) {
        if (!world.f_46443_) {
            world.m_7967_((Entity)new ItemEntity(world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), drop));
        }
    }

    public static boolean matches(ItemStack current, ItemStack in) {
        return ItemStack.m_41728_((ItemStack)current, (ItemStack)in) && ItemStack.m_150942_((ItemStack)current, (ItemStack)in);
    }

    public static void shrink(Player player, ItemStack stac) {
        if (!player.m_7500_()) {
            stac.m_41774_(1);
        }
    }

    public static void drop(Level world, BlockPos center, List<ItemStack> lootDrops) {
        for (ItemStack dropMe : lootDrops) {
            ItemStackUtil.drop(world, center, dropMe);
        }
    }

    public static void dropItemStackMotionless(Level world, BlockPos pos, ItemStack stack) {
        if (stack.m_41619_()) {
            return;
        }
        if (!world.f_46443_) {
            ItemEntity entityItem = new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, stack);
            world.m_7967_((Entity)entityItem);
            entityItem.m_20334_(0.0, 0.0, 0.0);
        }
    }

    public static void deleteTag(ItemStack itemstack) {
        int dmg = itemstack.m_41773_();
        itemstack.m_41751_(null);
        itemstack.m_41721_(dmg);
    }

    public static void randomlyRepair(RandomSource rnd, ItemStack stack, int factor) {
        if (stack.m_41768_() && rnd.m_188503_(factor) == 0) {
            stack.m_41721_(stack.m_41773_() - 1);
        }
    }
}

