/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.network.packet;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.everlastingabilities.EverlastingAbilities;
import org.cyclops.everlastingabilities.GeneralConfig;
import org.cyclops.everlastingabilities.ability.AbilityHelpers;
import org.cyclops.everlastingabilities.api.capability.AbilityStoreCapabilityProvider;
import org.cyclops.everlastingabilities.capability.MutableAbilityStoreConfig;

public class SendAbilityStorePacket
extends PacketCodec {
    @CodecField
    private int entityId;
    @CodecField
    private CompoundTag tag;
    @CodecField
    private int maxPlayerAbilities;

    public SendAbilityStorePacket() {
    }

    public SendAbilityStorePacket(int entityId, CompoundTag tag) {
        this.entityId = entityId;
        this.tag = tag;
        this.maxPlayerAbilities = GeneralConfig.maxPlayerAbilities;
    }

    public boolean isAsync() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void actionClient(net.minecraft.world.level.Level world, Player player) {
        try {
            Entity entity;
            if (world != null && (entity = world.m_6815_(this.entityId)) != null) {
                entity.getCapability(MutableAbilityStoreConfig.CAPABILITY, null).ifPresent(abilityStore -> AbilityStoreCapabilityProvider.deserializeNBTStatic(AbilityHelpers.getRegistry(world.m_9598_()), abilityStore, this.tag.m_128423_("contents")));
                AbilityHelpers.maxPlayerAbilitiesClient = this.maxPlayerAbilities;
            }
        }
        catch (IllegalArgumentException e) {
            EverlastingAbilities.clog(Level.ERROR, e.getMessage());
        }
    }

    public void actionServer(net.minecraft.world.level.Level world, ServerPlayer player) {
    }
}

