/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.item;

import com.google.common.collect.Lists;
import java.util.Collection;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.cyclops.cyclopscore.config.ConfigurableProperty;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfig;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.everlastingabilities.EverlastingAbilities;
import org.cyclops.everlastingabilities.ability.AbilityHelpers;
import org.cyclops.everlastingabilities.api.Ability;
import org.cyclops.everlastingabilities.api.IAbilityType;
import org.cyclops.everlastingabilities.core.helper.WorldHelpers;
import org.cyclops.everlastingabilities.item.ItemAbilityTotem;

public class ItemAbilityTotemConfig
extends ItemConfig {
    @ConfigurableProperty(category="core", comment="This many totems combined in a crafting grid produces a new random totem (0 to disable)")
    public static int totemCraftingCount = 3;
    @ConfigurableProperty(category="core", comment="When combining totems, percentage chance of getting one higher rarity than normal.", configLocation=ModConfig.Type.SERVER)
    public static int totemCraftingRarityIncreasePercent = 15;

    public ItemAbilityTotemConfig() {
        super((ModBase)EverlastingAbilities._instance, "ability_totem", eConfig -> new ItemAbilityTotem(new Item.Properties().m_41487_(1)));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onCreativeModeTabBuildContents);
    }

    protected Collection<ItemStack> getDefaultCreativeTabEntries() {
        return Lists.newArrayList();
    }

    protected void onCreativeModeTabBuildContents(BuildCreativeModeTabContentsEvent event) {
        RegistryAccess registryAccess = WorldHelpers.getRegistryAccess();
        if (event.getTab() == this.getMod().getDefaultCreativeTab() && registryAccess != null) {
            Registry<IAbilityType> registry = AbilityHelpers.getRegistry(registryAccess);
            registry.forEach(abilityType -> {
                for (int level = 1; level <= abilityType.getMaxLevel(); ++level) {
                    Ability ability = new Ability((IAbilityType)abilityType, level);
                    if (!AbilityHelpers.PREDICATE_ABILITY_ENABLED.test((IAbilityType)abilityType)) continue;
                    event.m_246342_(ItemAbilityTotem.getTotem(ability));
                }
            });
        }
    }
}

