/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen;

import java.util.ArrayList;
import java.util.Optional;
import me.jddev0.ep.block.entity.FluidTransposerBlockEntity;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.SetCheckboxC2SPacket;
import me.jddev0.ep.screen.FluidTransposerMenu;
import me.jddev0.ep.screen.base.ConfigurableUpgradableEnergyStorageContainerScreen;
import me.jddev0.ep.util.FluidUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FluidTransposerScreen
extends ConfigurableUpgradableEnergyStorageContainerScreen<FluidTransposerMenu> {
    public FluidTransposerScreen(FluidTransposerMenu menu, Inventory inventory, Component component) {
        super(menu, inventory, component, "tooltip.energizedpower.recipe.energy_required_to_finish.txt", new ResourceLocation("energizedpower", "textures/gui/container/fluid_transposer.png"), new ResourceLocation("energizedpower", "textures/gui/container/upgrade_view/1_speed_1_energy_efficiency_1_energy_capacity.png"));
    }

    @Override
    protected boolean mouseClickedNormalView(double mouseX, double mouseY, int mouseButton) {
        if (super.mouseClickedNormalView(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (mouseButton == 0 && this.m_6774_(114, 47, 20, 20, mouseX, mouseY)) {
            ModMessages.sendToServer(new SetCheckboxC2SPacket(((FluidTransposerBlockEntity)((FluidTransposerMenu)this.f_97732_).getBlockEntity()).m_58899_(), 0, ((FluidTransposerMenu)this.f_97732_).getMode() == FluidTransposerBlockEntity.Mode.EMPTYING));
            return true;
        }
        return false;
    }

    @Override
    protected void renderBgNormalView(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        super.renderBgNormalView(guiGraphics, partialTick, mouseX, mouseY);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.renderFluidMeterContent(guiGraphics, ((FluidTransposerMenu)this.f_97732_).getFluid(), ((FluidTransposerMenu)this.f_97732_).getTankCapacity(), x + 152, y + 17, 16, 52);
        this.renderFluidMeterOverlay(guiGraphics, x, y);
        this.renderButtons(guiGraphics, x, y, mouseX, mouseY);
        this.renderProgressArrow(guiGraphics, x, y);
    }

    private void renderFluidMeterOverlay(GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.m_280218_(this.TEXTURE, x + 152, y + 17, 176, 53, 16, 52);
    }

    private void renderButtons(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        if (this.m_6774_(114, 47, 20, 20, mouseX, mouseY)) {
            guiGraphics.m_280218_(this.TEXTURE, x + 114, y + 47, 176, 135, 20, 20);
        }
        ItemStack output = new ItemStack((ItemLike)(((FluidTransposerMenu)this.f_97732_).getMode() == FluidTransposerBlockEntity.Mode.EMPTYING ? Items.f_42446_ : Items.f_42447_));
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
        guiGraphics.m_280256_(output, x + 116, y + 49, 116 + 49 * this.f_97726_);
        guiGraphics.m_280168_().m_85849_();
    }

    private void renderProgressArrow(GuiGraphics guiGraphics, int x, int y) {
        int arrowPosY = ((FluidTransposerMenu)this.f_97732_).getMode() == FluidTransposerBlockEntity.Mode.EMPTYING ? 106 : 120;
        guiGraphics.m_280218_(this.TEXTURE, x + 114, y + 19, 176, arrowPosY, 20, 14);
        if (((FluidTransposerMenu)this.f_97732_).isCraftingActive()) {
            if (((FluidTransposerMenu)this.f_97732_).getMode() == FluidTransposerBlockEntity.Mode.EMPTYING) {
                guiGraphics.m_280218_(this.TEXTURE, x + 114, y + 19, 196, arrowPosY, ((FluidTransposerMenu)this.f_97732_).getScaledProgressArrowSize(), 14);
            } else {
                guiGraphics.m_280218_(this.TEXTURE, x + 134 - ((FluidTransposerMenu)this.f_97732_).getScaledProgressArrowSize(), y + 19, 216 - ((FluidTransposerMenu)this.f_97732_).getScaledProgressArrowSize(), arrowPosY, ((FluidTransposerMenu)this.f_97732_).getScaledProgressArrowSize(), 14);
            }
        }
    }

    @Override
    protected void renderTooltipNormalView(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ArrayList<MutableComponent> components;
        super.renderTooltipNormalView(guiGraphics, mouseX, mouseY);
        if (this.m_6774_(152, 17, 16, 52, mouseX, mouseY)) {
            components = new ArrayList<MutableComponent>(2);
            boolean fluidEmpty = ((FluidTransposerMenu)this.f_97732_).getFluid().isEmpty();
            int fluidAmount = fluidEmpty ? 0 : ((FluidTransposerMenu)this.f_97732_).getFluid().getAmount();
            MutableComponent tooltipComponent = Component.m_237110_((String)"tooltip.energizedpower.fluid_meter.content_amount.txt", (Object[])new Object[]{FluidUtils.getFluidAmountWithPrefix(fluidAmount), FluidUtils.getFluidAmountWithPrefix(((FluidTransposerMenu)this.f_97732_).getTankCapacity())});
            if (!fluidEmpty) {
                tooltipComponent = Component.m_237115_((String)((FluidTransposerMenu)this.f_97732_).getFluid().getTranslationKey()).m_130946_(" ").m_7220_((Component)tooltipComponent);
            }
            components.add(tooltipComponent);
            guiGraphics.m_280677_(this.f_96547_, components, Optional.empty(), mouseX, mouseY);
        }
        if (this.m_6774_(114, 47, 20, 20, mouseX, mouseY)) {
            components = new ArrayList(2);
            components.add(Component.m_237115_((String)("tooltip.energizedpower.fluid_transposer.mode." + ((FluidTransposerMenu)this.f_97732_).getMode().m_7912_())));
            guiGraphics.m_280677_(this.f_96547_, components, Optional.empty(), mouseX, mouseY);
        }
    }
}

