/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen;

import java.util.ArrayList;
import java.util.Locale;
import java.util.Optional;
import me.jddev0.ep.block.entity.FluidPumpBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.screen.FluidPumpMenu;
import me.jddev0.ep.screen.base.ConfigurableUpgradableEnergyStorageContainerScreen;
import me.jddev0.ep.util.FluidUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;

@OnlyIn(value=Dist.CLIENT)
public class FluidPumpScreen
extends ConfigurableUpgradableEnergyStorageContainerScreen<FluidPumpMenu> {
    public static final boolean SHOW_RELATIVE_COORDINATES = ModConfigs.CLIENT_FLUID_PUMP_RELATIVE_TARGET_COORDINATES.getValue();

    public FluidPumpScreen(FluidPumpMenu menu, Inventory inventory, Component component) {
        super(menu, inventory, component, "tooltip.energizedpower.fluid_pump.process_energy_left.txt", new ResourceLocation("energizedpower", "textures/gui/container/fluid_pump.png"), new ResourceLocation("energizedpower", "textures/gui/container/upgrade_view/fluid_pump.png"));
        this.f_97726_ = 230;
        this.energyMeterU = 230;
    }

    @Override
    protected void renderBgNormalView(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        super.renderBgNormalView(guiGraphics, partialTick, mouseX, mouseY);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.renderFluidMeterContent(guiGraphics, ((FluidPumpMenu)this.f_97732_).getFluid(), ((FluidPumpMenu)this.f_97732_).getTankCapacity(), x + 206, y + 17, 16, 52);
        this.renderFluidMeterOverlay(guiGraphics, x, y);
        this.renderInfoText(guiGraphics, x, y);
    }

    private void renderFluidMeterOverlay(GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.m_280218_(this.TEXTURE, x + 206, y + 17, 230, 53, 16, 52);
    }

    private void renderInfoText(GuiGraphics guiGraphics, int x, int y) {
        FluidState targetFluidState;
        BlockPos targetPos = ((FluidPumpBlockEntity)((FluidPumpMenu)this.f_97732_).getBlockEntity()).m_58899_().m_121955_((Vec3i)((FluidPumpMenu)this.f_97732_).getTargetOffset());
        MutableComponent component = SHOW_RELATIVE_COORDINATES ? Component.m_237110_((String)"tooltip.energizedpower.fluid_pump.target_relative", (Object[])new Object[]{String.format(Locale.ENGLISH, "%+d", ((FluidPumpMenu)this.f_97732_).getTargetOffset().m_123341_()), String.format(Locale.ENGLISH, "%+d", ((FluidPumpMenu)this.f_97732_).getTargetOffset().m_123342_()), String.format(Locale.ENGLISH, "%+d", ((FluidPumpMenu)this.f_97732_).getTargetOffset().m_123343_())}) : Component.m_237110_((String)"tooltip.energizedpower.fluid_pump.target", (Object[])new Object[]{targetPos.m_123341_(), targetPos.m_123342_(), targetPos.m_123343_()});
        int componentWidth = this.f_96547_.m_92852_((FormattedText)component);
        guiGraphics.m_280614_(this.f_96547_, (Component)component, (int)((float)(x + 35) + (float)(162 - componentWidth) * 0.5f), y + 22, 0, false);
        if (((FluidPumpMenu)this.f_97732_).m_38853_(36).m_7993_().m_41619_()) {
            component = Component.m_237115_((String)"tooltip.energizedpower.fluid_pump.cobblestone_missing").m_130940_(ChatFormatting.RED);
            componentWidth = this.f_96547_.m_92852_((FormattedText)component);
            guiGraphics.m_280614_(this.f_96547_, (Component)component, (int)((float)(x + 35) + (float)(162 - componentWidth) * 0.5f), y + 58, 0, false);
        } else if (((FluidPumpMenu)this.f_97732_).isExtractingFluid() && !(targetFluidState = ((FluidPumpBlockEntity)((FluidPumpMenu)this.f_97732_).getBlockEntity()).m_58904_().m_6425_(targetPos)).m_76178_()) {
            component = Component.m_237110_((String)"tooltip.energizedpower.fluid_pump.extracting", (Object[])new Object[]{Component.m_237115_((String)new FluidStack(targetFluidState.m_76152_(), 1).getTranslationKey())});
            componentWidth = this.f_96547_.m_92852_((FormattedText)component);
            guiGraphics.m_280614_(this.f_96547_, (Component)component, (int)((float)(x + 35) + (float)(162 - componentWidth) * 0.5f), y + 58, 0, false);
        }
    }

    @Override
    protected void renderTooltipNormalView(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderTooltipNormalView(guiGraphics, mouseX, mouseY);
        if (this.m_6774_(206, 17, 16, 52, mouseX, mouseY)) {
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>(2);
            boolean fluidEmpty = ((FluidPumpMenu)this.f_97732_).getFluid().isEmpty();
            int fluidAmount = fluidEmpty ? 0 : ((FluidPumpMenu)this.f_97732_).getFluid().getAmount();
            MutableComponent tooltipComponent = Component.m_237110_((String)"tooltip.energizedpower.fluid_meter.content_amount.txt", (Object[])new Object[]{FluidUtils.getFluidAmountWithPrefix(fluidAmount), FluidUtils.getFluidAmountWithPrefix(((FluidPumpMenu)this.f_97732_).getTankCapacity())});
            if (!fluidEmpty) {
                tooltipComponent = Component.m_237115_((String)((FluidPumpMenu)this.f_97732_).getFluid().getTranslationKey()).m_130946_(" ").m_7220_((Component)tooltipComponent);
            }
            components.add(tooltipComponent);
            guiGraphics.m_280677_(this.f_96547_, components, Optional.empty(), mouseX, mouseY);
        }
    }
}

