/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen;

import java.util.ArrayList;
import java.util.Locale;
import java.util.Optional;
import me.jddev0.ep.recipe.FiltrationPlantRecipe;
import me.jddev0.ep.screen.FiltrationPlantMenu;
import me.jddev0.ep.screen.base.SelectableRecipeMachineContainerScreen;
import me.jddev0.ep.util.FluidUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class FiltrationPlantScreen
extends SelectableRecipeMachineContainerScreen<FiltrationPlantRecipe, FiltrationPlantMenu> {
    public FiltrationPlantScreen(FiltrationPlantMenu menu, Inventory inventory, Component component) {
        super(menu, inventory, component, "tooltip.energizedpower.recipe.energy_required_to_finish.txt", new ResourceLocation("energizedpower", "textures/gui/container/filtration_plant.png"), new ResourceLocation("energizedpower", "textures/gui/container/upgrade_view/1_speed_1_energy_efficiency_1_energy_capacity.png"));
        this.recipeSelectorPosX = 98;
        this.recipeSelectorTexturePosY = 115;
    }

    @Override
    protected ItemStack getRecipeIcon(FiltrationPlantRecipe currentRecipe) {
        ResourceLocation icon = currentRecipe.getIcon();
        Item iconItem = (Item)ForgeRegistries.ITEMS.getValue(icon);
        return iconItem == null ? ItemStack.f_41583_ : new ItemStack((ItemLike)iconItem);
    }

    @Override
    protected void renderCurrentRecipeTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY, FiltrationPlantRecipe currentRecipe) {
        ArrayList<MutableComponent> components = new ArrayList<MutableComponent>(2);
        ItemStack[] maxOutputs = currentRecipe.getMaxOutputCounts();
        for (int i = 0; i < maxOutputs.length; ++i) {
            ItemStack output = maxOutputs[i];
            if (output.m_41619_()) continue;
            components.add(Component.m_237119_().m_7220_(output.m_41786_()).m_7220_((Component)Component.m_237113_((String)": ")).m_7220_((Component)Component.m_237115_((String)"recipes.energizedpower.transfer.output_percentages")));
            double[] percentages = (i == 0 ? currentRecipe.getOutput() : currentRecipe.getSecondaryOutput()).percentages();
            for (int j = 0; j < percentages.length; ++j) {
                components.add(Component.m_237113_((String)String.format(Locale.ENGLISH, "%2d \u2022 %.2f %%", j + 1, 100.0 * percentages[j])));
            }
            components.add(Component.m_237119_());
        }
        if (!components.isEmpty()) {
            components.remove(components.size() - 1);
        }
        guiGraphics.m_280677_(this.f_96547_, components, Optional.empty(), mouseX, mouseY);
    }

    @Override
    protected void renderBgNormalView(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        super.renderBgNormalView(guiGraphics, partialTick, mouseX, mouseY);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        for (int i = 0; i < 2; ++i) {
            this.renderFluidMeterContent(guiGraphics, ((FiltrationPlantMenu)this.f_97732_).getFluid(i), ((FiltrationPlantMenu)this.f_97732_).getTankCapacity(i), x + (i == 0 ? 44 : 152), y + 17, 16, 52);
            this.renderFluidMeterOverlay(i, guiGraphics, x, y);
        }
        this.renderProgressArrows(guiGraphics, x, y);
    }

    private void renderFluidMeterOverlay(int tank, GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.m_280218_(this.TEXTURE, x + (tank == 0 ? 44 : 152), y + 17, 176, 53, 16, 52);
    }

    private void renderProgressArrows(GuiGraphics guiGraphics, int x, int y) {
        if (((FiltrationPlantMenu)this.f_97732_).isCraftingActive()) {
            for (int i = 0; i < 2; ++i) {
                guiGraphics.m_280218_(this.TEXTURE, x + 67, y + 34 + 27 * i, 176, 106, ((FiltrationPlantMenu)this.f_97732_).getScaledProgressArrowSize(), 9);
            }
        }
    }

    @Override
    protected void renderTooltipNormalView(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ArrayList<MutableComponent> components;
        int i;
        super.renderTooltipNormalView(guiGraphics, mouseX, mouseY);
        for (i = 0; i < 2; ++i) {
            if (!this.m_6774_(i == 0 ? 44 : 152, 17, 16, 52, mouseX, mouseY)) continue;
            components = new ArrayList<MutableComponent>(2);
            boolean fluidEmpty = ((FiltrationPlantMenu)this.f_97732_).getFluid(i).isEmpty();
            int fluidAmount = fluidEmpty ? 0 : ((FiltrationPlantMenu)this.f_97732_).getFluid(i).getAmount();
            MutableComponent tooltipComponent = Component.m_237110_((String)"tooltip.energizedpower.fluid_meter.content_amount.txt", (Object[])new Object[]{FluidUtils.getFluidAmountWithPrefix(fluidAmount), FluidUtils.getFluidAmountWithPrefix(((FiltrationPlantMenu)this.f_97732_).getTankCapacity(i))});
            if (!fluidEmpty) {
                tooltipComponent = Component.m_237115_((String)((FiltrationPlantMenu)this.f_97732_).getFluid(i).getTranslationKey()).m_130946_(" ").m_7220_((Component)tooltipComponent);
            }
            components.add(tooltipComponent);
            guiGraphics.m_280677_(this.f_96547_, components, Optional.empty(), mouseX, mouseY);
        }
        for (i = 0; i < 2; ++i) {
            if (!this.m_6774_(62 + 72 * i, 44, 16, 16, mouseX, mouseY) || !((FiltrationPlantMenu)this.f_97732_).m_38853_(36 + i).m_7993_().m_41619_()) continue;
            components = new ArrayList(2);
            components.add(Component.m_237115_((String)"tooltip.energizedpower.filtration_plant.charcoal_filter_missing").m_130940_(ChatFormatting.RED));
            guiGraphics.m_280677_(this.f_96547_, components, Optional.empty(), mouseX, mouseY);
        }
    }
}

