/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.PopEnergizedPowerBookFromLecternC2SPacket;
import net.minecraft.ChatFormatting;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class EnergizedPowerBookScreen
extends Screen {
    public static final ResourceLocation TEXTURE = new ResourceLocation("energizedpower", "textures/gui/book/energized_power_book.png");
    public static final ResourceLocation FRONT_COVER = new ResourceLocation("energizedpower", "textures/gui/book/front_cover.png");
    public static final ResourceLocation BACK_COVER = new ResourceLocation("energizedpower", "textures/gui/book/back_cover.png");
    public static final ResourceLocation ENERGIZED_COPPER_INGOT = new ResourceLocation("energizedpower", "textures/item/energized_copper_ingot.png");
    public static final int IMAGE_CYCLE_DELAY = ModConfigs.CLIENT_ENERGIZED_POWER_BOOK_IMAGE_CYCLE_DELAY.getValue();
    private static final int MAX_CHARS_PER_LINE = 148;
    private static final int MAX_LINES = 19;
    private static List<PageContent> pages = new LinkedList<PageContent>();
    private int currentTick;
    private PageButton forwardButton;
    private PageButton backButton;
    private final LecternBlockEntity lecternBlockEntity;
    private ResourceLocation openOnPageForBlock;
    private List<FormattedPageContent> formattedPages;
    private int currentPage;
    private Component currentPageNumberOutput = CommonComponents.f_237098_;
    private boolean isCurrentPageCached;

    public static void setPages(List<PageContent> pages) {
        EnergizedPowerBookScreen.pages = new ArrayList<PageContent>(pages);
    }

    public EnergizedPowerBookScreen() {
        this(null, null);
    }

    public EnergizedPowerBookScreen(ResourceLocation openOnPageForBlock) {
        this(null, openOnPageForBlock);
    }

    public EnergizedPowerBookScreen(LecternBlockEntity lecternBlockEntity) {
        this(lecternBlockEntity, null);
    }

    public EnergizedPowerBookScreen(LecternBlockEntity lecternBlockEntity, ResourceLocation openOnPageForBlock) {
        super(GameNarrator.f_93310_);
        this.lecternBlockEntity = lecternBlockEntity;
        this.openOnPageForBlock = openOnPageForBlock;
    }

    protected void m_7856_() {
        this.createMenuControls();
        this.createPageControlButtons();
        LinkedList<FormattedPageContent> formattedPages = new LinkedList<FormattedPageContent>();
        formattedPages.add(new FormattedPageContent(new ResourceLocation("energizedpower", "front_cover"), null, this.f_96547_.m_92923_((FormattedText)Component.m_237115_((String)"book.energizedpower.front.cover.text").m_130940_(ChatFormatting.GRAY), 148), null, null));
        for (PageContent pageContent : pages) {
            ArrayList<FormattedCharSequence> formattedPageComponents;
            ResourceLocation pageId = pageContent.getPageId();
            Component chapterTitleComponent = pageContent.getChapterTitleComponent();
            ResourceLocation[] imageResourceLocations = pageContent.getImageResourceLocations();
            ResourceLocation[] blockResourceLocations = pageContent.getBlockResourceLocations();
            List<Object> list = formattedPageComponents = pageContent.getPageComponent() == null ? new ArrayList<FormattedCharSequence>(0) : this.f_96547_.m_92923_((FormattedText)pageContent.getPageComponent(), 148);
            if (chapterTitleComponent != null) {
                formattedPages.add(new FormattedPageContent(pageId, chapterTitleComponent, formattedPageComponents, imageResourceLocations, blockResourceLocations));
                continue;
            }
            int maxLineCountFirstPage = 19 - (imageResourceLocations != null || blockResourceLocations != null ? 7 : 0);
            formattedPages.add(new FormattedPageContent(pageId, chapterTitleComponent, formattedPageComponents.subList(0, Math.min(maxLineCountFirstPage, formattedPageComponents.size())), imageResourceLocations, blockResourceLocations));
            int i = maxLineCountFirstPage;
            int splitPageCount = 2;
            while (i < formattedPageComponents.size()) {
                ResourceLocation tmpPageId = new ResourceLocation(pageId.m_135827_(), pageId.m_135815_() + "/tmp_page_" + splitPageCount);
                formattedPages.add(new FormattedPageContent(tmpPageId, null, formattedPageComponents.subList(i, Math.min(i + 19, formattedPageComponents.size())), null, null));
                i += 19;
                ++splitPageCount;
            }
        }
        formattedPages.add(new FormattedPageContent(new ResourceLocation("energizedpower", "back_cover"), null, new ArrayList<FormattedCharSequence>(0), null, null));
        this.formattedPages = new ArrayList<FormattedPageContent>(formattedPages);
        this.updateButtonVisibility();
        if (this.openOnPageForBlock != null) {
            block2: for (int i = 0; i < formattedPages.size(); ++i) {
                ResourceLocation[] blockResourceLocations = ((FormattedPageContent)formattedPages.get(i)).getBlockResourceLocations();
                if (blockResourceLocations == null) continue;
                for (ResourceLocation block : blockResourceLocations) {
                    if (!block.equals((Object)this.openOnPageForBlock)) continue;
                    this.setPage(i);
                    break block2;
                }
            }
            this.openOnPageForBlock = null;
        }
    }

    private void createMenuControls() {
        boolean showTakeButton = this.lecternBlockEntity != null && this.f_96541_.f_91074_.m_36326_();
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, button -> this.m_7379_()).m_252987_(this.f_96543_ / 2 - 116, 232, showTakeButton ? 116 : 236, 20).m_253136_());
        if (showTakeButton) {
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"lectern.take_book"), button -> {
                ModMessages.sendToServer(new PopEnergizedPowerBookFromLecternC2SPacket(this.lecternBlockEntity.m_58899_()));
                this.m_7379_();
            }).m_252987_(this.f_96543_ / 2 + 2, 232, 116, 20).m_253136_());
        }
    }

    private void createPageControlButtons() {
        int startX = (this.f_96543_ - 226) / 2;
        this.forwardButton = (PageButton)this.m_142416_((GuiEventListener)new PageButton(startX + 150, 193, true, button -> this.pageForward(), true));
        this.backButton = (PageButton)this.m_142416_((GuiEventListener)new PageButton(startX + 43, 193, false, button -> this.pageBack(), true));
        this.updateButtonVisibility();
    }

    private int getPageCount() {
        return this.formattedPages == null ? 0 : this.formattedPages.size();
    }

    private void pageForward() {
        if (this.currentPage < this.getPageCount() - 1) {
            ++this.currentPage;
            this.isCurrentPageCached = false;
        }
        this.updateButtonVisibility();
    }

    private void pageBack() {
        if (this.currentPage > 0) {
            --this.currentPage;
            this.isCurrentPageCached = false;
        }
        this.updateButtonVisibility();
    }

    private boolean setPage(int page) {
        if (page < 0 || page >= this.getPageCount() || page == this.currentPage) {
            return false;
        }
        this.currentPage = page;
        this.isCurrentPageCached = false;
        this.updateButtonVisibility();
        return true;
    }

    private void updateButtonVisibility() {
        this.forwardButton.f_93624_ = this.currentPage < this.getPageCount() - 1;
        this.backButton.f_93624_ = this.currentPage > 0;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        int oldCurrentPage = this.currentPage;
        return switch (keyCode) {
            case 266 -> {
                this.backButton.m_5691_();
                if (this.currentPage != oldCurrentPage) {
                    this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)1.0f));
                }
                yield true;
            }
            case 267 -> {
                this.forwardButton.m_5691_();
                if (this.currentPage != oldCurrentPage) {
                    this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)1.0f));
                }
                yield true;
            }
            default -> false;
        };
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        Style style;
        if (mouseButton == 0 && (style = this.getComponentStyleAt(mouseX, mouseY)) != null && this.m_5561_(style)) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean m_5561_(Style style) {
        ClickEvent clickEvent = style.m_131182_();
        if (clickEvent == null || this.formattedPages == null) {
            return false;
        }
        if (clickEvent.m_130622_() == ClickEvent.Action.CHANGE_PAGE) {
            int oldCurrentPage = this.currentPage;
            try {
                boolean bl = this.setPage(Integer.parseInt(clickEvent.m_130623_()));
                return bl;
            }
            catch (NumberFormatException e) {
                int i;
                String pageIdString = clickEvent.m_130623_();
                ResourceLocation pageId = ResourceLocation.m_135820_((String)pageIdString);
                if (pageId == null) {
                    boolean bl = false;
                    return bl;
                }
                boolean containsKeyFlag = false;
                for (i = 0; i < this.formattedPages.size(); ++i) {
                    if (!this.formattedPages.get(i).getPageId().equals((Object)pageId)) continue;
                    containsKeyFlag = true;
                    break;
                }
                if (!containsKeyFlag) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = this.setPage(i);
                return bl;
            }
            finally {
                if (this.currentPage != oldCurrentPage) {
                    this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)1.0f));
                }
            }
        }
        boolean flag = super.m_5561_(style);
        if (flag && clickEvent.m_130622_() == ClickEvent.Action.RUN_COMMAND) {
            this.m_7379_();
        }
        return flag;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.formattedPages == null) {
            return;
        }
        int startX = (this.f_96543_ - 226) / 2;
        if (this.currentPage == 0) {
            guiGraphics.m_280218_(FRONT_COVER, startX, 2, 0, 0, 226, 230);
        } else if (this.currentPage == this.getPageCount() - 1) {
            guiGraphics.m_280218_(BACK_COVER, startX, 2, 0, 0, 226, 230);
        } else {
            guiGraphics.m_280218_(TEXTURE, startX, 2, 0, 0, 226, 230);
        }
        if (!this.isCurrentPageCached) {
            this.currentPageNumberOutput = Component.m_237110_((String)"book.pageIndicator", (Object[])new Object[]{this.currentPage, Math.max(this.getPageCount() - 1, 1)});
            this.isCurrentPageCached = true;
        }
        int textWidth = this.f_96547_.m_92852_((FormattedText)this.currentPageNumberOutput);
        guiGraphics.m_280614_(this.f_96547_, this.currentPageNumberOutput, (int)((float)(this.f_96543_ - textWidth) / 2.0f), 222, -1, false);
        if (this.currentPage == 0) {
            this.renderFrontCover(guiGraphics);
            super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
            return;
        }
        if (this.currentPage == this.getPageCount() - 1) {
            this.renderImageCentered(guiGraphics, ENERGIZED_COPPER_INGOT, -1);
            super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
            return;
        }
        int yOffset = 0;
        ResourceLocation[] images = this.formattedPages.get(this.currentPage).getImageResourceLocations();
        ResourceLocation[] blocks = this.formattedPages.get(this.currentPage).getBlockResourceLocations();
        Component chapterTitleComponent = this.formattedPages.get(this.currentPage).getChapterTitleComponent();
        if (chapterTitleComponent != null) {
            float f;
            float scaleFactor = 1.5f;
            float f2 = 230.0f / scaleFactor;
            Objects.requireNonNull(this.f_96547_);
            float f3 = f2 - 9.0f;
            if (this.formattedPages.get(this.currentPage).getPageFormattedTexts().isEmpty()) {
                f = 0.0f;
            } else {
                int n = this.formattedPages.get(this.currentPage).getPageFormattedTexts().size() + 1;
                Objects.requireNonNull(this.f_96547_);
                f = (float)(n * 9) / scaleFactor;
            }
            yOffset = (int)((f3 - f) * 0.5f);
            if (images != null) {
                yOffset = (int)((float)yOffset - 30.0f / scaleFactor);
            }
            if (blocks != null) {
                yOffset = (int)((float)yOffset - 30.0f / scaleFactor);
            }
            guiGraphics.m_280168_().m_85841_(scaleFactor, scaleFactor, 1.0f);
            guiGraphics.m_280614_(this.f_96547_, chapterTitleComponent, (int)(((float)this.f_96543_ / scaleFactor - (float)this.f_96547_.m_92852_((FormattedText)chapterTitleComponent)) * 0.5f), yOffset, 0, false);
            guiGraphics.m_280168_().m_85841_(1.0f / scaleFactor, 1.0f / scaleFactor, 1.0f);
            yOffset = (int)((float)yOffset * scaleFactor);
        }
        if (images != null) {
            this.renderImageCentered(guiGraphics, images[this.currentTick / IMAGE_CYCLE_DELAY % images.length], yOffset + 15);
            yOffset += 60;
        }
        if (blocks != null) {
            this.renderBlockCentered(guiGraphics, blocks[this.currentTick / IMAGE_CYCLE_DELAY % blocks.length], yOffset + 15);
            yOffset += 60;
        }
        if (!this.formattedPages.get(this.currentPage).getPageFormattedTexts().isEmpty()) {
            for (int i = 0; i < this.formattedPages.get(this.currentPage).getPageFormattedTexts().size(); ++i) {
                FormattedCharSequence formattedCharSequence = this.formattedPages.get(this.currentPage).getPageFormattedTexts().get(i);
                float x = chapterTitleComponent == null ? (float)startX + 36.0f : (float)(this.f_96543_ - this.f_96547_.m_92724_(formattedCharSequence)) * 0.5f;
                guiGraphics.m_280649_(this.f_96547_, formattedCharSequence, (int)x, 20 + yOffset + 9 * i, 0, false);
            }
            Style style = this.getComponentStyleAt(mouseX, mouseY);
            if (style != null) {
                guiGraphics.m_280304_(this.f_96547_, style, mouseX, mouseY);
            }
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    private void renderFrontCover(GuiGraphics guiGraphics) {
        int startX = (this.f_96543_ - 226) / 2;
        float scaleFactor = 1.35f;
        MutableComponent component = Component.m_237113_((String)"Energized Power").m_130940_(ChatFormatting.GOLD);
        int textWidth = this.f_96547_.m_92852_((FormattedText)component);
        guiGraphics.m_280168_().m_85841_(scaleFactor, scaleFactor, 1.0f);
        guiGraphics.m_280614_(this.f_96547_, (Component)component, (int)(((float)this.f_96543_ / scaleFactor - (float)textWidth) * 0.5f), (int)(30.0f / scaleFactor), 0, false);
        guiGraphics.m_280168_().m_85841_(1.0f / scaleFactor, 1.0f / scaleFactor, 1.0f);
        component = Component.m_237110_((String)"book.byAuthor", (Object[])new Object[]{"JDDev0"}).m_130940_(ChatFormatting.GOLD);
        textWidth = this.f_96547_.m_92852_((FormattedText)component);
        guiGraphics.m_280614_(this.f_96547_, (Component)component, (int)((float)(this.f_96543_ - textWidth) * 0.5f), 147, 0, false);
        for (int i = 0; i < this.formattedPages.get(this.currentPage).getPageFormattedTexts().size(); ++i) {
            FormattedCharSequence formattedCharSequence = this.formattedPages.get(this.currentPage).getPageFormattedTexts().get(i);
            guiGraphics.m_280649_(this.f_96547_, formattedCharSequence, startX + 36, 120 + 9 * i, 0, false);
        }
        this.renderImageCentered(guiGraphics, ENERGIZED_COPPER_INGOT, 48);
    }

    private void renderImageCentered(GuiGraphics guiGraphics, ResourceLocation image, int y) {
        float scaleFactor = 0.25f;
        if (y == -1) {
            y = (int)((230.0f - 256.0f * scaleFactor) * 0.5f) + 2;
        }
        guiGraphics.m_280168_().m_85841_(scaleFactor, scaleFactor, 1.0f);
        guiGraphics.m_280218_(image, (int)(((float)this.f_96543_ / scaleFactor - 256.0f) * 0.5f), (int)((float)y / scaleFactor), 0, 0, 256, 256);
        guiGraphics.m_280168_().m_85841_(1.0f / scaleFactor, 1.0f / scaleFactor, 1.0f);
    }

    private void renderBlockCentered(GuiGraphics guiGraphics, ResourceLocation blockResourceLocation, int y) {
        if (y == -1) {
            y = 85;
        }
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(blockResourceLocation);
        ItemStack itemStack = new ItemStack((ItemLike)block);
        ItemRenderer itemRenderer = this.f_96541_.m_91291_();
        TextureManager textureManager = this.f_96541_.m_91097_();
        BakedModel bakedModel = itemRenderer.m_174264_(itemStack, null, null, 0);
        textureManager.m_118506_(InventoryMenu.f_39692_).m_117960_(false, false);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)((int)((float)this.f_96543_ * 0.5f)), (float)y + 32.0f, 50.0f);
        guiGraphics.m_280168_().m_85841_(64.0f, -64.0f, 1.0f);
        MultiBufferSource.BufferSource bufferSource = this.f_96541_.m_91269_().m_110104_();
        Lighting.m_166384_();
        itemRenderer.m_115143_(itemStack, ItemDisplayContext.GUI, false, guiGraphics.m_280168_(), (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_, bakedModel);
        bufferSource.m_109911_();
        RenderSystem.enableDepthTest();
        guiGraphics.m_280168_().m_85849_();
    }

    private Style getComponentStyleAt(double x, double y) {
        if (this.formattedPages == null || this.formattedPages.get(this.currentPage).getPageFormattedTexts().isEmpty()) {
            return null;
        }
        int componentX = Mth.m_14107_((double)(x - (double)(this.f_96543_ - 226) * 0.5 - 36.0));
        int componentY = Mth.m_14107_((double)(y - 20.0));
        if (this.currentPage > 0 && this.currentPage < this.getPageCount() - 1) {
            ResourceLocation[] images = this.formattedPages.get(this.currentPage).getImageResourceLocations();
            ResourceLocation[] blocks = this.formattedPages.get(this.currentPage).getBlockResourceLocations();
            Component chapterTitleComponent = this.formattedPages.get(this.currentPage).getChapterTitleComponent();
            if (chapterTitleComponent != null) {
                float f;
                float scaleFactor = 1.5f;
                float f2 = 230.0f / scaleFactor;
                Objects.requireNonNull(this.f_96547_);
                float f3 = f2 - 9.0f;
                if (this.formattedPages.get(this.currentPage).getPageFormattedTexts().isEmpty()) {
                    f = 0.0f;
                } else {
                    int n = this.formattedPages.get(this.currentPage).getPageFormattedTexts().size() + 1;
                    Objects.requireNonNull(this.f_96547_);
                    f = (float)(n * 9) / scaleFactor;
                }
                componentY = -((int)((f3 - f) * 0.5f));
                if (images != null) {
                    componentY = (int)((float)componentY + 30.0f / scaleFactor);
                }
                if (blocks != null) {
                    componentY = (int)((float)componentY + 30.0f / scaleFactor);
                }
                componentY = (int)((float)componentY * scaleFactor);
                componentY += Mth.m_14107_((double)(y - 20.0));
            }
            if (images != null) {
                componentY -= 60;
            }
            if (blocks != null) {
                componentY -= 60;
            }
            if (chapterTitleComponent != null) {
                int componentIndex = componentY / 9;
                if (componentIndex < 0 || componentIndex >= this.formattedPages.get(this.currentPage).getPageFormattedTexts().size()) {
                    return null;
                }
                FormattedCharSequence formattedCharSequence = this.formattedPages.get(this.currentPage).getPageFormattedTexts().get(componentIndex);
                componentX = Mth.m_14107_((double)(x - (double)((float)(this.f_96543_ - this.f_96547_.m_92724_(formattedCharSequence)) * 0.5f)));
            }
        }
        if (componentX < 0 || componentY < 0) {
            return null;
        }
        int componentCount = this.formattedPages.get(this.currentPage).getPageFormattedTexts().size();
        if (componentX > 178 || componentY >= 9 * componentCount + componentCount) {
            return null;
        }
        int componentIndex = componentY / 9;
        if (componentIndex >= this.formattedPages.get(this.currentPage).getPageFormattedTexts().size()) {
            return null;
        }
        return this.f_96541_.f_91062_.m_92865_().m_92338_(this.formattedPages.get(this.currentPage).getPageFormattedTexts().get(componentIndex), componentX);
    }

    public boolean m_7043_() {
        return this.lecternBlockEntity == null;
    }

    public void m_86600_() {
        ++this.currentTick;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class FormattedPageContent {
        private final ResourceLocation pageId;
        private final Component chapterTitleComponent;
        private final List<FormattedCharSequence> pageFormattedTexts;
        private final ResourceLocation[] imageResourceLocations;
        private final ResourceLocation[] blockResourceLocations;

        public FormattedPageContent(ResourceLocation pageId, Component chapterTitleComponent, List<FormattedCharSequence> pageFormattedTexts, ResourceLocation[] imageResourceLocations, ResourceLocation[] blockResourceLocations) {
            this.pageId = pageId;
            this.chapterTitleComponent = chapterTitleComponent;
            this.pageFormattedTexts = pageFormattedTexts;
            this.imageResourceLocations = imageResourceLocations;
            this.blockResourceLocations = blockResourceLocations;
        }

        public ResourceLocation getPageId() {
            return this.pageId;
        }

        public Component getChapterTitleComponent() {
            return this.chapterTitleComponent;
        }

        public List<FormattedCharSequence> getPageFormattedTexts() {
            return this.pageFormattedTexts;
        }

        public ResourceLocation[] getImageResourceLocations() {
            return this.imageResourceLocations;
        }

        public ResourceLocation[] getBlockResourceLocations() {
            return this.blockResourceLocations;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class PageContent {
        private final ResourceLocation pageId;
        private final Component chapterTitleComponent;
        private final Component pageComponent;
        private final ResourceLocation[] imageResourceLocations;
        private final ResourceLocation[] blockResourceLocations;

        public PageContent(ResourceLocation pageId, Component chapterTitleComponent, Component pageComponent, ResourceLocation[] imageResourceLocations, ResourceLocation[] blockResourceLocations) {
            this.pageId = pageId;
            this.chapterTitleComponent = chapterTitleComponent;
            this.pageComponent = pageComponent;
            this.imageResourceLocations = imageResourceLocations;
            this.blockResourceLocations = blockResourceLocations;
        }

        public ResourceLocation getPageId() {
            return this.pageId;
        }

        public Component getChapterTitleComponent() {
            return this.chapterTitleComponent;
        }

        public Component getPageComponent() {
            return this.pageComponent;
        }

        public ResourceLocation[] getImageResourceLocations() {
            return this.imageResourceLocations;
        }

        public ResourceLocation[] getBlockResourceLocations() {
            return this.blockResourceLocations;
        }
    }
}

