/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen;

import me.jddev0.ep.block.ModBlocks;
import me.jddev0.ep.block.entity.DrainBlockEntity;
import me.jddev0.ep.screen.ModMenuTypes;
import me.jddev0.ep.util.ByteUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;

public class DrainMenu
extends AbstractContainerMenu {
    private final DrainBlockEntity blockEntity;
    private final Level level;
    private final ContainerData data;

    public DrainMenu(int id, Inventory inv, FriendlyByteBuf buffer) {
        this(id, inv, inv.f_35978_.m_9236_().m_7702_(buffer.m_130135_()), (ContainerData)new SimpleContainerData(4));
    }

    public DrainMenu(int id, Inventory inv, BlockEntity blockEntity, ContainerData data) {
        super((MenuType)ModMenuTypes.DRAIN_MENU.get(), id);
        DrainMenu.m_38886_((ContainerData)data, (int)4);
        this.blockEntity = (DrainBlockEntity)blockEntity;
        this.level = inv.f_35978_.m_9236_();
        this.data = data;
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        this.m_38884_(this.data);
    }

    public FluidStack getFluid() {
        return this.blockEntity.getFluid(0);
    }

    public int getTankCapacity() {
        return this.blockEntity.getTankCapacity(0);
    }

    public boolean isDraining() {
        return ByteUtils.from2ByteChunks((short)this.data.m_6413_(0), (short)this.data.m_6413_(1)) > 0;
    }

    public ItemStack m_7648_(Player player, int index) {
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player player) {
        return DrainMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)player, (Block)((Block)ModBlocks.DRAIN.get()));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public BlockEntity getBlockEntity() {
        return this.blockEntity;
    }
}

