/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen;

import java.util.ArrayList;
import java.util.Optional;
import me.jddev0.ep.screen.AdvancedCrusherMenu;
import me.jddev0.ep.screen.base.ConfigurableUpgradableEnergyStorageContainerScreen;
import me.jddev0.ep.util.FluidUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AdvancedCrusherScreen
extends ConfigurableUpgradableEnergyStorageContainerScreen<AdvancedCrusherMenu> {
    public AdvancedCrusherScreen(AdvancedCrusherMenu menu, Inventory inventory, Component component) {
        super(menu, inventory, component, "tooltip.energizedpower.recipe.energy_required_to_finish.txt", new ResourceLocation("energizedpower", "textures/gui/container/advanced_crusher.png"), new ResourceLocation("energizedpower", "textures/gui/container/upgrade_view/1_speed_1_energy_efficiency_1_energy_capacity.png"));
    }

    @Override
    protected void renderBgNormalView(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        super.renderBgNormalView(guiGraphics, partialTick, mouseX, mouseY);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        for (int i = 0; i < 2; ++i) {
            this.renderFluidMeterContent(guiGraphics, ((AdvancedCrusherMenu)this.f_97732_).getFluid(i), ((AdvancedCrusherMenu)this.f_97732_).getTankCapacity(i), x + (i == 0 ? 44 : 152), y + 17, 16, 52);
            this.renderFluidMeterOverlay(guiGraphics, x, y, i);
        }
        this.renderProgressArrow(guiGraphics, x, y);
    }

    private void renderFluidMeterOverlay(GuiGraphics guiGraphics, int x, int y, int tank) {
        guiGraphics.m_280218_(this.TEXTURE, x + (tank == 0 ? 44 : 152), y + 17, 176, 53, 16, 52);
    }

    private void renderProgressArrow(GuiGraphics guiGraphics, int x, int y) {
        if (((AdvancedCrusherMenu)this.f_97732_).isCraftingActive()) {
            guiGraphics.m_280218_(this.TEXTURE, x + 90, y + 34, 176, 106, ((AdvancedCrusherMenu)this.f_97732_).getScaledProgressArrowSize(), 17);
        }
    }

    @Override
    protected void renderTooltipNormalView(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderTooltipNormalView(guiGraphics, mouseX, mouseY);
        for (int i = 0; i < 2; ++i) {
            if (!this.m_6774_(i == 0 ? 44 : 152, 17, 16, 52, mouseX, mouseY)) continue;
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>(2);
            boolean fluidEmpty = ((AdvancedCrusherMenu)this.f_97732_).getFluid(i).isEmpty();
            int fluidAmount = fluidEmpty ? 0 : ((AdvancedCrusherMenu)this.f_97732_).getFluid(i).getAmount();
            MutableComponent tooltipComponent = Component.m_237110_((String)"tooltip.energizedpower.fluid_meter.content_amount.txt", (Object[])new Object[]{FluidUtils.getFluidAmountWithPrefix(fluidAmount), FluidUtils.getFluidAmountWithPrefix(((AdvancedCrusherMenu)this.f_97732_).getTankCapacity(i))});
            if (!fluidEmpty) {
                tooltipComponent = Component.m_237115_((String)((AdvancedCrusherMenu)this.f_97732_).getFluid(i).getTranslationKey()).m_130946_(" ").m_7220_((Component)tooltipComponent);
            }
            components.add(tooltipComponent);
            guiGraphics.m_280677_(this.f_96547_, components, Optional.empty(), mouseX, mouseY);
        }
    }
}

