/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.recipe;

import com.google.gson.JsonObject;
import me.jddev0.ep.block.ModBlocks;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class StoneSolidifierRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final ItemStack output;
    private final int waterAmount;
    private final int lavaAmount;

    public StoneSolidifierRecipe(ResourceLocation id, ItemStack output, int waterAmount, int lavaAmount) {
        this.id = id;
        this.output = output;
        this.waterAmount = waterAmount;
        this.lavaAmount = lavaAmount;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public int getWaterAmount() {
        return this.waterAmount;
    }

    public int getLavaAmount() {
        return this.lavaAmount;
    }

    public boolean m_5818_(Container container, Level level) {
        return false;
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return this.output;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.output.m_41777_();
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)ModBlocks.STONE_SOLIDIFIER.get());
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public boolean m_5598_() {
        return true;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static final class Serializer
    implements RecipeSerializer<StoneSolidifierRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("energizedpower", "stone_solidifier");

        private Serializer() {
        }

        public StoneSolidifierRecipe fromJson(ResourceLocation recipeID, JsonObject json) {
            int waterAmount = json.get("waterAmount").getAsInt();
            int lavaAmount = json.get("lavaAmount").getAsInt();
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output"));
            return new StoneSolidifierRecipe(recipeID, output, waterAmount, lavaAmount);
        }

        public StoneSolidifierRecipe fromNetwork(ResourceLocation recipeID, FriendlyByteBuf buffer) {
            int waterAmount = buffer.readInt();
            int lavaAmount = buffer.readInt();
            ItemStack output = buffer.m_130267_();
            return new StoneSolidifierRecipe(recipeID, output, waterAmount, lavaAmount);
        }

        public void toNetwork(FriendlyByteBuf buffer, StoneSolidifierRecipe recipe) {
            buffer.writeInt(recipe.waterAmount);
            buffer.writeInt(recipe.lavaAmount);
            buffer.writeItemStack(recipe.output, false);
        }
    }

    public static final class Type
    implements RecipeType<StoneSolidifierRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "stone_solidifier";

        private Type() {
        }
    }
}

