/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import me.jddev0.ep.block.ModBlocks;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class PlantGrowthChamberRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final OutputItemStackWithPercentages[] outputs;
    private final Ingredient input;
    private final int ticks;

    public PlantGrowthChamberRecipe(ResourceLocation id, OutputItemStackWithPercentages[] outputs, Ingredient input, int ticks) {
        this.id = id;
        this.outputs = outputs;
        this.input = input;
        this.ticks = ticks;
    }

    public OutputItemStackWithPercentages[] getOutputs() {
        return this.outputs;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public int getTicks() {
        return this.ticks;
    }

    public ItemStack[] getMaxOutputCounts() {
        ItemStack[] generatedOutputs = new ItemStack[this.outputs.length];
        for (int i = 0; i < this.outputs.length; ++i) {
            OutputItemStackWithPercentages output = this.outputs[i];
            generatedOutputs[i] = output.output.m_255036_(output.percentages.length);
        }
        return generatedOutputs;
    }

    public ItemStack[] generateOutputs(RandomSource randomSource) {
        ItemStack[] generatedOutputs = new ItemStack[this.outputs.length];
        for (int i = 0; i < this.outputs.length; ++i) {
            int count = 0;
            OutputItemStackWithPercentages output = this.outputs[i];
            for (double percentage : output.percentages) {
                if (!(randomSource.m_188500_() <= percentage)) continue;
                ++count;
            }
            generatedOutputs[i] = output.output.m_255036_(count);
        }
        return generatedOutputs;
    }

    public boolean m_5818_(Container container, Level level) {
        if (level.f_46443_) {
            return false;
        }
        return this.input.test(container.m_8020_(0));
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList ingredients = NonNullList.m_182647_((int)1);
        ingredients.add(0, (Object)this.input);
        return ingredients;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)ModBlocks.PLANT_GROWTH_CHAMBER_ITEM.get());
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public boolean m_5598_() {
        return true;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public record OutputItemStackWithPercentages(ItemStack output, double[] percentages) {
    }

    public static final class Serializer
    implements RecipeSerializer<PlantGrowthChamberRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("energizedpower", "plant_growth_chamber");

        private Serializer() {
        }

        public PlantGrowthChamberRecipe fromJson(ResourceLocation recipeID, JsonObject json) {
            Ingredient input = Ingredient.m_43917_((JsonElement)json.get("ingredient"));
            int ticks = GsonHelper.m_13927_((JsonObject)json, (String)"ticks");
            JsonArray outputsJson = GsonHelper.m_13933_((JsonObject)json, (String)"outputs");
            OutputItemStackWithPercentages[] outputs = new OutputItemStackWithPercentages[outputsJson.size()];
            for (int i = 0; i < outputsJson.size(); ++i) {
                JsonObject outputJson = outputsJson.get(i).getAsJsonObject();
                ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)outputJson, (String)"output"));
                JsonArray percentagesJson = GsonHelper.m_13933_((JsonObject)outputJson, (String)"percentages");
                double[] percentages = new double[percentagesJson.size()];
                for (int j = 0; j < percentagesJson.size(); ++j) {
                    percentages[j] = percentagesJson.get(j).getAsDouble();
                }
                outputs[i] = new OutputItemStackWithPercentages(output, percentages);
            }
            return new PlantGrowthChamberRecipe(recipeID, outputs, input, ticks);
        }

        public PlantGrowthChamberRecipe fromNetwork(ResourceLocation recipeID, FriendlyByteBuf buffer) {
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int ticks = buffer.readInt();
            int outputCount = buffer.readInt();
            OutputItemStackWithPercentages[] outputs = new OutputItemStackWithPercentages[outputCount];
            for (int i = 0; i < outputCount; ++i) {
                ItemStack output = buffer.m_130267_();
                int percentageCount = buffer.readInt();
                double[] percentages = new double[percentageCount];
                for (int j = 0; j < percentageCount; ++j) {
                    percentages[j] = buffer.readDouble();
                }
                outputs[i] = new OutputItemStackWithPercentages(output, percentages);
            }
            return new PlantGrowthChamberRecipe(recipeID, outputs, input, ticks);
        }

        public void toNetwork(FriendlyByteBuf buffer, PlantGrowthChamberRecipe recipe) {
            recipe.input.m_43923_(buffer);
            buffer.writeInt(recipe.ticks);
            buffer.writeInt(recipe.outputs.length);
            for (OutputItemStackWithPercentages output : recipe.outputs) {
                buffer.writeItemStack(output.output, false);
                buffer.writeInt(output.percentages.length);
                for (double percentage : output.percentages) {
                    buffer.writeDouble(percentage);
                }
            }
        }
    }

    public static final class Type
    implements RecipeType<PlantGrowthChamberRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "plant_growth_chamber";

        private Type() {
        }
    }
}

