/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.LinkedList;
import java.util.List;
import me.jddev0.ep.block.ModBlocks;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;

public class HeatGeneratorRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final Fluid[] input;
    private final int energyProduction;

    public HeatGeneratorRecipe(ResourceLocation id, Fluid[] input, int energyProduction) {
        this.id = id;
        this.input = input;
        this.energyProduction = energyProduction;
    }

    public Fluid[] getInput() {
        return this.input;
    }

    public int getEnergyProduction() {
        return this.energyProduction;
    }

    public boolean m_5818_(Container container, Level level) {
        return false;
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)ModBlocks.HEAT_GENERATOR_ITEM.get());
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public boolean m_5598_() {
        return true;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static final class Serializer
    implements RecipeSerializer<HeatGeneratorRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("energizedpower", "heat_generator");

        private Serializer() {
        }

        private void addFluidsFromJsonElement(JsonElement inputJson, List<Fluid> inputFluids) {
            if (!inputJson.isJsonPrimitive() || !inputJson.getAsJsonPrimitive().isString()) {
                throw new JsonSyntaxException("Input must be a single fluid or a list of at least one fluid");
            }
            ResourceLocation fluidId = ResourceLocation.m_135820_((String)inputJson.getAsJsonPrimitive().getAsString());
            Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(fluidId);
            if (fluid == null) {
                throw new JsonSyntaxException("Unknown fluid '" + fluidId + "'");
            }
            inputFluids.add(fluid);
        }

        public HeatGeneratorRecipe fromJson(ResourceLocation recipeID, JsonObject json) {
            LinkedList<Fluid> input = new LinkedList<Fluid>();
            JsonElement inputJson = json.get("input");
            if (inputJson.isJsonPrimitive()) {
                this.addFluidsFromJsonElement(inputJson, input);
            } else if (inputJson.isJsonArray()) {
                JsonArray inputJsonArray = inputJson.getAsJsonArray();
                if (inputJsonArray.isEmpty()) {
                    throw new JsonSyntaxException("Input must contain at least one fluid");
                }
                for (JsonElement inputJsonEle : inputJsonArray) {
                    this.addFluidsFromJsonElement(inputJsonEle, input);
                }
            } else {
                throw new JsonSyntaxException("Input must be a single fluid or a list of at least one fluid");
            }
            int energyProduction = GsonHelper.m_13927_((JsonObject)json, (String)"energy");
            return new HeatGeneratorRecipe(recipeID, input.toArray(new Fluid[0]), energyProduction);
        }

        public HeatGeneratorRecipe fromNetwork(ResourceLocation recipeID, FriendlyByteBuf buffer) {
            int fluidCount = buffer.readInt();
            Fluid[] input = new Fluid[fluidCount];
            for (int i = 0; i < fluidCount; ++i) {
                input[i] = (Fluid)ForgeRegistries.FLUIDS.getValue(buffer.m_130281_());
            }
            int energyProduction = buffer.readInt();
            return new HeatGeneratorRecipe(recipeID, input, energyProduction);
        }

        public void toNetwork(FriendlyByteBuf buffer, HeatGeneratorRecipe recipe) {
            buffer.writeInt(recipe.getInput().length);
            for (Fluid fluid : recipe.input) {
                ResourceLocation fluidId = ForgeRegistries.FLUIDS.getKey((Object)fluid);
                if (fluidId == null) {
                    throw new IllegalArgumentException("Unregistered fluid '" + fluid + "'");
                }
                buffer.m_130085_(fluidId);
            }
            buffer.writeInt(recipe.energyProduction);
        }
    }

    public static final class Type
    implements RecipeType<HeatGeneratorRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "heat_generator";

        private Type() {
        }
    }
}

