/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import me.jddev0.ep.block.ModBlocks;
import me.jddev0.ep.block.entity.FluidTransposerBlockEntity;
import me.jddev0.ep.util.FluidStackUtils;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;

public class FluidTransposerRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final FluidTransposerBlockEntity.Mode mode;
    private final ItemStack output;
    private final Ingredient input;
    private final FluidStack fluid;

    public FluidTransposerRecipe(ResourceLocation id, FluidTransposerBlockEntity.Mode mode, ItemStack output, Ingredient input, FluidStack fluid) {
        this.id = id;
        this.mode = mode;
        this.output = output;
        this.input = input;
        this.fluid = fluid;
    }

    public FluidTransposerBlockEntity.Mode getMode() {
        return this.mode;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public boolean m_5818_(Container container, Level level) {
        if (level.f_46443_) {
            return false;
        }
        return this.input.test(container.m_8020_(0));
    }

    public ItemStack m_5874_(Container container, RegistryAccess registries) {
        return this.output;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registries) {
        return this.output.m_41777_();
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList ingredients = NonNullList.m_182647_((int)1);
        ingredients.add(0, (Object)this.input);
        return ingredients;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)ModBlocks.FLUID_TRANSPOSER_ITEM.get());
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public boolean m_5598_() {
        return true;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static final class Serializer
    implements RecipeSerializer<FluidTransposerRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("energizedpower", "fluid_transposer");

        private Serializer() {
        }

        public FluidTransposerRecipe fromJson(ResourceLocation recipeID, JsonObject json) {
            FluidTransposerBlockEntity.Mode mode = FluidTransposerBlockEntity.Mode.valueOf(GsonHelper.m_13906_((JsonObject)json, (String)"mode"));
            Ingredient input = Ingredient.m_43917_((JsonElement)json.get("ingredient"));
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output"));
            FluidStack fluid = FluidStackUtils.fromJson(json.get("fluid"));
            return new FluidTransposerRecipe(recipeID, mode, output, input, fluid);
        }

        public FluidTransposerRecipe fromNetwork(ResourceLocation recipeID, FriendlyByteBuf buffer) {
            FluidTransposerBlockEntity.Mode mode = (FluidTransposerBlockEntity.Mode)buffer.m_130066_(FluidTransposerBlockEntity.Mode.class);
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack output = buffer.m_130267_();
            FluidStack fluid = buffer.readFluidStack();
            return new FluidTransposerRecipe(recipeID, mode, output, input, fluid);
        }

        public void toNetwork(FriendlyByteBuf buffer, FluidTransposerRecipe recipe) {
            buffer.m_130068_((Enum)recipe.mode);
            recipe.input.m_43923_(buffer);
            buffer.writeItemStack(recipe.output, false);
            buffer.writeFluidStack(recipe.fluid);
        }
    }

    public static final class Type
    implements RecipeType<FluidTransposerRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "fluid_transposer";

        private Type() {
        }
    }
}

