/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.networking.packet;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.jddev0.ep.block.entity.PressMoldMakerBlockEntity;
import me.jddev0.ep.recipe.PressMoldMakerRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class SyncPressMoldMakerRecipeListS2CPacket {
    private final BlockPos pos;
    private final List<Pair<PressMoldMakerRecipe, Boolean>> recipeList;

    public SyncPressMoldMakerRecipeListS2CPacket(BlockPos pos, List<Pair<PressMoldMakerRecipe, Boolean>> recipeList) {
        this.pos = pos;
        this.recipeList = recipeList;
    }

    public SyncPressMoldMakerRecipeListS2CPacket(FriendlyByteBuf buffer) {
        this.pos = buffer.m_130135_();
        int size = buffer.readInt();
        this.recipeList = IntStream.range(0, size).mapToObj(i -> Pair.of((Object)PressMoldMakerRecipe.Serializer.INSTANCE.fromNetwork(buffer.m_130281_(), buffer), (Object)buffer.readBoolean())).collect(Collectors.toList());
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.writeInt(this.recipeList.size());
        this.recipeList.forEach(entry -> {
            buffer.m_130085_(((PressMoldMakerRecipe)entry.getFirst()).m_6423_());
            PressMoldMakerRecipe.Serializer.INSTANCE.toNetwork(buffer, (PressMoldMakerRecipe)entry.getFirst());
            buffer.writeBoolean(((Boolean)entry.getSecond()).booleanValue());
        });
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            BlockEntity blockEntity = Minecraft.m_91087_().f_91073_.m_7702_(this.pos);
            if (blockEntity instanceof PressMoldMakerBlockEntity) {
                PressMoldMakerBlockEntity pressMoldMakerBlockEntity = (PressMoldMakerBlockEntity)blockEntity;
                pressMoldMakerBlockEntity.setRecipeList(this.recipeList);
            }
        });
        return true;
    }
}

