/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.networking.packet;

import java.util.function.Supplier;
import me.jddev0.ep.recipe.FurnaceRecipeTypePacketUpdate;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public final class SyncFurnaceRecipeTypeS2CPacket {
    private final RecipeType<? extends AbstractCookingRecipe> recipeType;
    private final BlockPos pos;

    public SyncFurnaceRecipeTypeS2CPacket(RecipeType<? extends AbstractCookingRecipe> recipeType, BlockPos pos) {
        this.recipeType = recipeType;
        this.pos = pos;
    }

    public SyncFurnaceRecipeTypeS2CPacket(FriendlyByteBuf buffer) {
        this.recipeType = buffer.readBoolean() ? BuiltInRegistries.f_256990_.m_6612_(buffer.m_130281_()).orElse(RecipeType.f_44108_) : RecipeType.f_44108_;
        this.pos = buffer.m_130135_();
    }

    public void toBytes(FriendlyByteBuf buffer) {
        ResourceLocation recipeTypeKey = BuiltInRegistries.f_256990_.m_7981_(this.recipeType);
        if (recipeTypeKey == null) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            buffer.m_130085_(recipeTypeKey);
        }
        buffer.m_130064_(this.pos);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            BlockEntity blockEntity = Minecraft.m_91087_().f_91073_.m_7702_(this.pos);
            if (blockEntity instanceof FurnaceRecipeTypePacketUpdate) {
                FurnaceRecipeTypePacketUpdate recipeTypePacketUpdate = (FurnaceRecipeTypePacketUpdate)blockEntity;
                recipeTypePacketUpdate.setRecipeType(this.recipeType);
            }
        });
        return true;
    }
}

