/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.networking.packet;

import java.util.function.Supplier;
import me.jddev0.ep.block.entity.FluidTankBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.network.NetworkEvent;

public class SetFluidTankFilterC2SPacket {
    private final BlockPos pos;
    private final FluidStack fluidFilter;

    public SetFluidTankFilterC2SPacket(BlockPos pos, FluidStack fluidFilter) {
        this.pos = pos;
        this.fluidFilter = fluidFilter;
    }

    public SetFluidTankFilterC2SPacket(FriendlyByteBuf buffer) {
        this.pos = buffer.m_130135_();
        this.fluidFilter = buffer.readFluidStack();
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.writeFluidStack(this.fluidFilter);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            Level level = context.getSender().m_9236_();
            if (!level.m_7232_(SectionPos.m_123171_((int)this.pos.m_123341_()), SectionPos.m_123171_((int)this.pos.m_123343_()))) {
                return;
            }
            BlockEntity blockEntity = level.m_7702_(this.pos);
            if (!(blockEntity instanceof FluidTankBlockEntity)) {
                return;
            }
            FluidTankBlockEntity fluidTankBlockEntity = (FluidTankBlockEntity)blockEntity;
            fluidTankBlockEntity.setFluidFilter(this.fluidFilter);
        });
    }
}

