/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.networking.packet;

import java.util.function.Supplier;
import me.jddev0.ep.block.entity.BlockPlacerBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class SetBlockPlacerCheckboxC2SPacket {
    private final BlockPos pos;
    private final int checkboxId;
    private final boolean checked;

    public SetBlockPlacerCheckboxC2SPacket(BlockPos pos, int checkboxId, boolean checked) {
        this.pos = pos;
        this.checkboxId = checkboxId;
        this.checked = checked;
    }

    public SetBlockPlacerCheckboxC2SPacket(FriendlyByteBuf buffer) {
        this.pos = buffer.m_130135_();
        this.checkboxId = buffer.readInt();
        this.checked = buffer.readBoolean();
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.writeInt(this.checkboxId);
        buffer.writeBoolean(this.checked);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            Level level = context.getSender().m_9236_();
            if (!level.m_7232_(SectionPos.m_123171_((int)this.pos.m_123341_()), SectionPos.m_123171_((int)this.pos.m_123343_()))) {
                return;
            }
            BlockEntity blockEntity = level.m_7702_(this.pos);
            if (!(blockEntity instanceof BlockPlacerBlockEntity)) {
                return;
            }
            BlockPlacerBlockEntity blockPlacerBlockEntity = (BlockPlacerBlockEntity)blockEntity;
            switch (this.checkboxId) {
                case 0: {
                    blockPlacerBlockEntity.setInverseRotation(this.checked);
                }
            }
        });
        return true;
    }
}

