/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.networking.packet;

import java.util.function.Supplier;
import me.jddev0.ep.screen.EnergizedPowerBookScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class OpenEnergizedPowerBookS2CPacket {
    private final BlockPos pos;

    public OpenEnergizedPowerBookS2CPacket(BlockPos pos) {
        this.pos = pos;
    }

    public OpenEnergizedPowerBookS2CPacket(FriendlyByteBuf buffer) {
        this.pos = buffer.m_130135_();
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            BlockEntity blockEntity = Minecraft.m_91087_().f_91073_.m_7702_(this.pos);
            if (blockEntity instanceof LecternBlockEntity) {
                LecternBlockEntity lecternBlockEntity = (LecternBlockEntity)blockEntity;
                this.showBookViewScreen(lecternBlockEntity);
            }
        });
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void showBookViewScreen(LecternBlockEntity lecternBlockEntity) {
        Minecraft.m_91087_().m_91152_((Screen)new EnergizedPowerBookScreen(lecternBlockEntity));
    }
}

