/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.networking.packet;

import java.util.function.Supplier;
import me.jddev0.ep.inventory.ItemStackPacketUpdate;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class ItemStackSyncS2CPacket {
    private final int slot;
    private final ItemStack itemStack;
    private final BlockPos pos;

    public ItemStackSyncS2CPacket(int slot, ItemStack itemStack, BlockPos pos) {
        this.slot = slot;
        this.itemStack = itemStack;
        this.pos = pos;
    }

    public ItemStackSyncS2CPacket(FriendlyByteBuf buffer) {
        this.slot = buffer.readInt();
        this.itemStack = buffer.m_130267_();
        this.pos = buffer.m_130135_();
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.writeInt(this.slot);
        buffer.writeItemStack(this.itemStack, false);
        buffer.m_130064_(this.pos);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            BlockEntity blockEntity = Minecraft.m_91087_().f_91073_.m_7702_(this.pos);
            if (blockEntity instanceof ItemStackPacketUpdate) {
                ItemStackPacketUpdate itemStackStorage = (ItemStackPacketUpdate)blockEntity;
                itemStackStorage.setItemStack(this.slot, this.itemStack);
            }
        });
        return true;
    }
}

