/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.networking.packet;

import java.util.function.Supplier;
import me.jddev0.ep.energy.EnergyStoragePacketUpdate;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class EnergySyncS2CPacket {
    private final int energy;
    private final int capacity;
    private final BlockPos pos;

    public EnergySyncS2CPacket(int energy, int capacity, BlockPos pos) {
        this.energy = energy;
        this.capacity = capacity;
        this.pos = pos;
    }

    public EnergySyncS2CPacket(FriendlyByteBuf buffer) {
        this.energy = buffer.readInt();
        this.capacity = buffer.readInt();
        this.pos = buffer.m_130135_();
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.writeInt(this.energy);
        buffer.writeInt(this.capacity);
        buffer.m_130064_(this.pos);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            BlockEntity blockEntity = Minecraft.m_91087_().f_91073_.m_7702_(this.pos);
            if (blockEntity instanceof EnergyStoragePacketUpdate) {
                EnergyStoragePacketUpdate energyStorage = (EnergyStoragePacketUpdate)blockEntity;
                energyStorage.setCapacity(this.capacity);
                energyStorage.setEnergy(this.energy);
            }
        });
        return true;
    }
}

