/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.item.energy;

import me.jddev0.ep.energy.IEnergizedPowerEnergyStorage;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemCapabilityEnergy
implements ICapabilityProvider,
IEnergyStorage {
    private final ItemStack itemStack;
    private final IEnergizedPowerEnergyStorage energyStorage;
    private final LazyOptional<IEnergyStorage> lazyEnergyStorage;

    public ItemCapabilityEnergy(ItemStack itemStack, @Nullable CompoundTag nbt, IEnergizedPowerEnergyStorage energyStorage) {
        this.itemStack = itemStack;
        this.energyStorage = energyStorage;
        if (nbt != null && nbt.m_128441_("energy")) {
            this.energyStorage.loadNBT(nbt.m_128423_("energy"));
        }
        this.lazyEnergyStorage = LazyOptional.of(() -> this);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyStorage.cast();
        }
        return LazyOptional.empty();
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int ret = this.energyStorage.receiveEnergy(maxReceive, simulate);
        if (!simulate) {
            this.itemStack.m_41784_().m_128365_("energy", this.energyStorage.saveNBT());
        }
        return ret;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int ret = this.energyStorage.extractEnergy(maxExtract, simulate);
        if (!simulate) {
            this.itemStack.m_41784_().m_128365_("energy", this.energyStorage.saveNBT());
        }
        return ret;
    }

    public int getEnergyStored() {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public boolean canExtract() {
        return this.energyStorage.canExtract();
    }

    public boolean canReceive() {
        return this.energyStorage.canReceive();
    }

    public void setEnergy(int energy) {
        this.energyStorage.setEnergy(energy);
        this.itemStack.m_41784_().m_128365_("energy", this.energyStorage.saveNBT());
    }

    public void setCapacity(int capacity) {
        this.energyStorage.setCapacity(capacity);
    }
}

