/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.item;

import java.util.List;
import me.jddev0.ep.block.ModBlocks;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class TeleporterMatrixItem
extends Item {
    public TeleporterMatrixItem(Item.Properties props) {
        super(props);
    }

    public static boolean isLinked(ItemStack itemStack) {
        if (!itemStack.m_41782_()) {
            return false;
        }
        CompoundTag nbt = itemStack.m_41783_();
        return nbt != null && nbt.m_128425_("x", 3) && nbt.m_128425_("y", 3) && nbt.m_128425_("z", 3) && nbt.m_128425_("dim", 8);
    }

    public static BlockPos getBlockPos(Level level, ItemStack itemStack) {
        if (level.f_46443_) {
            return null;
        }
        if (!TeleporterMatrixItem.isLinked(itemStack)) {
            return null;
        }
        CompoundTag nbt = itemStack.m_41783_();
        if (nbt == null) {
            return null;
        }
        return new BlockPos(nbt.m_128451_("x"), nbt.m_128451_("y"), nbt.m_128451_("z"));
    }

    public static Level getDimension(Level level, ItemStack itemStack) {
        if (level.f_46443_ || !(level instanceof ServerLevel)) {
            return null;
        }
        if (!TeleporterMatrixItem.isLinked(itemStack)) {
            return null;
        }
        CompoundTag nbt = itemStack.m_41783_();
        if (nbt == null) {
            return null;
        }
        ResourceLocation dimensionId = ResourceLocation.m_135820_((String)nbt.m_128461_("dim"));
        if (dimensionId == null) {
            return null;
        }
        ResourceKey dimensionKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)dimensionId);
        return level.m_7654_().m_129880_(dimensionKey);
    }

    public InteractionResult m_6225_(UseOnContext useOnContext) {
        Level level = useOnContext.m_43725_();
        if (level.f_46443_ || !(level instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        Player player = useOnContext.m_43723_();
        BlockPos blockPos = useOnContext.m_8083_();
        BlockState state = level.m_8055_(blockPos);
        ItemStack itemStack = useOnContext.m_43722_();
        CompoundTag nbt = itemStack.m_41784_();
        nbt.m_128405_("x", blockPos.m_123341_());
        nbt.m_128405_("y", blockPos.m_123342_());
        nbt.m_128405_("z", blockPos.m_123343_());
        nbt.m_128359_("dim", level.m_46472_().m_135782_().toString());
        if (state.m_60713_((Block)ModBlocks.TELEPORTER.get())) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237115_((String)"tooltip.energizedpower.teleporter_matrix.set").m_130940_(ChatFormatting.GREEN)));
            }
        } else if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237115_((String)"tooltip.energizedpower.teleporter_matrix.set.warning").m_130940_(ChatFormatting.YELLOW)));
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        if (level.f_46443_) {
            return InteractionResultHolder.m_19090_((Object)itemStack);
        }
        CompoundTag nbt = itemStack.m_41783_();
        if (nbt != null) {
            nbt.m_128473_("x");
            nbt.m_128473_("y");
            nbt.m_128473_("z");
            nbt.m_128473_("dim");
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237115_((String)"tooltip.energizedpower.teleporter_matrix.cleared").m_130940_(ChatFormatting.GREEN)));
        }
        return InteractionResultHolder.m_19090_((Object)itemStack);
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> components, TooltipFlag tooltipFlag) {
        CompoundTag nbt = itemStack.m_41783_();
        boolean linked = TeleporterMatrixItem.isLinked(itemStack);
        components.add((Component)Component.m_237115_((String)"tooltip.energizedpower.teleporter_matrix.status").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237115_((String)("tooltip.energizedpower.teleporter_matrix.status." + (linked ? "linked" : "unlinked"))).m_130940_(linked ? ChatFormatting.GREEN : ChatFormatting.RED)));
        if (linked) {
            components.add((Component)Component.m_237119_());
            components.add((Component)Component.m_237115_((String)"tooltip.energizedpower.teleporter_matrix.location").m_7220_((Component)Component.m_237113_((String)(nbt.m_128451_("x") + " " + nbt.m_128451_("y") + " " + nbt.m_128451_("z")))));
            components.add((Component)Component.m_237115_((String)"tooltip.energizedpower.teleporter_matrix.dimension").m_7220_((Component)Component.m_237113_((String)nbt.m_128461_("dim"))));
        }
        components.add((Component)Component.m_237119_());
        if (Screen.m_96638_()) {
            components.add((Component)Component.m_237115_((String)"tooltip.energizedpower.teleporter_matrix.txt.shift.1").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            components.add((Component)Component.m_237115_((String)"tooltip.energizedpower.teleporter_matrix.txt.shift.2").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        } else {
            components.add((Component)Component.m_237115_((String)"tooltip.energizedpower.shift_details.txt").m_130940_(ChatFormatting.YELLOW));
        }
    }

    public String m_5671_(ItemStack itemStack) {
        return this.m_5524_() + "." + (TeleporterMatrixItem.isLinked(itemStack) ? "linked" : "unlinked");
    }
}

