/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.item;

import java.util.Locale;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.item.upgrade.UpgradeModuleItem;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;

public class MoonLightUpgradeModuleItem
extends UpgradeModuleItem {
    private static final UpgradeModuleModifier[] UPGRADE_MODULE_MODIFIERS = new UpgradeModuleModifier[]{UpgradeModuleModifier.MOON_LIGHT};
    private static final double MOON_LIGHT_1_EFFECT = ModConfigs.COMMON_UPGRADE_MODULE_MOON_LIGHT_1_EFFECT.getValue();
    private static final double MOON_LIGHT_2_EFFECT = ModConfigs.COMMON_UPGRADE_MODULE_MOON_LIGHT_2_EFFECT.getValue();
    private static final double MOON_LIGHT_3_EFFECT = ModConfigs.COMMON_UPGRADE_MODULE_MOON_LIGHT_3_EFFECT.getValue();

    public MoonLightUpgradeModuleItem(Item.Properties props, int tier) {
        super(props, UpgradeModuleModifier.MOON_LIGHT, tier);
    }

    @Override
    @NotNull
    public @NotNull UpgradeModuleModifier @NotNull [] getUpgradeModuleModifiers() {
        return UPGRADE_MODULE_MODIFIERS;
    }

    @Override
    public double getUpgradeModuleModifierValue(UpgradeModuleModifier modifier) {
        return switch (modifier) {
            case UpgradeModuleModifier.MOON_LIGHT -> {
                switch (this.tier) {
                    case 1: {
                        yield MOON_LIGHT_1_EFFECT;
                    }
                    case 2: {
                        yield MOON_LIGHT_2_EFFECT;
                    }
                    case 3: {
                        yield MOON_LIGHT_3_EFFECT;
                    }
                }
                yield -1.0;
            }
            default -> -1.0;
        };
    }

    @Override
    public Component getUpgradeModuleModifierText(UpgradeModuleModifier modifier, double value) {
        return switch (modifier) {
            case UpgradeModuleModifier.MOON_LIGHT -> Component.m_237113_((String)String.format(Locale.US, "%.2f %%", 100.0 * value)).m_130940_(ChatFormatting.GREEN);
            default -> Component.m_237119_();
        };
    }
}

