/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.item;

import java.util.List;
import me.jddev0.ep.block.entity.TeleporterBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.ReceiveOnlyEnergyStorage;
import me.jddev0.ep.item.ModItems;
import me.jddev0.ep.item.TeleporterMatrixItem;
import me.jddev0.ep.item.energy.EnergizedPowerEnergyItem;
import me.jddev0.ep.screen.InventoryTeleporterMenu;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InventoryTeleporterItem
extends EnergizedPowerEnergyItem
implements MenuProvider {
    public static final int CAPACITY = ModConfigs.COMMON_INVENTORY_TELEPORTER_CAPACITY.getValue();
    public static final int MAX_RECEIVE = ModConfigs.COMMON_INVENTORY_TELEPORTER_TRANSFER_RATE.getValue();

    public InventoryTeleporterItem(Item.Properties props) {
        super(props, () -> new ReceiveOnlyEnergyStorage(0, CAPACITY, MAX_RECEIVE));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        if (interactionHand == InteractionHand.OFF_HAND) {
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        if (level.f_46443_ || !(player instanceof ServerPlayer)) {
            return InteractionResultHolder.m_19090_((Object)itemStack);
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (player.m_6144_()) {
            player.m_5893_((MenuProvider)this);
        } else {
            InventoryTeleporterItem.teleportPlayer(itemStack, serverPlayer);
        }
        return InteractionResultHolder.m_19090_((Object)itemStack);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.energizedpower.inventory_teleporter");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new InventoryTeleporterMenu(id, inventory, (Container)InventoryTeleporterItem.getInventory(inventory.m_36056_()));
    }

    @Override
    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> components, TooltipFlag tooltipFlag) {
        super.m_7373_(itemStack, level, components, tooltipFlag);
        SimpleContainer inventory = InventoryTeleporterItem.getInventory(itemStack);
        ItemStack teleporterMatrixItemStack = inventory.m_8020_(0);
        boolean linked = TeleporterMatrixItem.isLinked(teleporterMatrixItemStack);
        CompoundTag nbt = teleporterMatrixItemStack.m_41783_();
        components.add((Component)Component.m_237115_((String)"tooltip.energizedpower.teleporter_matrix.status").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237115_((String)("tooltip.energizedpower.teleporter_matrix.status." + (linked ? "linked" : "unlinked"))).m_130940_(linked ? ChatFormatting.GREEN : ChatFormatting.RED)));
        if (linked) {
            components.add((Component)Component.m_237119_());
            components.add((Component)Component.m_237115_((String)"tooltip.energizedpower.teleporter_matrix.location").m_7220_((Component)Component.m_237113_((String)(nbt.m_128451_("x") + " " + nbt.m_128451_("y") + " " + nbt.m_128451_("z")))));
            components.add((Component)Component.m_237115_((String)"tooltip.energizedpower.teleporter_matrix.dimension").m_7220_((Component)Component.m_237113_((String)nbt.m_128461_("dim"))));
        }
        components.add((Component)Component.m_237119_());
        if (Screen.m_96638_()) {
            components.add((Component)Component.m_237115_((String)"tooltip.energizedpower.inventory_teleporter.txt.shift.1").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            components.add((Component)Component.m_237115_((String)"tooltip.energizedpower.inventory_teleporter.txt.shift.2").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        } else {
            components.add((Component)Component.m_237115_((String)"tooltip.energizedpower.shift_details.txt").m_130940_(ChatFormatting.YELLOW));
        }
    }

    public static SimpleContainer getInventory(final ItemStack itemStack) {
        CompoundTag nbt = itemStack.m_41784_();
        if (nbt.m_128441_("inventory")) {
            NonNullList items = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
            ContainerHelper.m_18980_((CompoundTag)nbt.m_128469_("inventory"), (NonNullList)items);
            return new SimpleContainer((ItemStack[])items.toArray((Object[])new ItemStack[0])){

                public void m_6596_() {
                    super.m_6596_();
                    NonNullList items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
                    for (int i = 0; i < this.m_6643_(); ++i) {
                        items.set(i, (Object)this.m_8020_(i));
                    }
                    itemStack.m_41784_().m_128365_("inventory", (Tag)ContainerHelper.m_18973_((CompoundTag)new CompoundTag(), (NonNullList)items));
                }

                public boolean m_7013_(int slot, @NotNull ItemStack stack) {
                    if (slot >= 0 && slot < this.m_6643_()) {
                        return stack.m_150930_((Item)ModItems.TELEPORTER_MATRIX.get());
                    }
                    return super.m_7013_(slot, stack);
                }

                public boolean m_6542_(Player player) {
                    return super.m_6542_(player) && player.m_150109_().m_36056_() == itemStack;
                }

                public int m_6893_() {
                    return 1;
                }
            };
        }
        return new SimpleContainer(1){

            public void m_6596_() {
                super.m_6596_();
                NonNullList items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
                for (int i = 0; i < this.m_6643_(); ++i) {
                    items.set(i, (Object)this.m_8020_(i));
                }
                itemStack.m_41784_().m_128365_("inventory", (Tag)ContainerHelper.m_18973_((CompoundTag)new CompoundTag(), (NonNullList)items));
            }

            public boolean m_7013_(int slot, @NotNull ItemStack stack) {
                if (slot >= 0 && slot < this.m_6643_()) {
                    return stack.m_150930_((Item)ModItems.TELEPORTER_MATRIX.get());
                }
                return super.m_7013_(slot, stack);
            }

            public boolean m_6542_(Player player) {
                return super.m_6542_(player) && player.m_150109_().m_36056_() == itemStack;
            }

            public int m_6893_() {
                return 1;
            }
        };
    }

    public static void teleportPlayer(ItemStack itemStack, ServerPlayer player) {
        Level level = player.m_9236_();
        LazyOptional energyStorageLazyOptional = itemStack.getCapability(ForgeCapabilities.ENERGY);
        if (!energyStorageLazyOptional.isPresent()) {
            return;
        }
        IEnergyStorage energyStorage = (IEnergyStorage)energyStorageLazyOptional.orElse(null);
        SimpleContainer inventory = InventoryTeleporterItem.getInventory(itemStack);
        ItemStack teleporterMatrixItemStack = inventory.m_8020_(0);
        TeleporterBlockEntity.teleportPlayer(player, energyStorage, () -> InventoryTeleporterItem.setEnergy(itemStack, 0), teleporterMatrixItemStack, level, null);
    }
}

