/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.item;

import java.util.LinkedList;
import java.util.List;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.integration.curios.CuriosCompatUtils;
import me.jddev0.ep.screen.InventoryChargerMenu;
import me.jddev0.ep.util.EnergyUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InventoryChargerItem
extends Item
implements MenuProvider {
    public static final int SLOT_COUNT = ModConfigs.COMMON_INVENTORY_CHARGER_SLOT_COUNT.getValue();
    public static final boolean TRANSFER_RATE_LIMIT_ENABLED = ModConfigs.COMMON_INVENTORY_CHARGER_TRANSFER_RATE_LIMIT_ENABLED.getValue();
    public static final int TRANSFER_RATE_LIMIT = ModConfigs.COMMON_INVENTORY_CHARGER_TRANSFER_RATE_LIMIT.getValue();

    public InventoryChargerItem(Item.Properties props) {
        super(props);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        if (interactionHand == InteractionHand.OFF_HAND) {
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        if (level.f_46443_) {
            return InteractionResultHolder.m_19090_((Object)itemStack);
        }
        player.m_5893_((MenuProvider)this);
        return InteractionResultHolder.m_19090_((Object)itemStack);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.energizedpower.inventory_charger");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new InventoryChargerMenu(id, inventory, (Container)InventoryChargerItem.getInventory(inventory.m_36056_()));
    }

    public boolean m_142522_(ItemStack stack) {
        SimpleContainer inventory = InventoryChargerItem.getInventory(stack);
        return InventoryChargerItem.getCapacity((Container)inventory) > 0;
    }

    public int m_142158_(ItemStack stack) {
        SimpleContainer inventory = InventoryChargerItem.getInventory(stack);
        return Math.round((float)InventoryChargerItem.getEnergy((Container)inventory) * 13.0f / (float)InventoryChargerItem.getCapacity((Container)inventory));
    }

    public int m_142159_(ItemStack stack) {
        SimpleContainer inventory = InventoryChargerItem.getInventory(stack);
        float f = Math.max(0.0f, (float)InventoryChargerItem.getEnergy((Container)inventory) / (float)InventoryChargerItem.getCapacity((Container)inventory));
        return Mth.m_14169_((float)(f * 0.33f), (float)1.0f, (float)1.0f);
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> components, TooltipFlag tooltipFlag) {
        SimpleContainer inventory = InventoryChargerItem.getInventory(itemStack);
        int energy = InventoryChargerItem.getEnergy((Container)inventory);
        int capacity = InventoryChargerItem.getCapacity((Container)inventory);
        int maxTransfer = InventoryChargerItem.getMaxTransfer((Container)inventory);
        components.add((Component)Component.m_237110_((String)"tooltip.energizedpower.energy_meter.content.txt", (Object[])new Object[]{EnergyUtils.getEnergyWithPrefix(energy), EnergyUtils.getEnergyWithPrefix(capacity)}).m_130940_(ChatFormatting.GRAY));
        components.add((Component)Component.m_237110_((String)"tooltip.energizedpower.transfer_rate.txt", (Object[])new Object[]{EnergyUtils.getEnergyWithPrefix(maxTransfer)}).m_130940_(ChatFormatting.GRAY));
        if (Screen.m_96638_()) {
            components.add((Component)Component.m_237115_((String)"tooltip.energizedpower.inventory_charger.txt.shift.1").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        } else {
            components.add((Component)Component.m_237115_((String)"tooltip.energizedpower.shift_details.txt").m_130940_(ChatFormatting.YELLOW));
        }
    }

    private int addConsumerEnergyItem(List<IEnergyStorage> consumerItems, List<Integer> consumerEnergyValues, ItemStack itemStack, ItemStack testItemStack, Container inventoryChargerInventory) {
        LazyOptional energyStorageLazyOptional = testItemStack.getCapability(ForgeCapabilities.ENERGY);
        if (!energyStorageLazyOptional.isPresent()) {
            return 0;
        }
        IEnergyStorage energyStorage = (IEnergyStorage)energyStorageLazyOptional.orElse(null);
        if (!energyStorage.canReceive()) {
            return 0;
        }
        int received = energyStorage.receiveEnergy(InventoryChargerItem.getMaxTransfer(inventoryChargerInventory), true);
        if (received <= 0) {
            return 0;
        }
        consumerItems.add(energyStorage);
        consumerEnergyValues.add(received);
        return received;
    }

    private void distributeEnergy(ItemStack itemStack, Level level, Inventory inventory, int slot, boolean selected) {
        SimpleContainer inventoryChargerInventory = InventoryChargerItem.getInventory(itemStack);
        LinkedList<IEnergyStorage> consumerItems = new LinkedList<IEnergyStorage>();
        LinkedList<Integer> consumerEnergyValues = new LinkedList<Integer>();
        int consumptionSum = 0;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            if (i == slot) continue;
            ItemStack testItemStack = inventory.m_8020_(i);
            consumptionSum += this.addConsumerEnergyItem(consumerItems, consumerEnergyValues, itemStack, testItemStack, (Container)inventoryChargerInventory);
        }
        List<ItemStack> curiosItemStacks = CuriosCompatUtils.getCuriosItemStacks(inventory);
        for (ItemStack testItemStack : curiosItemStacks) {
            consumptionSum += this.addConsumerEnergyItem(consumerItems, consumerEnergyValues, itemStack, testItemStack, (Container)inventoryChargerInventory);
        }
        LinkedList<Integer> consumerEnergyDistributed = new LinkedList<Integer>();
        for (int i = 0; i < consumerItems.size(); ++i) {
            consumerEnergyDistributed.add(0);
        }
        int consumptionLeft = Math.min(InventoryChargerItem.getMaxTransfer((Container)inventoryChargerInventory), consumptionSum);
        this.extractEnergyFromBatteries(consumptionLeft, (Container)inventoryChargerInventory);
        int divisor = consumerItems.size();
        block3: while (consumptionLeft > 0) {
            int consumptionPerConsumer = consumptionLeft / divisor;
            if (consumptionPerConsumer == 0) {
                divisor = Math.max(1, divisor - 1);
                consumptionPerConsumer = consumptionLeft / divisor;
            }
            for (int i = 0; i < consumerEnergyValues.size(); ++i) {
                int consumptionDistributed = (Integer)consumerEnergyDistributed.get(i);
                int consumptionOfConsumerLeft = (Integer)consumerEnergyValues.get(i) - consumptionDistributed;
                int consumptionDistributedNew = Math.min(consumptionOfConsumerLeft, Math.min(consumptionPerConsumer, consumptionLeft));
                consumerEnergyDistributed.set(i, consumptionDistributed + consumptionDistributedNew);
                if ((consumptionLeft -= consumptionDistributedNew) == 0) break block3;
            }
        }
        for (int i = 0; i < consumerItems.size(); ++i) {
            int energy = (Integer)consumerEnergyDistributed.get(i);
            if (energy <= 0) continue;
            ((IEnergyStorage)consumerItems.get(i)).receiveEnergy(energy, false);
        }
    }

    public void extractEnergyFromBatteries(int energyProductionLeft, Container inventory) {
        LinkedList<IEnergyStorage> energyProduction = new LinkedList<IEnergyStorage>();
        LinkedList<Integer> energyProductionValues = new LinkedList<Integer>();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            IEnergyStorage energyStorage;
            int extracted;
            ItemStack stack = inventory.m_8020_(i);
            LazyOptional energyStorageLazyOptional = stack.getCapability(ForgeCapabilities.ENERGY);
            if (!energyStorageLazyOptional.isPresent() || (extracted = (energyStorage = (IEnergyStorage)energyStorageLazyOptional.orElse(null)).extractEnergy(energyStorage.getMaxEnergyStored(), true)) <= 0) continue;
            energyProduction.add(energyStorage);
            energyProductionValues.add(extracted);
        }
        LinkedList<Integer> energyProductionDistributed = new LinkedList<Integer>();
        for (int i = 0; i < energyProduction.size(); ++i) {
            energyProductionDistributed.add(0);
        }
        int productionLeft = energyProductionLeft;
        int divisor = energyProduction.size();
        block2: while (productionLeft > 0) {
            int productionPerProducer = productionLeft / divisor;
            if (productionPerProducer == 0) {
                divisor = Math.max(1, divisor - 1);
                productionPerProducer = productionLeft / divisor;
            }
            for (int i = 0; i < energyProductionValues.size(); ++i) {
                int productionDistributed = (Integer)energyProductionDistributed.get(i);
                int productionOfProducerLeft = (Integer)energyProductionValues.get(i) - productionDistributed;
                int productionDistributedNew = Math.min(productionPerProducer, Math.min(productionOfProducerLeft, productionLeft));
                energyProductionDistributed.set(i, productionDistributed + productionDistributedNew);
                if ((productionLeft -= productionDistributedNew) == 0) break block2;
            }
        }
        for (int i = 0; i < energyProduction.size(); ++i) {
            int energy = (Integer)energyProductionDistributed.get(i);
            if (energy <= 0) continue;
            ((IEnergyStorage)energyProduction.get(i)).extractEnergy(energy, false);
        }
    }

    public void m_6883_(ItemStack itemStack, Level level, Entity entity, int slot, boolean selected) {
        super.m_6883_(itemStack, level, entity, slot, selected);
        if (level.f_46443_) {
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Inventory inventory = player.m_150109_();
        if (player.f_36096_ instanceof InventoryChargerMenu) {
            return;
        }
        this.distributeEnergy(itemStack, level, inventory, slot, selected);
    }

    public static SimpleContainer getInventory(final ItemStack itemStack) {
        CompoundTag nbt = itemStack.m_41784_();
        if (nbt.m_128441_("inventory")) {
            NonNullList items = NonNullList.m_122780_((int)SLOT_COUNT, (Object)ItemStack.f_41583_);
            ContainerHelper.m_18980_((CompoundTag)nbt.m_128469_("inventory"), (NonNullList)items);
            return new SimpleContainer((ItemStack[])items.toArray((Object[])new ItemStack[0])){

                public void m_6596_() {
                    super.m_6596_();
                    NonNullList items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
                    for (int i = 0; i < this.m_6643_(); ++i) {
                        items.set(i, (Object)this.m_8020_(i));
                    }
                    itemStack.m_41784_().m_128365_("inventory", (Tag)ContainerHelper.m_18973_((CompoundTag)new CompoundTag(), (NonNullList)items));
                }

                public boolean m_7013_(int slot, @NotNull ItemStack stack) {
                    if (slot >= 0 && slot < this.m_6643_()) {
                        LazyOptional energyStorageLazyOptional = stack.getCapability(ForgeCapabilities.ENERGY);
                        if (!energyStorageLazyOptional.isPresent()) {
                            return false;
                        }
                        IEnergyStorage energyStorage = (IEnergyStorage)energyStorageLazyOptional.orElse(null);
                        return energyStorage.canExtract();
                    }
                    return super.m_7013_(slot, stack);
                }

                public boolean m_6542_(Player player) {
                    return super.m_6542_(player) && player.m_150109_().m_36056_() == itemStack;
                }

                public int m_6893_() {
                    return 1;
                }
            };
        }
        return new SimpleContainer(SLOT_COUNT){

            public void m_6596_() {
                super.m_6596_();
                NonNullList items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
                for (int i = 0; i < this.m_6643_(); ++i) {
                    items.set(i, (Object)this.m_8020_(i));
                }
                itemStack.m_41784_().m_128365_("inventory", (Tag)ContainerHelper.m_18973_((CompoundTag)new CompoundTag(), (NonNullList)items));
            }

            public boolean m_7013_(int slot, @NotNull ItemStack stack) {
                if (slot >= 0 && slot < this.m_6643_()) {
                    LazyOptional energyStorageLazyOptional = stack.getCapability(ForgeCapabilities.ENERGY);
                    if (!energyStorageLazyOptional.isPresent()) {
                        return false;
                    }
                    IEnergyStorage energyStorage = (IEnergyStorage)energyStorageLazyOptional.orElse(null);
                    return energyStorage.canExtract();
                }
                return super.m_7013_(slot, stack);
            }

            public boolean m_6542_(Player player) {
                return super.m_6542_(player) && player.m_150109_().m_36056_() == itemStack;
            }

            public int m_6893_() {
                return 1;
            }
        };
    }

    public static int getEnergy(Container inventory) {
        int energySum = 0;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            LazyOptional energyStorageLazyOptional = stack.getCapability(ForgeCapabilities.ENERGY);
            if (!energyStorageLazyOptional.isPresent()) continue;
            IEnergyStorage energyStorage = (IEnergyStorage)energyStorageLazyOptional.orElse(null);
            int value = energyStorage.getEnergyStored();
            if ((long)(energySum + value) != (long)energySum + (long)value) {
                return Integer.MAX_VALUE;
            }
            energySum += value;
        }
        return energySum;
    }

    public static int getCapacity(Container inventory) {
        int capacitySum = 0;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            LazyOptional energyStorageLazyOptional = stack.getCapability(ForgeCapabilities.ENERGY);
            if (!energyStorageLazyOptional.isPresent()) continue;
            IEnergyStorage energyStorage = (IEnergyStorage)energyStorageLazyOptional.orElse(null);
            int value = energyStorage.getMaxEnergyStored();
            if ((long)(capacitySum + value) != (long)capacitySum + (long)value) {
                return Integer.MAX_VALUE;
            }
            capacitySum += value;
        }
        return capacitySum;
    }

    public static int getMaxTransfer(Container inventory) {
        int maxTransferSum = 0;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            LazyOptional energyStorageLazyOptional = stack.getCapability(ForgeCapabilities.ENERGY);
            if (!energyStorageLazyOptional.isPresent()) continue;
            IEnergyStorage energyStorage = (IEnergyStorage)energyStorageLazyOptional.orElse(null);
            int value = energyStorage.extractEnergy(energyStorage.getMaxEnergyStored(), true);
            if ((long)(maxTransferSum + value) != (long)maxTransferSum + (long)value) {
                return Integer.MAX_VALUE;
            }
            maxTransferSum += value;
        }
        if (TRANSFER_RATE_LIMIT_ENABLED) {
            return Math.min(maxTransferSum, TRANSFER_RATE_LIMIT);
        }
        return maxTransferSum;
    }
}

