/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.item;

import java.util.Locale;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.item.upgrade.UpgradeModuleItem;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;

public class ExtractionDepthUpgradeModuleItem
extends UpgradeModuleItem {
    private static final UpgradeModuleModifier[] UPGRADE_MODULE_MODIFIERS = new UpgradeModuleModifier[]{UpgradeModuleModifier.EXTRACTION_DEPTH};
    private static final double EXTRACTION_DEPTH_1_EFFECT = ModConfigs.COMMON_UPGRADE_MODULE_EXTRACTION_DEPTH_1_EFFECT.getValue().intValue();
    private static final double EXTRACTION_DEPTH_2_EFFECT = ModConfigs.COMMON_UPGRADE_MODULE_EXTRACTION_DEPTH_2_EFFECT.getValue().intValue();
    private static final double EXTRACTION_DEPTH_3_EFFECT = ModConfigs.COMMON_UPGRADE_MODULE_EXTRACTION_DEPTH_3_EFFECT.getValue().intValue();
    private static final double EXTRACTION_DEPTH_4_EFFECT = ModConfigs.COMMON_UPGRADE_MODULE_EXTRACTION_DEPTH_4_EFFECT.getValue().intValue();
    private static final double EXTRACTION_DEPTH_5_EFFECT = ModConfigs.COMMON_UPGRADE_MODULE_EXTRACTION_DEPTH_5_EFFECT.getValue().intValue();

    public ExtractionDepthUpgradeModuleItem(Item.Properties props, int tier) {
        super(props, UpgradeModuleModifier.EXTRACTION_DEPTH, tier);
    }

    @Override
    @NotNull
    public @NotNull UpgradeModuleModifier @NotNull [] getUpgradeModuleModifiers() {
        return UPGRADE_MODULE_MODIFIERS;
    }

    @Override
    public double getUpgradeModuleModifierValue(UpgradeModuleModifier modifier) {
        return switch (modifier) {
            case UpgradeModuleModifier.EXTRACTION_DEPTH -> {
                switch (this.tier) {
                    case 1: {
                        yield EXTRACTION_DEPTH_1_EFFECT;
                    }
                    case 2: {
                        yield EXTRACTION_DEPTH_2_EFFECT;
                    }
                    case 3: {
                        yield EXTRACTION_DEPTH_3_EFFECT;
                    }
                    case 4: {
                        yield EXTRACTION_DEPTH_4_EFFECT;
                    }
                    case 5: {
                        yield EXTRACTION_DEPTH_5_EFFECT;
                    }
                }
                yield -1.0;
            }
            default -> -1.0;
        };
    }

    @Override
    public Component getUpgradeModuleModifierText(UpgradeModuleModifier modifier, double value) {
        return switch (modifier) {
            case UpgradeModuleModifier.EXTRACTION_DEPTH -> Component.m_237113_((String)String.format(Locale.ENGLISH, "+%d ", (int)value)).m_7220_((Component)Component.m_237115_((String)"tooltip.energizedpower.upgrade_module_modifier.extraction_depth.unit")).m_130940_(ChatFormatting.GREEN);
            default -> Component.m_237119_();
        };
    }
}

