/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.item;

import java.util.LinkedList;
import java.util.List;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.ReceiveOnlyEnergyStorage;
import me.jddev0.ep.item.energy.EnergizedPowerEnergyItem;
import me.jddev0.ep.util.EnergyUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class EnergyAnalyzerItem
extends EnergizedPowerEnergyItem {
    public static final int ENERGY_CONSUMPTION_PER_USE = ModConfigs.COMMON_ENERGY_ANALYZER_ENERGY_CONSUMPTION_PER_USE.getValue();
    public static final int ENERGY_CAPACITY = ModConfigs.COMMON_ENERGY_ANALYZER_CAPACITY.getValue();

    public EnergyAnalyzerItem(Item.Properties props) {
        super(props, () -> new ReceiveOnlyEnergyStorage(0, ENERGY_CAPACITY, ModConfigs.COMMON_ENERGY_ANALYZER_TRANSFER_RATE.getValue()));
    }

    @Override
    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> components, TooltipFlag tooltipFlag) {
        super.m_7373_(itemStack, level, components, tooltipFlag);
        if (Screen.m_96638_()) {
            components.add((Component)Component.m_237115_((String)"tooltip.energizedpower.energy_analyzer.txt.shift.1").m_130940_(ChatFormatting.GRAY));
            components.add((Component)Component.m_237110_((String)"tooltip.energizedpower.energy_analyzer.txt.shift.2", (Object[])new Object[]{EnergyUtils.getEnergyWithPrefix(ENERGY_CONSUMPTION_PER_USE)}).m_130940_(ChatFormatting.GRAY));
        } else {
            components.add((Component)Component.m_237115_((String)"tooltip.energizedpower.shift_details.txt").m_130940_(ChatFormatting.YELLOW));
        }
    }

    private void useItem(ItemStack itemStack, Player player, List<Component> lines) {
        if (EnergyAnalyzerItem.getEnergy(itemStack) >= ENERGY_CONSUMPTION_PER_USE) {
            EnergyAnalyzerItem.setEnergy(itemStack, EnergyAnalyzerItem.getEnergy(itemStack) - ENERGY_CONSUMPTION_PER_USE);
        }
        for (Component component : lines) {
            player.m_213846_(component);
        }
        player.m_213846_((Component)Component.m_237119_());
    }

    private void addOutputTextForEnergyStorage(List<Component> components, @Nullable IEnergyStorage energyStorage, boolean blockFaceSpecificInformation) {
        if (energyStorage == null) {
            components.add((Component)Component.m_237115_((String)("txt.energizedpower.energy_analyzer.no_energy_block" + (blockFaceSpecificInformation ? "_side" : ""))).m_130940_(ChatFormatting.RED));
            return;
        }
        components.add((Component)Component.m_237110_((String)"txt.energizedpower.energy_analyzer.energy_output", (Object[])new Object[]{EnergyUtils.getEnergyWithPrefix(energyStorage.getEnergyStored()), EnergyUtils.getEnergyWithPrefix(energyStorage.getMaxEnergyStored())}).m_130940_(ChatFormatting.GOLD));
        if (energyStorage.canReceive()) {
            components.add((Component)Component.m_237115_((String)("txt.energizedpower.energy_analyzer.energy_can_receive" + (blockFaceSpecificInformation ? "_side" : ""))).m_130940_(ChatFormatting.GOLD));
        }
        if (energyStorage.canExtract()) {
            components.add((Component)Component.m_237115_((String)("txt.energizedpower.energy_analyzer.energy_can_extract" + (blockFaceSpecificInformation ? "_side" : ""))).m_130940_(ChatFormatting.GOLD));
        }
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext useOnContext) {
        Level level = useOnContext.m_43725_();
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (EnergyAnalyzerItem.getEnergy(stack) < ENERGY_CONSUMPTION_PER_USE) {
            this.useItem(stack, useOnContext.m_43723_(), List.of(Component.m_237110_((String)"txt.energizedpower.energy_analyzer.no_energy_left", (Object[])new Object[]{EnergyUtils.getEnergyWithPrefix(ENERGY_CONSUMPTION_PER_USE)}).m_130940_(ChatFormatting.RED)));
            return InteractionResult.SUCCESS;
        }
        BlockPos blockPos = useOnContext.m_8083_();
        LinkedList<Component> components = new LinkedList<Component>();
        components.add((Component)level.m_8055_(blockPos).m_60734_().m_49954_().m_130944_(new ChatFormatting[]{ChatFormatting.UNDERLINE, ChatFormatting.AQUA}));
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity == null) {
            components.add((Component)Component.m_237115_((String)"txt.energizedpower.energy_analyzer.no_block_entity").m_130940_(ChatFormatting.RED));
            this.useItem(stack, useOnContext.m_43723_(), components);
            return InteractionResult.SUCCESS;
        }
        LazyOptional energyStorageLazyOptional = blockEntity.getCapability(ForgeCapabilities.ENERGY);
        this.addOutputTextForEnergyStorage(components, energyStorageLazyOptional.isPresent() ? (IEnergyStorage)energyStorageLazyOptional.orElse(null) : null, false);
        components.add((Component)Component.m_237115_((String)"txt.energizedpower.energy_analyzer.output_side_information").m_130940_(ChatFormatting.BLUE));
        LazyOptional energyStorageLazyOptionalSided = blockEntity.getCapability(ForgeCapabilities.ENERGY, useOnContext.m_43719_());
        this.addOutputTextForEnergyStorage(components, energyStorageLazyOptionalSided.isPresent() ? (IEnergyStorage)energyStorageLazyOptionalSided.orElse(null) : null, true);
        this.useItem(stack, useOnContext.m_43723_(), components);
        return InteractionResult.SUCCESS;
    }
}

