/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.integration.jei;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import me.jddev0.ep.block.ModBlocks;
import me.jddev0.ep.block.entity.PlantGrowthChamberBlockEntity;
import me.jddev0.ep.recipe.PlantGrowthChamberRecipe;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class PlantGrowthChamberCategory
implements IRecipeCategory<PlantGrowthChamberRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("energizedpower", "plant_growth_chamber");
    public static final RecipeType<PlantGrowthChamberRecipe> TYPE = new RecipeType(UID, PlantGrowthChamberRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public PlantGrowthChamberCategory(IGuiHelper helper) {
        ResourceLocation texture = new ResourceLocation("energizedpower", "textures/gui/container/plant_growth_chamber.png");
        this.background = helper.createDrawable(texture, 61, 25, 108, 48);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.PLANT_GROWTH_CHAMBER_ITEM.get()));
    }

    public RecipeType<PlantGrowthChamberRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"container.energizedpower.plant_growth_chamber");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder iRecipeLayout, PlantGrowthChamberRecipe recipe, IFocusGroup iFocusGroup) {
        iRecipeLayout.addSlot(RecipeIngredientRole.INPUT, 1, 10).addIngredients(recipe.getInput());
        ArrayList outputSlotEntries = new ArrayList(4);
        for (int i = 0; i < 4; ++i) {
            outputSlotEntries.add(new LinkedList());
        }
        ItemStack[] outputEntries = recipe.getMaxOutputCounts();
        for (int i = 0; i < outputEntries.length; ++i) {
            ((List)outputSlotEntries.get(i % 4)).add(outputEntries[i]);
        }
        IRecipeSlotTooltipCallback callback = (view, tooltip) -> {
            if (view.isEmpty()) {
                return;
            }
            Optional optionalItemStack = view.getDisplayedItemStack();
            if (optionalItemStack.isEmpty()) {
                return;
            }
            tooltip.add(Component.m_237115_((String)"recipes.energizedpower.transfer.output_percentages"));
            PlantGrowthChamberRecipe.OutputItemStackWithPercentages[] outputs = recipe.getOutputs();
            for (int i = 0; i < outputs.length; ++i) {
                if (!ItemStack.m_150942_((ItemStack)((ItemStack)optionalItemStack.get()), (ItemStack)outputs[i].output())) continue;
                double[] percentages = outputs[i].percentages();
                for (int j = 0; j < percentages.length; ++j) {
                    tooltip.add(Component.m_237113_((String)String.format(Locale.ENGLISH, "%2d \u2022 %.2f %%", j + 1, 100.0 * percentages[j])));
                }
                return;
            }
        };
        ((IRecipeSlotBuilder)iRecipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 73, 1).addItemStacks((List)outputSlotEntries.get(0))).addTooltipCallback(callback);
        ((IRecipeSlotBuilder)iRecipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 91, 1).addItemStacks((List)outputSlotEntries.get(1))).addTooltipCallback(callback);
        ((IRecipeSlotBuilder)iRecipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 73, 19).addItemStacks((List)outputSlotEntries.get(2))).addTooltipCallback(callback);
        ((IRecipeSlotBuilder)iRecipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 91, 19).addItemStacks((List)outputSlotEntries.get(3))).addTooltipCallback(callback);
    }

    public void draw(PlantGrowthChamberRecipe recipe, IRecipeSlotsView iRecipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Font font = Minecraft.m_91087_().f_91062_;
        int ticks = (int)((float)recipe.getTicks() * PlantGrowthChamberBlockEntity.RECIPE_DURATION_MULTIPLIER);
        MutableComponent component = Component.m_237110_((String)"recipes.energizedpower.info.ticks", (Object[])new Object[]{ticks});
        int textWidth = font.m_92852_((FormattedText)component);
        guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)component, 108 - textWidth, 40, -1, false);
    }
}

