/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.integration.jei;

import java.util.ArrayList;
import java.util.List;
import me.jddev0.ep.block.ModBlocks;
import me.jddev0.ep.block.entity.FluidTransposerBlockEntity;
import me.jddev0.ep.recipe.FluidTransposerRecipe;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;

public class FluidTransposerCategory
implements IRecipeCategory<FluidTransposerRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("energizedpower", "fluid_transposer");
    public static final RecipeType<FluidTransposerRecipe> TYPE = new RecipeType(UID, FluidTransposerRecipe.class);
    private final IDrawable backgroundEmptying;
    private final IDrawable backgroundFilling;
    private final IDrawable icon;

    public FluidTransposerCategory(IGuiHelper helper) {
        ResourceLocation texture = new ResourceLocation("energizedpower", "textures/gui/recipe/misc_gui.png");
        this.backgroundEmptying = helper.createDrawable(texture, 1, 133, 143, 26);
        this.backgroundFilling = helper.createDrawable(texture, 1, 161, 143, 26);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.FLUID_TRANSPOSER_ITEM.get()));
    }

    public RecipeType<FluidTransposerRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"container.energizedpower.fluid_transposer");
    }

    public IDrawable getBackground() {
        return this.backgroundEmptying;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder iRecipeLayout, FluidTransposerRecipe recipe, IFocusGroup iFocusGroup) {
        FluidStack fluid = recipe.getFluid();
        if (recipe.getMode() == FluidTransposerBlockEntity.Mode.EMPTYING) {
            iRecipeLayout.addSlot(RecipeIngredientRole.INPUT, 1, 5).addIngredients(recipe.getInput());
            iRecipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 64, 5).addItemStack(recipe.getOutput());
            iRecipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 90, 5).addFluidStack(fluid.getFluid(), (long)fluid.getAmount(), fluid.getTag());
        } else {
            iRecipeLayout.addSlot(RecipeIngredientRole.INPUT, 1, 5).addIngredients(recipe.getInput());
            iRecipeLayout.addSlot(RecipeIngredientRole.INPUT, 19, 5).addFluidStack(fluid.getFluid(), (long)fluid.getAmount(), fluid.getTag());
            iRecipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 90, 5).addItemStack(recipe.getOutput());
        }
    }

    public void draw(FluidTransposerRecipe recipe, IRecipeSlotsView iRecipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        if (recipe.getMode() == FluidTransposerBlockEntity.Mode.FILLING) {
            this.backgroundFilling.draw(guiGraphics, 0, 0);
        }
        ItemStack output = new ItemStack((ItemLike)(recipe.getMode() == FluidTransposerBlockEntity.Mode.EMPTYING ? Items.f_42446_ : Items.f_42447_));
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
        guiGraphics.m_280256_(output, 120, 5, 835);
        guiGraphics.m_280168_().m_85849_();
    }

    public List<Component> getTooltipStrings(FluidTransposerRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ArrayList<Component> components = new ArrayList<Component>();
        int tooltipX = 119;
        int tooltipY = 4;
        if (mouseX >= (double)(tooltipX - 1) && mouseX < (double)(tooltipX + 20 + 1) && mouseY >= (double)(tooltipY - 1) && mouseY < (double)(tooltipY + 20 + 1)) {
            components.add((Component)Component.m_237115_((String)("tooltip.energizedpower.fluid_transposer.mode." + recipe.getMode().m_7912_())));
        }
        return components;
    }
}

