/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.integration.jei;

import java.util.List;
import java.util.Locale;
import me.jddev0.ep.block.ModBlocks;
import me.jddev0.ep.block.entity.FiltrationPlantBlockEntity;
import me.jddev0.ep.fluid.ModFluids;
import me.jddev0.ep.recipe.FiltrationPlantRecipe;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;

public class FiltrationPlantCategory
implements IRecipeCategory<FiltrationPlantRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("energizedpower", "filtration_plant");
    public static final RecipeType<FiltrationPlantRecipe> TYPE = new RecipeType(UID, FiltrationPlantRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public FiltrationPlantCategory(IGuiHelper helper) {
        ResourceLocation texture = new ResourceLocation("energizedpower", "textures/gui/recipe/misc_gui.png");
        this.background = helper.createDrawable(texture, 1, 105, 112, 26);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.FILTRATION_PLANT_ITEM.get()));
    }

    public RecipeType<FiltrationPlantRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"container.energizedpower.filtration_plant");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder iRecipeLayout, FiltrationPlantRecipe recipe, IFocusGroup iFocusGroup) {
        iRecipeLayout.addSlot(RecipeIngredientRole.INPUT, 1, 5).addFluidStack((Fluid)ModFluids.DIRTY_WATER.get(), (long)FiltrationPlantBlockEntity.DIRTY_WATER_CONSUMPTION_PER_RECIPE);
        ItemStack[] outputEntries = recipe.getMaxOutputCounts();
        ((IRecipeSlotBuilder)iRecipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 64, 5).addItemStack(outputEntries[0])).addTooltipCallback((view, tooltip) -> {
            tooltip.add(Component.m_237115_((String)"recipes.energizedpower.transfer.output_percentages"));
            double[] percentages = recipe.getOutput().percentages();
            for (int i = 0; i < percentages.length; ++i) {
                tooltip.add(Component.m_237113_((String)String.format(Locale.ENGLISH, "%2d \u2022 %.2f %%", i + 1, 100.0 * percentages[i])));
            }
        });
        ((IRecipeSlotBuilder)iRecipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 92, 5).addItemStacks(outputEntries[1].m_41619_() ? List.of() : List.of(outputEntries[1]))).addTooltipCallback((view, tooltip) -> {
            if (view.isEmpty()) {
                return;
            }
            tooltip.add(Component.m_237115_((String)"recipes.energizedpower.transfer.output_percentages"));
            double[] percentages = recipe.getSecondaryOutput().percentages();
            for (int i = 0; i < percentages.length; ++i) {
                tooltip.add(Component.m_237113_((String)String.format(Locale.ENGLISH, "%2d \u2022 %.2f %%", i + 1, 100.0 * percentages[i])));
            }
        });
    }
}

