/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.integration.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import java.util.Objects;
import me.jddev0.ep.block.ModBlocks;
import me.jddev0.ep.recipe.PlantGrowthChamberFertilizerRecipe;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class PlantGrowthChamberFertilizerEMIRecipe
implements EmiRecipe {
    public static final ResourceLocation SIMPLIFIED_TEXTURE = new ResourceLocation("energizedpower", "textures/block/plant_growth_chamber_side.png");
    public static final EmiStack ITEM = EmiStack.of((ItemLike)((ItemLike)ModBlocks.PLANT_GROWTH_CHAMBER_ITEM.get()));
    public static final EmiRecipeCategory CATEGORY = new EmiRecipeCategory(new ResourceLocation("energizedpower", "plant_growth_chamber_fertilizer"), (EmiRenderable)ITEM, (EmiRenderable)new EmiTexture(SIMPLIFIED_TEXTURE, 0, 0, 16, 16, 16, 16, 16, 16));
    private final ResourceLocation id;
    private final List<EmiIngredient> input;
    private final double speedMultiplier;
    private final double energyConsumptionMultiplier;

    public PlantGrowthChamberFertilizerEMIRecipe(PlantGrowthChamberFertilizerRecipe recipe) {
        this.id = recipe.m_6423_();
        this.input = List.of(EmiIngredient.of((Ingredient)recipe.getInput()));
        this.speedMultiplier = recipe.getSpeedMultiplier();
        this.energyConsumptionMultiplier = recipe.getEnergyConsumptionMultiplier();
    }

    public EmiRecipeCategory getCategory() {
        return CATEGORY;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.input;
    }

    public List<EmiStack> getOutputs() {
        return List.of();
    }

    public int getDisplayWidth() {
        return 144;
    }

    public int getDisplayHeight() {
        return 30;
    }

    public void addWidgets(WidgetHolder widgets) {
        ResourceLocation texture = new ResourceLocation("energizedpower", "textures/gui/container/plant_growth_chamber.png");
        widgets.addTexture(texture, 0, 0, 18, 18, 34, 34);
        widgets.addSlot(this.input.get(0), 0, 0).drawBack(false);
        MutableComponent speedMultiplierText = Component.m_237110_((String)"recipes.energizedpower.plant_growth_chamber_fertilizer.speed_multiplier", (Object[])new Object[]{this.speedMultiplier});
        FormattedCharSequence formattedCharSequence = speedMultiplierText.m_7532_();
        int n = widgets.getWidth() - Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)speedMultiplierText);
        int n2 = widgets.getHeight();
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        widgets.addText(formattedCharSequence, n, n2 - 9 - 17, ChatFormatting.WHITE.m_126665_().intValue(), false);
        MutableComponent energyConsumptionMultiplierText = Component.m_237110_((String)"recipes.energizedpower.plant_growth_chamber_fertilizer.energy_consumption_multiplier", (Object[])new Object[]{this.energyConsumptionMultiplier});
        FormattedCharSequence formattedCharSequence2 = energyConsumptionMultiplierText.m_7532_();
        int n3 = widgets.getWidth() - Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)energyConsumptionMultiplierText);
        int n4 = widgets.getHeight();
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        widgets.addText(formattedCharSequence2, n3, n4 - 9, ChatFormatting.WHITE.m_126665_().intValue(), false);
    }
}

