/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.integration.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import java.util.Objects;
import me.jddev0.ep.block.ModBlocks;
import me.jddev0.ep.block.entity.EnergizerBlockEntity;
import me.jddev0.ep.recipe.EnergizerRecipe;
import me.jddev0.ep.util.EnergyUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class EnergizerEMIRecipe
implements EmiRecipe {
    public static final ResourceLocation SIMPLIFIED_TEXTURE = new ResourceLocation("energizedpower", "textures/block/energizer_front.png");
    public static final EmiStack ITEM = EmiStack.of((ItemLike)((ItemLike)ModBlocks.ENERGIZER_ITEM.get()));
    public static final EmiRecipeCategory CATEGORY = new EmiRecipeCategory(new ResourceLocation("energizedpower", "energizer"), (EmiRenderable)ITEM, (EmiRenderable)new EmiTexture(SIMPLIFIED_TEXTURE, 0, 0, 16, 16, 16, 16, 16, 16));
    private final ResourceLocation id;
    private final List<EmiIngredient> input;
    private final List<EmiStack> output;
    private final int energyConsumption;

    public EnergizerEMIRecipe(EnergizerRecipe recipe) {
        this.id = recipe.m_6423_();
        this.input = List.of(EmiIngredient.of((Ingredient)recipe.getInput()));
        this.output = List.of(EmiStack.of((ItemStack)recipe.getOutput()));
        this.energyConsumption = (int)((float)recipe.getEnergyConsumption() * EnergizerBlockEntity.ENERGY_CONSUMPTION_MULTIPLIER);
    }

    public EmiRecipeCategory getCategory() {
        return CATEGORY;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.input;
    }

    public List<EmiStack> getOutputs() {
        return this.output;
    }

    public int getDisplayWidth() {
        return 114;
    }

    public int getDisplayHeight() {
        return 50;
    }

    public void addWidgets(WidgetHolder widgets) {
        ResourceLocation texture = new ResourceLocation("energizedpower", "textures/gui/container/energizer.png");
        widgets.addTexture(texture, 0, 0, 114, 50, 31, 18);
        widgets.addSlot(this.input.get(0), 16, 16).drawBack(false);
        widgets.addSlot((EmiIngredient)this.output.get(0), 92, 16).drawBack(false).recipeContext((EmiRecipe)this);
        MutableComponent energyConsumptionText = Component.m_237113_((String)EnergyUtils.getEnergyWithPrefix(this.energyConsumption));
        FormattedCharSequence formattedCharSequence = energyConsumptionText.m_7532_();
        int n = widgets.getWidth() - Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)energyConsumptionText);
        int n2 = widgets.getHeight();
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        widgets.addText(formattedCharSequence, n, n2 - 9, ChatFormatting.YELLOW.m_126665_().intValue(), false);
    }
}

