/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.integration.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import me.jddev0.ep.block.ModBlocks;
import me.jddev0.ep.recipe.AssemblingMachineRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class AssemblingMachineEMIRecipe
implements EmiRecipe {
    public static final ResourceLocation SIMPLIFIED_TEXTURE = new ResourceLocation("energizedpower", "textures/block/assembling_machine_front.png");
    public static final EmiStack ITEM = EmiStack.of((ItemLike)((ItemLike)ModBlocks.ASSEMBLING_MACHINE_ITEM.get()));
    public static final EmiRecipeCategory CATEGORY = new EmiRecipeCategory(new ResourceLocation("energizedpower", "assembling_machine"), (EmiRenderable)ITEM, (EmiRenderable)new EmiTexture(SIMPLIFIED_TEXTURE, 0, 0, 16, 16, 16, 16, 16, 16));
    private final ResourceLocation id;
    private final List<EmiIngredient> input;
    private final List<EmiStack> output;

    public AssemblingMachineEMIRecipe(AssemblingMachineRecipe recipe) {
        this.id = recipe.m_6423_();
        this.input = Arrays.stream(recipe.getInputs()).map(input -> EmiIngredient.of((Ingredient)input.input(), (long)input.count())).collect(Collectors.toList());
        this.output = List.of(EmiStack.of((ItemStack)recipe.getOutput()));
    }

    public EmiRecipeCategory getCategory() {
        return CATEGORY;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.input;
    }

    public List<EmiStack> getOutputs() {
        return this.output;
    }

    public int getDisplayWidth() {
        return 115;
    }

    public int getDisplayHeight() {
        return 54;
    }

    public void addWidgets(WidgetHolder widgets) {
        ResourceLocation texture = new ResourceLocation("energizedpower", "textures/gui/container/assembling_machine.png");
        widgets.addTexture(texture, 0, 0, 115, 54, 43, 18);
        int len = Math.min(this.input.size(), 4);
        for (int i = 0; i < len; ++i) {
            widgets.addSlot(this.input.get(i), i == 1 ? 0 : (i == 2 ? 36 : 18), i == 0 ? 0 : (i == 3 ? 36 : 18)).drawBack(false);
        }
        widgets.addSlot((EmiIngredient)this.output.get(0), 90, 18).drawBack(false).recipeContext((EmiRecipe)this);
    }
}

