/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.integration.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import me.jddev0.ep.block.ModBlocks;
import me.jddev0.ep.recipe.PulverizerRecipe;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class AdvancedPulverizerEMIRecipe
implements EmiRecipe {
    public static final ResourceLocation SIMPLIFIED_TEXTURE = new ResourceLocation("energizedpower", "textures/block/advanced_pulverizer_side.png");
    public static final EmiStack ITEM = EmiStack.of((ItemLike)((ItemLike)ModBlocks.ADVANCED_PULVERIZER_ITEM.get()));
    public static final EmiRecipeCategory CATEGORY = new EmiRecipeCategory(new ResourceLocation("energizedpower", "advanced_pulverizer"), (EmiRenderable)ITEM, (EmiRenderable)new EmiTexture(SIMPLIFIED_TEXTURE, 0, 0, 16, 16, 16, 16, 16, 16));
    private final ResourceLocation id;
    private final List<EmiIngredient> input;
    private final List<EmiStack> output;
    private final PulverizerRecipe.OutputItemStackWithPercentages outputWithPercentages;
    private final PulverizerRecipe.OutputItemStackWithPercentages secondaryOutputWithPercentages;

    public AdvancedPulverizerEMIRecipe(PulverizerRecipe recipe) {
        this.id = recipe.m_6423_();
        this.input = List.of(EmiIngredient.of((Ingredient)recipe.getInput()));
        this.output = Arrays.stream(recipe.getMaxOutputCounts(true)).filter(itemStack -> !itemStack.m_41619_()).map(EmiStack::of).toList();
        this.outputWithPercentages = recipe.getOutput();
        this.secondaryOutputWithPercentages = recipe.getSecondaryOutput();
    }

    public EmiRecipeCategory getCategory() {
        return CATEGORY;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.input;
    }

    public List<EmiStack> getOutputs() {
        return this.output;
    }

    public int getDisplayWidth() {
        return 109;
    }

    public int getDisplayHeight() {
        return 26;
    }

    public void addWidgets(WidgetHolder widgets) {
        ResourceLocation texture = new ResourceLocation("energizedpower", "textures/gui/container/pulverizer.png");
        widgets.addTexture(texture, 0, 0, 109, 26, 42, 30);
        widgets.addSlot(this.input.get(0), 0, 4).drawBack(false);
        SlotWidget outputSlot = widgets.addSlot((EmiIngredient)this.output.get(0), 64, 4).drawBack(false).recipeContext((EmiRecipe)this);
        outputSlot.appendTooltip((Component)Component.m_237115_((String)"recipes.energizedpower.transfer.output_percentages"));
        double[] percentages = this.outputWithPercentages.percentagesAdvanced();
        for (int i = 0; i < percentages.length; ++i) {
            outputSlot.appendTooltip((Component)Component.m_237113_((String)String.format(Locale.ENGLISH, "%2d \u2022 %.2f %%", i + 1, 100.0 * percentages[i])));
        }
        SlotWidget secondaryOutputSlot = widgets.addSlot((EmiIngredient)(this.output.size() == 2 ? (EmiIngredient)this.output.get(1) : EmiStack.EMPTY), 91, 4).drawBack(false).recipeContext((EmiRecipe)this);
        if (this.output.size() == 2) {
            secondaryOutputSlot.appendTooltip((Component)Component.m_237115_((String)"recipes.energizedpower.transfer.output_percentages"));
            double[] percentages2 = this.secondaryOutputWithPercentages.percentagesAdvanced();
            for (int i = 0; i < percentages2.length; ++i) {
                secondaryOutputSlot.appendTooltip((Component)Component.m_237113_((String)String.format(Locale.ENGLISH, "%2d \u2022 %.2f %%", i + 1, 100.0 * percentages2[i])));
            }
        }
    }
}

