/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.fluid;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.SoundAction;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class EnergizedPowerFluidType
extends FluidType {
    private final ResourceLocation stillTexture;
    private final ResourceLocation flowingTexture;
    private final ResourceLocation overlayTexture;
    private final int tintColor;
    private final Vector3f fogColor;

    public EnergizedPowerFluidType(FluidType.Properties props, ResourceLocation stillTexture, ResourceLocation flowingTexture, ResourceLocation overlayTexture, int tintColor, Vector3f fogColor) {
        super(props);
        this.stillTexture = stillTexture;
        this.flowingTexture = flowingTexture;
        this.overlayTexture = overlayTexture;
        this.tintColor = tintColor;
        this.fogColor = fogColor;
    }

    public ResourceLocation getStillTexture() {
        return this.stillTexture;
    }

    public ResourceLocation getFlowingTexture() {
        return this.flowingTexture;
    }

    public ResourceLocation getOverlayTexture() {
        return this.overlayTexture;
    }

    public int getTintColor() {
        return this.tintColor;
    }

    public Vector3f getFogColor() {
        return this.fogColor;
    }

    @Nullable
    public SoundEvent getSound(SoundAction action) {
        if (action == SoundActions.BUCKET_FILL) {
            return SoundEvents.f_11781_;
        }
        if (action == SoundActions.BUCKET_EMPTY) {
            return SoundEvents.f_11778_;
        }
        return null;
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(new IClientFluidTypeExtensions(){

            public int getTintColor() {
                return EnergizedPowerFluidType.this.tintColor;
            }

            public ResourceLocation getStillTexture() {
                return EnergizedPowerFluidType.this.stillTexture;
            }

            public ResourceLocation getFlowingTexture() {
                return EnergizedPowerFluidType.this.flowingTexture;
            }

            @Nullable
            public ResourceLocation getOverlayTexture() {
                return EnergizedPowerFluidType.this.overlayTexture;
            }

            @NotNull
            public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                return EnergizedPowerFluidType.this.fogColor;
            }

            public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                RenderSystem.setShaderFogStart((float)0.25f);
                RenderSystem.setShaderFogEnd((float)3.0f);
            }
        });
    }
}

