/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.energy;

import java.util.function.BiPredicate;
import net.minecraftforge.energy.IEnergyStorage;

public class ReceiveExtractEnergyHandler
implements IEnergyStorage {
    private final IEnergyStorage energyStorage;
    private final BiPredicate<Integer, Boolean> canReceive;
    private final BiPredicate<Integer, Boolean> canExtract;

    public ReceiveExtractEnergyHandler(IEnergyStorage energyStorage, BiPredicate<Integer, Boolean> canReceive, BiPredicate<Integer, Boolean> canExtract) {
        this.energyStorage = energyStorage;
        this.canReceive = canReceive;
        this.canExtract = canExtract;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (this.canReceive.test(maxReceive, simulate)) {
            return this.energyStorage.receiveEnergy(maxReceive, simulate);
        }
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (this.canExtract.test(maxExtract, simulate)) {
            return this.energyStorage.extractEnergy(maxExtract, simulate);
        }
        return 0;
    }

    public int getEnergyStored() {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public boolean canExtract() {
        return this.canExtract.test(-1, false) && this.energyStorage.canExtract();
    }

    public boolean canReceive() {
        return this.canReceive.test(-1, false) && this.energyStorage.canReceive();
    }
}

