/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.config.value;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import me.jddev0.ep.config.ConfigValidationException;
import me.jddev0.ep.config.ConfigValue;
import me.jddev0.ep.config.validation.ValueValidator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DoubleConfigValue
extends ConfigValue<Double> {
    private final double minExclusive;
    private final boolean minLenCheckEnabled;
    private final double maxExclusive;
    private final boolean maxLenCheckEnabled;

    public DoubleConfigValue(@NotNull String key, @NotNull Double defaultValue) {
        this(key, (String)null, defaultValue);
    }

    public DoubleConfigValue(@NotNull String key, @Nullable String comment, @NotNull Double defaultValue) {
        this(key, comment, defaultValue, (ValueValidator<? super Double>)null);
    }

    public DoubleConfigValue(@NotNull String key, @Nullable String comment, @NotNull Double defaultValue, @Nullable ValueValidator<? super Double> customValidator) {
        this(key, comment, defaultValue, customValidator, null, null);
    }

    public DoubleConfigValue(@NotNull String key, @Nullable String comment, @NotNull Double defaultValue, @Nullable Double minExclusive, @Nullable Double maxExclusive) {
        this(key, comment, defaultValue, null, minExclusive, maxExclusive);
    }

    public DoubleConfigValue(@NotNull String key, @Nullable String comment, @NotNull Double defaultValue, @Nullable ValueValidator<? super Double> customValidator, @Nullable Double minExclusive, @Nullable Double maxExclusive) {
        super(key, comment, defaultValue, customValidator);
        this.minLenCheckEnabled = minExclusive != null;
        this.minExclusive = this.minLenCheckEnabled ? minExclusive : 0.0;
        this.maxLenCheckEnabled = maxExclusive != null;
        this.maxExclusive = this.maxLenCheckEnabled ? maxExclusive : 0.0;
    }

    @Override
    @NotNull
    public List<String> getValidationCommentLines() {
        ArrayList<String> commentLines = new ArrayList<String>();
        if (this.minLenCheckEnabled) {
            commentLines.add("Value > " + this.minExclusive);
        }
        if (this.maxLenCheckEnabled) {
            commentLines.add("Value < " + this.maxExclusive);
        }
        commentLines.addAll(super.getValidationCommentLines());
        return commentLines;
    }

    @Override
    public void validate(@NotNull Double value) throws ConfigValidationException {
        if (this.minLenCheckEnabled && !(value > this.minExclusive)) {
            throw new ConfigValidationException("The value must be greater than " + this.minExclusive);
        }
        if (this.maxLenCheckEnabled && !(value < this.maxExclusive)) {
            throw new ConfigValidationException("The value must be less than " + this.maxExclusive);
        }
        super.validate(value);
    }

    @Override
    @NotNull
    protected Double readInternal(@NotNull String rawValue) throws ConfigValidationException {
        try {
            return Double.parseDouble(rawValue);
        }
        catch (NumberFormatException e) {
            throw new ConfigValidationException("Invalid double value: " + e.getMessage());
        }
    }

    @Override
    @NotNull
    protected String writeInternal(@NotNull Double value) {
        return String.format(Locale.ENGLISH, "%f", value);
    }
}

