/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.config;

import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import me.jddev0.ep.block.CableBlock;
import me.jddev0.ep.config.Config;
import me.jddev0.ep.config.ConfigValidationException;
import me.jddev0.ep.config.ConfigValue;
import me.jddev0.ep.config.validation.ValueValidator;
import me.jddev0.ep.config.validation.ValueValidators;
import me.jddev0.ep.config.value.BooleanConfigValue;
import me.jddev0.ep.config.value.DoubleConfigValue;
import me.jddev0.ep.config.value.EnumConfigValue;
import me.jddev0.ep.config.value.FloatConfigValue;
import me.jddev0.ep.config.value.IntegerConfigValue;
import me.jddev0.ep.config.value.ResourceLocationListConfigValue;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.loading.FMLPaths;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public final class ModConfigs {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Config COMMON_CONFIG = new Config(ModConfigs.getRelativeConfigFile("common.conf"), "Energized Power Common Config (IMPORTANT: Not all values are synced from the server to the client.)");
    public static final ConfigValue<Integer> COMMON_BATTERY_1_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("item.battery_1", "Battery (Tier I)", 256);
    public static final ConfigValue<Integer> COMMON_BATTERY_1_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("item.battery_1", "Battery (Tier I)", 2);
    public static final ConfigValue<Integer> COMMON_BATTERY_2_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("item.battery_2", "Battery (Tier II)", 1024);
    public static final ConfigValue<Integer> COMMON_BATTERY_2_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("item.battery_2", "Battery (Tier II)", 8);
    public static final ConfigValue<Integer> COMMON_BATTERY_3_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("item.battery_3", "Battery (Tier III)", 2048);
    public static final ConfigValue<Integer> COMMON_BATTERY_3_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("item.battery_3", "Battery (Tier III)", 32);
    public static final ConfigValue<Integer> COMMON_BATTERY_4_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("item.battery_4", "Battery (Tier IV)", 8192);
    public static final ConfigValue<Integer> COMMON_BATTERY_4_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("item.battery_4", "Battery (Tier IV)", 128);
    public static final ConfigValue<Integer> COMMON_BATTERY_5_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("item.battery_5", "Battery (Tier V)", 16384);
    public static final ConfigValue<Integer> COMMON_BATTERY_5_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("item.battery_5", "Battery (Tier V)", 512);
    public static final ConfigValue<Integer> COMMON_BATTERY_6_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("item.battery_6", "Battery (Tier VI)", 65536);
    public static final ConfigValue<Integer> COMMON_BATTERY_6_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("item.battery_6", "Battery (Tier VI)", 2048);
    public static final ConfigValue<Integer> COMMON_BATTERY_7_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("item.battery_7", "Battery (Tier VII)", 262144);
    public static final ConfigValue<Integer> COMMON_BATTERY_7_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("item.battery_7", "Battery (Tier VII)", 8192);
    public static final ConfigValue<Integer> COMMON_BATTERY_8_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("item.battery_8", "Battery (Tier VIII)", 0x100000);
    public static final ConfigValue<Integer> COMMON_BATTERY_8_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("item.battery_8", "Battery (Tier VIII)", 32768);
    public static final ConfigValue<Integer> COMMON_ENERGY_ANALYZER_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("item.energy_analyzer", "Energy Analyzer", 2048);
    public static final ConfigValue<Integer> COMMON_ENERGY_ANALYZER_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("item.energy_analyzer", "Energy Analyzer", 32);
    public static final ConfigValue<Integer> COMMON_ENERGY_ANALYZER_ENERGY_CONSUMPTION_PER_USE = ModConfigs.registerEnergyConsumptionPerUseConfigValue("item.energy_analyzer", "Energy Analyzer", 8);
    public static final ConfigValue<Integer> COMMON_FLUID_ANALYZER_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("item.fluid_analyzer", "Fluid Analyzer", 2048);
    public static final ConfigValue<Integer> COMMON_FLUID_ANALYZER_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("item.fluid_analyzer", "Fluid Analyzer", 32);
    public static final ConfigValue<Integer> COMMON_FLUID_ANALYZER_ENERGY_CONSUMPTION_PER_USE = ModConfigs.registerEnergyConsumptionPerUseConfigValue("item.fluid_analyzer", "Fluid Analyzer", 8);
    public static final ConfigValue<Integer> COMMON_INVENTORY_COAL_ENGINE_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("item.inventory_coal_engine", "Inventory Coal Engine", 2048);
    public static final ConfigValue<Integer> COMMON_INVENTORY_COAL_ENGINE_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("item.inventory_coal_engine", "Inventory Coal Engine", 256);
    public static final ConfigValue<Float> COMMON_INVENTORY_COAL_ENGINE_ENERGY_PRODUCTION_MULTIPLIER = ModConfigs.registerEnergyProductionMultiplierConfigValue("item.inventory_coal_engine", "Inventory Coal Engine");
    public static final ConfigValue<Integer> COMMON_INVENTORY_CHARGER_SLOT_COUNT = COMMON_CONFIG.register(new IntegerConfigValue("item.inventory_charger.slot_count", "The slot count of the Inventory Charger.\nWARNING: If set to a lower value than previously, items which are stored in an Inventory Charger could vanish!", 3, (ValueValidator<? super Integer>)ValueValidators.elementOfCollection(List.of(Integer.valueOf(1), Integer.valueOf(3), Integer.valueOf(5)))));
    public static final ConfigValue<Boolean> COMMON_INVENTORY_CHARGER_TRANSFER_RATE_LIMIT_ENABLED = COMMON_CONFIG.register(new BooleanConfigValue("item.inventory_charger.transfer_rate_limit_enabled", "If set to true the transfer rate limit of the Inventory Charger will be enabled", false));
    public static final ConfigValue<Integer> COMMON_INVENTORY_CHARGER_TRANSFER_RATE_LIMIT = COMMON_CONFIG.register(new IntegerConfigValue("item.inventory_charger.transfer_rate_limit", "The maximal transfer rate of the Inventory Charger in FE per tick if the transfer rate limit is enabled", 16384, 1, null));
    public static final ConfigValue<Integer> COMMON_INVENTORY_TELEPORTER_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("item.inventory_teleporter", "Inventory Teleporter", 0x800000);
    public static final ConfigValue<Integer> COMMON_INVENTORY_TELEPORTER_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("item.inventory_teleporter", "Inventory Teleporter", 65536);
    public static final ConfigValue<Double> COMMON_UPGRADE_MODULE_SPEED_1_EFFECT = ModConfigs.registerSpeedModuleEffectValue(1, "I", 1.2);
    public static final ConfigValue<Double> COMMON_UPGRADE_MODULE_SPEED_1_ENERGY_CONSUMPTION_EFFECT = ModConfigs.registerSpeedModuleEnergyConsumptionEffectValue(1, "I", 1.4);
    public static final ConfigValue<Double> COMMON_UPGRADE_MODULE_SPEED_2_EFFECT = ModConfigs.registerSpeedModuleEffectValue(2, "II", 1.5);
    public static final ConfigValue<Double> COMMON_UPGRADE_MODULE_SPEED_2_ENERGY_CONSUMPTION_EFFECT = ModConfigs.registerSpeedModuleEnergyConsumptionEffectValue(2, "II", 2.0);
    public static final ConfigValue<Double> COMMON_UPGRADE_MODULE_SPEED_3_EFFECT = ModConfigs.registerSpeedModuleEffectValue(3, "III", 2.0);
    public static final ConfigValue<Double> COMMON_UPGRADE_MODULE_SPEED_3_ENERGY_CONSUMPTION_EFFECT = ModConfigs.registerSpeedModuleEnergyConsumptionEffectValue(3, "III", 2.5);
    public static final ConfigValue<Double> COMMON_UPGRADE_MODULE_SPEED_4_EFFECT = ModConfigs.registerSpeedModuleEffectValue(4, "IV", 3.5);
    public static final ConfigValue<Double> COMMON_UPGRADE_MODULE_SPEED_4_ENERGY_CONSUMPTION_EFFECT = ModConfigs.registerSpeedModuleEnergyConsumptionEffectValue(4, "IV", 5.0);
    public static final ConfigValue<Double> COMMON_UPGRADE_MODULE_SPEED_5_EFFECT = ModConfigs.registerSpeedModuleEffectValue(5, "V", 6.0);
    public static final ConfigValue<Double> COMMON_UPGRADE_MODULE_SPEED_5_ENERGY_CONSUMPTION_EFFECT = ModConfigs.registerSpeedModuleEnergyConsumptionEffectValue(5, "V", 10.0);
    public static final ConfigValue<Double> COMMON_UPGRADE_MODULE_ENERGY_EFFICIENCY_1_EFFECT = ModConfigs.registerEnergyEfficiencyModuleEffectValue(1, "I", 0.9);
    public static final ConfigValue<Double> COMMON_UPGRADE_MODULE_ENERGY_EFFICIENCY_2_EFFECT = ModConfigs.registerEnergyEfficiencyModuleEffectValue(2, "II", 0.75);
    public static final ConfigValue<Double> COMMON_UPGRADE_MODULE_ENERGY_EFFICIENCY_3_EFFECT = ModConfigs.registerEnergyEfficiencyModuleEffectValue(3, "III", 0.6);
    public static final ConfigValue<Double> COMMON_UPGRADE_MODULE_ENERGY_EFFICIENCY_4_EFFECT = ModConfigs.registerEnergyEfficiencyModuleEffectValue(4, "IV", 0.4);
    public static final ConfigValue<Double> COMMON_UPGRADE_MODULE_ENERGY_EFFICIENCY_5_EFFECT = ModConfigs.registerEnergyEfficiencyModuleEffectValue(8, "V", 0.2);
    public static final ConfigValue<Double> COMMON_UPGRADE_MODULE_ENERGY_CAPACITY_1_EFFECT = ModConfigs.registerEnergyCapacityModuleEffectValue(1, "I", 1.5);
    public static final ConfigValue<Double> COMMON_UPGRADE_MODULE_ENERGY_CAPACITY_1_ENERGY_TRANSFER_RATE_EFFECT = ModConfigs.registerEnergyCapacityModuleEnergyTransferRateEffectValue(1, "I", 1.5);
    public static final ConfigValue<Double> COMMON_UPGRADE_MODULE_ENERGY_CAPACITY_2_EFFECT = ModConfigs.registerEnergyCapacityModuleEffectValue(2, "II", 2.5);
    public static final ConfigValue<Double> COMMON_UPGRADE_MODULE_ENERGY_CAPACITY_2_ENERGY_TRANSFER_RATE_EFFECT = ModConfigs.registerEnergyCapacityModuleEnergyTransferRateEffectValue(2, "II", 2.5);
    public static final ConfigValue<Double> COMMON_UPGRADE_MODULE_ENERGY_CAPACITY_3_EFFECT = ModConfigs.registerEnergyCapacityModuleEffectValue(3, "III", 4.0);
    public static final ConfigValue<Double> COMMON_UPGRADE_MODULE_ENERGY_CAPACITY_3_ENERGY_TRANSFER_RATE_EFFECT = ModConfigs.registerEnergyCapacityModuleEnergyTransferRateEffectValue(3, "III", 4.0);
    public static final ConfigValue<Double> COMMON_UPGRADE_MODULE_ENERGY_CAPACITY_4_EFFECT = ModConfigs.registerEnergyCapacityModuleEffectValue(4, "IV", 7.5);
    public static final ConfigValue<Double> COMMON_UPGRADE_MODULE_ENERGY_CAPACITY_4_ENERGY_TRANSFER_RATE_EFFECT = ModConfigs.registerEnergyCapacityModuleEnergyTransferRateEffectValue(4, "IV", 7.5);
    public static final ConfigValue<Double> COMMON_UPGRADE_MODULE_ENERGY_CAPACITY_5_EFFECT = ModConfigs.registerEnergyCapacityModuleEffectValue(5, "V", 10.0);
    public static final ConfigValue<Double> COMMON_UPGRADE_MODULE_ENERGY_CAPACITY_5_ENERGY_TRANSFER_RATE_EFFECT = ModConfigs.registerEnergyCapacityModuleEnergyTransferRateEffectValue(5, "V", 10.0);
    public static final ConfigValue<Double> COMMON_UPGRADE_MODULE_DURATION_1_EFFECT = ModConfigs.registerDurationUpgradeModuleEffectValue(1, "I", 4.0);
    public static final ConfigValue<Double> COMMON_UPGRADE_MODULE_DURATION_2_EFFECT = ModConfigs.registerDurationUpgradeModuleEffectValue(2, "II", 10.0);
    public static final ConfigValue<Double> COMMON_UPGRADE_MODULE_DURATION_3_EFFECT = ModConfigs.registerDurationUpgradeModuleEffectValue(3, "III", 20.0);
    public static final ConfigValue<Double> COMMON_UPGRADE_MODULE_DURATION_4_EFFECT = ModConfigs.registerDurationUpgradeModuleEffectValue(4, "VI", 50.0);
    public static final ConfigValue<Double> COMMON_UPGRADE_MODULE_DURATION_5_EFFECT = ModConfigs.registerDurationUpgradeModuleEffectValue(5, "V", 100.0);
    public static final ConfigValue<Integer> COMMON_UPGRADE_MODULE_DURATION_6_ENERGY_CONSUMPTION_PER_TICK = ModConfigs.registerEnergyConsumptionPerTickConfigValue("item.duration_upgrade_module_6.energy_consumption_per_tick", "Duration Upgrade Module (Tier VI)", 131072);
    public static final ConfigValue<Double> COMMON_UPGRADE_MODULE_DURATION_6_ENERGY_TRANSFER_RATE = COMMON_CONFIG.register(new DoubleConfigValue("item.duration_upgrade_module_6.energy_transfer_rate.effect_value", "The upgrade module effect (Energy transfer rate multiplier) of the Duration Upgrade Module (Tier VI)", 8.0, 1.0, null));
    public static final ConfigValue<Double> COMMON_UPGRADE_MODULE_RANGE_1_EFFECT = ModConfigs.registerRangeUpgradeModuleEffectValue(1, "I", 1.25);
    public static final ConfigValue<Double> COMMON_UPGRADE_MODULE_RANGE_2_EFFECT = ModConfigs.registerRangeUpgradeModuleEffectValue(2, "II", 1.5);
    public static final ConfigValue<Double> COMMON_UPGRADE_MODULE_RANGE_3_EFFECT = ModConfigs.registerRangeUpgradeModuleEffectValue(3, "III", 1.75);
    public static final ConfigValue<Integer> COMMON_UPGRADE_MODULE_EXTRACTION_DEPTH_1_EFFECT = ModConfigs.registerExtractionDepthUpgradeModuleEffectValue(1, "I", 16);
    public static final ConfigValue<Integer> COMMON_UPGRADE_MODULE_EXTRACTION_DEPTH_2_EFFECT = ModConfigs.registerExtractionDepthUpgradeModuleEffectValue(2, "II", 32);
    public static final ConfigValue<Integer> COMMON_UPGRADE_MODULE_EXTRACTION_DEPTH_3_EFFECT = ModConfigs.registerExtractionDepthUpgradeModuleEffectValue(3, "III", 64);
    public static final ConfigValue<Integer> COMMON_UPGRADE_MODULE_EXTRACTION_DEPTH_4_EFFECT = ModConfigs.registerExtractionDepthUpgradeModuleEffectValue(4, "IV", 128);
    public static final ConfigValue<Integer> COMMON_UPGRADE_MODULE_EXTRACTION_DEPTH_5_EFFECT = ModConfigs.registerExtractionDepthUpgradeModuleEffectValue(5, "V", 192);
    public static final ConfigValue<Double> COMMON_UPGRADE_MODULE_MOON_LIGHT_1_EFFECT = ModConfigs.registerMoonLightUpgradeModuleEffectValue(1, "I", 0.125);
    public static final ConfigValue<Double> COMMON_UPGRADE_MODULE_MOON_LIGHT_2_EFFECT = ModConfigs.registerMoonLightUpgradeModuleEffectValue(2, "II", 0.33);
    public static final ConfigValue<Double> COMMON_UPGRADE_MODULE_MOON_LIGHT_3_EFFECT = ModConfigs.registerMoonLightUpgradeModuleEffectValue(3, "III", 0.66);
    public static final ConfigValue<Integer> COMMON_BATTERY_BOX_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("block.battery_box", "Battery Box", 65536);
    public static final ConfigValue<Integer> COMMON_BATTERY_BOX_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.battery_box", "Battery Box", 2048);
    public static final ConfigValue<Integer> COMMON_ADVANCED_BATTERY_BOX_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("block.advanced_battery_box", "Advanced Battery Box", 0x800000);
    public static final ConfigValue<Integer> COMMON_ADVANCED_BATTERY_BOX_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.advanced_battery_box", "Advanced Battery Box", 262144);
    public static final ConfigValue<Integer> COMMON_LV_TRANSFORMERS_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.lv_transformers", "LV Transformers", 8192);
    public static final ConfigValue<Integer> COMMON_MV_TRANSFORMERS_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.mv_transformers", "MV Transformers", 65536);
    public static final ConfigValue<Integer> COMMON_HV_TRANSFORMERS_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.hv_transformers", "HV Transformers", 524288);
    public static final ConfigValue<Integer> COMMON_EHV_TRANSFORMERS_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.ehv_transformers", "EHV Transformers", 0x200000);
    public static final ConfigValue<CableBlock.EnergyExtractionMode> COMMON_CABLES_ENERGY_EXTRACTION_MODE = COMMON_CONFIG.register(new EnumConfigValue("block.cables.energy_extraction_mode", "The energy extraction mode defines how cables extract energy.\n- PUSH: Producers must push energy into cables.\n- PULL: Cables pull energy from producers.\n- BOTH: Both systems are used.\n=> Set to PULL for the behavior of cables before version 2.1.1.\n=> Set to BOTH for compatibility with any FE energy producers.", (Enum)CableBlock.EnergyExtractionMode.BOTH, (Enum[])CableBlock.EnergyExtractionMode.values(), CableBlock.EnergyExtractionMode::valueOf));
    public static final ConfigValue<Integer> COMMON_TIN_CABLE_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.tin_cable", "Tin Cable", 128);
    public static final ConfigValue<Integer> COMMON_COPPER_CABLE_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.copper_cable", "Copper Cable", 1024);
    public static final ConfigValue<Integer> COMMON_GOLD_CABLE_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.gold_cable", "Gold Cable", 16384);
    public static final ConfigValue<Integer> COMMON_ENERGIZED_COPPER_CABLE_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.energized_copper_cable", "Energized Copper Cable", 131072);
    public static final ConfigValue<Integer> COMMON_ENERGIZED_GOLD_CABLE_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.energized_gold_cable", "Energized Gold Cable", 524288);
    public static final ConfigValue<Integer> COMMON_ENERGIZED_CRYSTAL_MATRIX_CABLE_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.energized_crystal_matrix_cable", "Energized Crystal Matrix Cable", 0x200000);
    public static final ConfigValue<Integer> COMMON_WEATHER_CONTROLLER_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("block.weather_controller", "Weather Controller", 0x800000);
    public static final ConfigValue<Integer> COMMON_WEATHER_CONTROLLER_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.weather_controller", "Weather Controller", 32768);
    public static final ConfigValue<Integer> COMMON_WEATHER_CONTROLLER_CONTROL_DURATION = COMMON_CONFIG.register(new IntegerConfigValue("block.weather_controller.control_duration", "The amount of time in ticks the Weather Controller can maintain the desired weather state", 19200, 100, null));
    public static final ConfigValue<Integer> COMMON_LIGHTNING_GENERATOR_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("block.lightning_generator", "Lightning Generator", 1000000);
    public static final ConfigValue<Integer> COMMON_LIGHTNING_GENERATOR_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.lightning_generator", "Lightning Generator", 65536);
    public static final ConfigValue<Integer> COMMON_CHARGING_STATION_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("block.charging_station", "Charging Station", 262144);
    public static final ConfigValue<Integer> COMMON_CHARGING_STATION_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.charging_station", "Charging Station", 16384);
    public static final ConfigValue<Integer> COMMON_CHARGING_STATION_MAX_CHARGING_DISTANCE = COMMON_CONFIG.register(new IntegerConfigValue("block.charging_station.max_charging_distance", "The maximal distance the Charging Station can operate within", 7, 1, 25));
    public static final ConfigValue<Integer> COMMON_CRYSTAL_GROWTH_CHAMBER_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("block.crystal_growth_chamber", "Crystal Growth Chamber", 32768);
    public static final ConfigValue<Integer> COMMON_CRYSTAL_GROWTH_CHAMBER_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.crystal_growth_chamber", "Crystal Growth Chamber", 2048);
    public static final ConfigValue<Integer> COMMON_CRYSTAL_GROWTH_CHAMBER_ENERGY_CONSUMPTION_PER_TICK = ModConfigs.registerEnergyConsumptionPerTickConfigValue("block.crystal_growth_chamber", "Crystal Growth Chamber", 1024);
    public static final ConfigValue<Float> COMMON_CRYSTAL_GROWTH_CHAMBER_RECIPE_DURATION_MULTIPLIER = ModConfigs.registerRecipeDurationMultiplierConfigValue("block.crystal_growth_chamber", "Crystal Growth Chamber");
    public static final ConfigValue<Integer> COMMON_TIME_CONTROLLER_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("block.time_controller", "Time Controller", 0x800000);
    public static final ConfigValue<Integer> COMMON_TIME_CONTROLLER_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.time_controller", "Time Controller", 32768);
    public static final ConfigValue<Integer> COMMON_TELEPORTER_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("block.teleporter", "Teleporter", 0x800000);
    public static final ConfigValue<Integer> COMMON_TELEPORTER_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.teleporter", "Teleporter", 65536);
    public static final ConfigValue<Boolean> COMMON_TELEPORTER_INTRA_DIMENSIONAL_ENABLED = COMMON_CONFIG.register(new BooleanConfigValue("block.teleporter.intra_dimensional_enabled", "Intra dimensional teleportation (= within a dimension) is not allowed if set to false.", true));
    public static final ConfigValue<Boolean> COMMON_TELEPORTER_INTER_DIMENSIONAL_ENABLED = COMMON_CONFIG.register(new BooleanConfigValue("block.teleporter.inter_dimensional_enabled", "Inter dimensional teleportation (= across multiple dimension) is not allowed if set to false.", true));
    public static final ConfigValue<List<@NotNull ResourceLocation>> COMMON_TELEPORTER_DIMENSION_BLACKLIST = COMMON_CONFIG.register(new ResourceLocationListConfigValue("block.teleporter.dimension_blacklist", "Teleportation within, from, and to dimensions in this list are not allowed.", (List<ResourceLocation>)new ArrayList<ResourceLocation>(0)));
    public static final ConfigValue<List<@NotNull ResourceLocation>> COMMON_TELEPORTER_INTRA_DIMENSIONAL_BLACKLIST = COMMON_CONFIG.register(new ResourceLocationListConfigValue("block.teleporter.intra_dimensional_blacklist", "Teleportation within dimensions in this list are not allowed.\nTeleportation to and from dimensions in this list are still allowed.", (List<ResourceLocation>)new ArrayList<ResourceLocation>(0)));
    public static final ConfigValue<List<@NotNull ResourceLocation>> COMMON_TELEPORTER_INTER_DIMENSIONAL_FROM_BLACKLIST = COMMON_CONFIG.register(new ResourceLocationListConfigValue("block.teleporter.inter_dimension_from_blacklist", "Teleportation from dimensions in this list are not allowed.\nTeleportation within and to dimensions in this list are still allowed.", (List<ResourceLocation>)new ArrayList<ResourceLocation>(0)));
    public static final ConfigValue<List<@NotNull ResourceLocation>> COMMON_TELEPORTER_INTER_DIMENSIONAL_TO_BLACKLIST = COMMON_CONFIG.register(new ResourceLocationListConfigValue("block.teleporter.inter_dimension_to_blacklist", "Teleportation to dimensions in this list are not allowed.\nTeleportation within and from dimensions in this list are still allowed.", (List<ResourceLocation>)new ArrayList<ResourceLocation>(0)));
    public static final ConfigValue<List<@NotNull ResourceLocation>> COMMON_TELEPORTER_DIMENSION_TYPE_BLACKLIST = COMMON_CONFIG.register(new ResourceLocationListConfigValue("block.teleporter.dimension_type_blacklist", "Teleportation within, from, and to dimension types in this list are not allowed.", (List<ResourceLocation>)new ArrayList<ResourceLocation>(0)));
    public static final ConfigValue<List<@NotNull ResourceLocation>> COMMON_TELEPORTER_INTRA_DIMENSIONAL_TYPE_BLACKLIST = COMMON_CONFIG.register(new ResourceLocationListConfigValue("block.teleporter.intra_dimensional_type_blacklist", "Teleportation within dimension types in this list are not allowed.\nTeleportation to and from dimension types in this list are still allowed.", (List<ResourceLocation>)new ArrayList<ResourceLocation>(0)));
    public static final ConfigValue<List<@NotNull ResourceLocation>> COMMON_TELEPORTER_INTER_DIMENSIONAL_FROM_TYPE_BLACKLIST = COMMON_CONFIG.register(new ResourceLocationListConfigValue("block.teleporter.inter_dimension_from_type_blacklist", "Teleportation from dimension types in this list are not allowed.\nTeleportation within and to dimension types in this list are still allowed.", (List<ResourceLocation>)new ArrayList<ResourceLocation>(0)));
    public static final ConfigValue<List<@NotNull ResourceLocation>> COMMON_TELEPORTER_INTER_DIMENSIONAL_TO_TYPE_BLACKLIST = COMMON_CONFIG.register(new ResourceLocationListConfigValue("block.teleporter.inter_dimension_to_type_blacklist", "Teleportation to dimension types in this list are not allowed.\nTeleportation within and from dimension types in this list are still allowed.", (List<ResourceLocation>)new ArrayList<ResourceLocation>(0)));
    public static final ConfigValue<Integer> COMMON_COAL_ENGINE_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("block.coal_engine", "Coal Engine", 2048);
    public static final ConfigValue<Integer> COMMON_COAL_ENGINE_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.coal_engine", "Coal Engine", 256);
    public static final ConfigValue<Float> COMMON_COAL_ENGINE_ENERGY_PRODUCTION_MULTIPLIER = ModConfigs.registerEnergyProductionMultiplierConfigValue("block.coal_engine", "Coal Engine");
    public static final ConfigValue<Integer> COMMON_SOLAR_PANEL_1_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("block.solar_panel_1", "Solar Panel (Tier I)", 80);
    public static final ConfigValue<Integer> COMMON_SOLAR_PANEL_1_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.solar_panel_1", "Solar Panel (Tier I)", 8);
    public static final ConfigValue<Integer> COMMON_SOLAR_PANEL_1_ENERGY_PEAK_PRODUCTION = ModConfigs.registerEnergyPeakProductionConfigValue("block.solar_panel_1", "Solar Panel (Tier I)", 2);
    public static final ConfigValue<Integer> COMMON_SOLAR_PANEL_2_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("block.solar_panel_2", "Solar Panel (Tier II)", 640);
    public static final ConfigValue<Integer> COMMON_SOLAR_PANEL_2_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.solar_panel_2", "Solar Panel (Tier II)", 64);
    public static final ConfigValue<Integer> COMMON_SOLAR_PANEL_2_ENERGY_PEAK_PRODUCTION = ModConfigs.registerEnergyPeakProductionConfigValue("block.solar_panel_2", "Solar Panel (Tier II)", 16);
    public static final ConfigValue<Integer> COMMON_SOLAR_PANEL_3_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("block.solar_panel_3", "Solar Panel (Tier III)", 5120);
    public static final ConfigValue<Integer> COMMON_SOLAR_PANEL_3_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.solar_panel_3", "Solar Panel (Tier III)", 512);
    public static final ConfigValue<Integer> COMMON_SOLAR_PANEL_3_ENERGY_PEAK_PRODUCTION = ModConfigs.registerEnergyPeakProductionConfigValue("block.solar_panel_3", "Solar Panel (Tier III)", 128);
    public static final ConfigValue<Integer> COMMON_SOLAR_PANEL_4_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("block.solar_panel_4", "Solar Panel (Tier IV)", 81920);
    public static final ConfigValue<Integer> COMMON_SOLAR_PANEL_4_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.solar_panel_4", "Solar Panel (Tier IV)", 8192);
    public static final ConfigValue<Integer> COMMON_SOLAR_PANEL_4_ENERGY_PEAK_PRODUCTION = ModConfigs.registerEnergyPeakProductionConfigValue("block.solar_panel_4", "Solar Panel (Tier IV)", 2048);
    public static final ConfigValue<Integer> COMMON_SOLAR_PANEL_5_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("block.solar_panel_5", "Solar Panel (Tier V)", 327680);
    public static final ConfigValue<Integer> COMMON_SOLAR_PANEL_5_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.solar_panel_5", "Solar Panel (Tier V)", 131072);
    public static final ConfigValue<Integer> COMMON_SOLAR_PANEL_5_ENERGY_PEAK_PRODUCTION = ModConfigs.registerEnergyPeakProductionConfigValue("block.solar_panel_5", "Solar Panel (Tier V)", 16384);
    public static final ConfigValue<Integer> COMMON_SOLAR_PANEL_6_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("block.solar_panel_6", "Solar Panel (Tier VI)", 0x100000);
    public static final ConfigValue<Integer> COMMON_SOLAR_PANEL_6_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.solar_panel_6", "Solar Panel (Tier VI)", 524288);
    public static final ConfigValue<Integer> COMMON_SOLAR_PANEL_6_ENERGY_PEAK_PRODUCTION = ModConfigs.registerEnergyPeakProductionConfigValue("block.solar_panel_6", "Solar Panel (Tier VI)", 131072);
    public static final ConfigValue<Integer> COMMON_MINECART_CHARGER_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("block.minecart_charger", "Minecart Charger", 16384);
    public static final ConfigValue<Integer> COMMON_MINECART_CHARGER_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.minecart_charger", "Minecart Charger", 512);
    public static final ConfigValue<Integer> COMMON_MINECART_UNCHARGER_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("block.minecart_uncharger", "Minecart Uncharger", 16384);
    public static final ConfigValue<Integer> COMMON_MINECART_UNCHARGER_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.minecart_uncharger", "Minecart Uncharger", 512);
    public static final ConfigValue<Integer> COMMON_ADVANCED_MINECART_CHARGER_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("block.advanced_minecart_charger", "Advanced Minecart Charger", 524288);
    public static final ConfigValue<Integer> COMMON_ADVANCED_MINECART_CHARGER_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.advanced_minecart_charger", "Advanced Minecart Charger", 65536);
    public static final ConfigValue<Integer> COMMON_ADVANCED_MINECART_UNCHARGER_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("block.advanced_minecart_uncharger", "Advanced Minecart Uncharger", 524288);
    public static final ConfigValue<Integer> COMMON_ADVANCED_MINECART_UNCHARGER_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.advanced_minecart_uncharger", "Advanced Minecart Uncharger", 65536);
    public static final ConfigValue<Integer> COMMON_CRUSHER_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("block.crusher", "Crusher", 2048);
    public static final ConfigValue<Integer> COMMON_CRUSHER_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.crusher", "Crusher", 128);
    public static final ConfigValue<Integer> COMMON_CRUSHER_ENERGY_CONSUMPTION_PER_TICK = ModConfigs.registerEnergyConsumptionPerTickConfigValue("block.crusher", "Crusher", 8);
    public static final ConfigValue<Integer> COMMON_CRUSHER_RECIPE_DURATION = ModConfigs.registerRecipeDurationConfigValue("block.crusher", "Crusher", 100);
    public static final ConfigValue<Integer> COMMON_ADVANCED_CRUSHER_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("block.advanced_crusher", "Advanced Crusher", 4096);
    public static final ConfigValue<Integer> COMMON_ADVANCED_CRUSHER_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.advanced_crusher", "Advanced Crusher", 256);
    public static final ConfigValue<Integer> COMMON_ADVANCED_CRUSHER_ENERGY_CONSUMPTION_PER_TICK = ModConfigs.registerEnergyConsumptionPerTickConfigValue("block.advanced_crusher", "Advanced Crusher", 32);
    public static final ConfigValue<Integer> COMMON_ADVANCED_CRUSHER_RECIPE_DURATION = ModConfigs.registerRecipeDurationConfigValue("block.advanced_crusher", "Advanced Crusher", 25);
    public static final ConfigValue<Integer> COMMON_ADVANCED_CRUSHER_TANK_CAPACITY = ModConfigs.registerFluidTankCapacityConfigValue("block.advanced_crusher", "Advanced Crusher", 8);
    public static final ConfigValue<Integer> COMMON_ADVANCED_CRUSHER_WATER_USAGE_PER_RECIPE = COMMON_CONFIG.register(new IntegerConfigValue("block.advanced_crusher.water_usage_per_recipe", "The amount of Water in mB (milli Buckets) which will be converted to Dirty Water per completed recipe in the Advanced Crusher.", 10, 1, null));
    public static final ConfigValue<Integer> COMMON_PULVERIZER_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("block.pulverizer", "Pulverizer", 2048);
    public static final ConfigValue<Integer> COMMON_PULVERIZER_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.pulverizer", "Pulverizer", 128);
    public static final ConfigValue<Integer> COMMON_PULVERIZER_ENERGY_CONSUMPTION_PER_TICK = ModConfigs.registerEnergyConsumptionPerTickConfigValue("block.pulverizer", "Pulverizer", 8);
    public static final ConfigValue<Integer> COMMON_PULVERIZER_RECIPE_DURATION = ModConfigs.registerRecipeDurationConfigValue("block.pulverizer", "Pulverizer", 100);
    public static final ConfigValue<Integer> COMMON_ADVANCED_PULVERIZER_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("block.advanced_pulverizer", "Advanced Pulverizer", 4096);
    public static final ConfigValue<Integer> COMMON_ADVANCED_PULVERIZER_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.advanced_pulverizer", "Advanced Pulverizer", 256);
    public static final ConfigValue<Integer> COMMON_ADVANCED_PULVERIZER_ENERGY_CONSUMPTION_PER_TICK = ModConfigs.registerEnergyConsumptionPerTickConfigValue("block.advanced_pulverizer", "Advanced Pulverizer", 32);
    public static final ConfigValue<Integer> COMMON_ADVANCED_PULVERIZER_RECIPE_DURATION = ModConfigs.registerRecipeDurationConfigValue("block.advanced_pulverizer", "Advanced Pulverizer", 25);
    public static final ConfigValue<Integer> COMMON_ADVANCED_PULVERIZER_TANK_CAPACITY = ModConfigs.registerFluidTankCapacityConfigValue("block.advanced_pulverizer", "Advanced Pulverizer", 8);
    public static final ConfigValue<Integer> COMMON_ADVANCED_PULVERIZER_WATER_USAGE_PER_RECIPE = COMMON_CONFIG.register(new IntegerConfigValue("block.advanced_pulverizer.water_usage_per_recipe", "The amount of Water in mB (milli Buckets) which will be converted to Dirty Water per completed recipe in the Advanced Pulverizer.", 10, 1, null));
    public static final ConfigValue<Integer> COMMON_SAWMILL_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("block.sawmill", "Sawmill", 2048);
    public static final ConfigValue<Integer> COMMON_SAWMILL_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.sawmill", "Sawmill", 128);
    public static final ConfigValue<Integer> COMMON_SAWMILL_ENERGY_CONSUMPTION_PER_TICK = ModConfigs.registerEnergyConsumptionPerTickConfigValue("block.sawmill", "Sawmill", 8);
    public static final ConfigValue<Integer> COMMON_SAWMILL_RECIPE_DURATION = ModConfigs.registerRecipeDurationConfigValue("block.sawmill", "Sawmill", 100);
    public static final ConfigValue<Integer> COMMON_COMPRESSOR_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("block.compressor", "Compressor", 2048);
    public static final ConfigValue<Integer> COMMON_COMPRESSOR_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.compressor", "Compressor", 256);
    public static final ConfigValue<Integer> COMMON_COMPRESSOR_ENERGY_CONSUMPTION_PER_TICK = ModConfigs.registerEnergyConsumptionPerTickConfigValue("block.compressor", "Compressor", 16);
    public static final ConfigValue<Integer> COMMON_COMPRESSOR_RECIPE_DURATION = ModConfigs.registerRecipeDurationConfigValue("block.compressor", "Compressor", 100);
    public static final ConfigValue<Integer> COMMON_METAL_PRESS_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("block.metal_press", "Metal Press", 2048);
    public static final ConfigValue<Integer> COMMON_METAL_PRESS_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.metal_press", "Metal Press", 256);
    public static final ConfigValue<Integer> COMMON_METAL_PRESS_ENERGY_CONSUMPTION_PER_TICK = ModConfigs.registerEnergyConsumptionPerTickConfigValue("block.metal_press", "Metal Press", 16);
    public static final ConfigValue<Integer> COMMON_METAL_PRESS_RECIPE_DURATION = ModConfigs.registerRecipeDurationConfigValue("block.metal_press", "Metal Press", 250);
    public static final ConfigValue<Integer> COMMON_AUTO_PRESS_MOLD_MAKER_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("block.auto_press_mold_maker", "Auto Press Mold Maker", 2048);
    public static final ConfigValue<Integer> COMMON_AUTO_PRESS_MOLD_MAKER_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.auto_press_mold_maker", "Auto Press Mold Maker", 128);
    public static final ConfigValue<Integer> COMMON_AUTO_PRESS_MOLD_MAKER_ENERGY_CONSUMPTION_PER_TICK = ModConfigs.registerEnergyConsumptionPerTickConfigValue("block.auto_press_mold_maker", "Auto Press Mold Maker", 8);
    public static final ConfigValue<Integer> COMMON_AUTO_PRESS_MOLD_MAKER_RECIPE_DURATION = ModConfigs.registerRecipeDurationConfigValue("block.auto_press_mold_maker", "Auto Press Mold Maker", 100);
    public static final ConfigValue<Integer> COMMON_AUTO_STONECUTTER_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("block.auto_stonecutter", "Auto Stonecutter", 2048);
    public static final ConfigValue<Integer> COMMON_AUTO_STONECUTTER_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.auto_stonecutter", "Auto Stonecutter", 128);
    public static final ConfigValue<Integer> COMMON_AUTO_STONECUTTER_ENERGY_CONSUMPTION_PER_TICK = ModConfigs.registerEnergyConsumptionPerTickConfigValue("block.auto_stonecutter", "Auto Stonecutter", 8);
    public static final ConfigValue<Integer> COMMON_AUTO_STONECUTTER_RECIPE_DURATION = ModConfigs.registerRecipeDurationConfigValue("block.auto_stonecutter", "Auto Stonecutter", 100);
    public static final ConfigValue<Integer> COMMON_ENERGIZER_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("block.energizer", "Energizer", 65536);
    public static final ConfigValue<Integer> COMMON_ENERGIZER_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.energizer", "Energizer", 16384);
    public static final ConfigValue<Float> COMMON_ENERGIZER_ENERGY_CONSUMPTION_MULTIPLIER = ModConfigs.registerEnergyConsumptionMultiplierConfigValue("block.energizer", "Energizer");
    public static final ConfigValue<Integer> COMMON_ENERGIZER_RECIPE_DURATION = ModConfigs.registerRecipeDurationConfigValue("block.energizer", "Energizer", 100);
    public static final ConfigValue<Integer> COMMON_AUTO_CRAFTER_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("block.auto_crafter", "Auto Crafter", 2048);
    public static final ConfigValue<Integer> COMMON_AUTO_CRAFTER_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.auto_crafter", "Auto Crafter", 256);
    public static final ConfigValue<Integer> COMMON_AUTO_CRAFTER_ENERGY_CONSUMPTION_PER_TICK_PER_INGREDIENT = COMMON_CONFIG.register(new IntegerConfigValue("block.auto_crafter.energy_consumption_per_tick_per_ingredient", "The energy consumption of the Auto Crafter if active in FE per tick per ingredient", 2, 1, null));
    public static final ConfigValue<Integer> COMMON_AUTO_CRAFTER_RECIPE_DURATION = ModConfigs.registerRecipeDurationConfigValue("block.auto_crafter", "Auto Crafter", 100);
    public static final ConfigValue<List<@NotNull ResourceLocation>> COMMON_AUTO_CRAFTER_RECIPE_BLACKLIST = ModConfigs.registerRecipeBlacklistValue("block.auto_crafter", "Auto Crafter", new ArrayList<ResourceLocation>(0));
    public static final ConfigValue<Integer> COMMON_ADVANCED_AUTO_CRAFTER_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("block.advanced_auto_crafter", "Advanced Auto Crafter", 16384);
    public static final ConfigValue<Integer> COMMON_ADVANCED_AUTO_CRAFTER_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.advanced_auto_crafter", "Advanced Auto Crafter", 1024);
    public static final ConfigValue<Integer> COMMON_ADVANCED_AUTO_CRAFTER_ENERGY_CONSUMPTION_PER_TICK_PER_INGREDIENT = COMMON_CONFIG.register(new IntegerConfigValue("block.advanced_auto_crafter.energy_consumption_per_tick_per_ingredient", "The energy consumption of the Advanced Auto Crafter if active in FE per tick per ingredient", 16, 1, null));
    public static final ConfigValue<Integer> COMMON_ADVANCED_AUTO_CRAFTER_RECIPE_DURATION = ModConfigs.registerRecipeDurationConfigValue("block.advanced_auto_crafter", "Advanced Auto Crafter", 50);
    public static final ConfigValue<List<@NotNull ResourceLocation>> COMMON_ADVANCED_AUTO_CRAFTER_RECIPE_BLACKLIST = ModConfigs.registerRecipeBlacklistValue("block.advanced_auto_crafter", "Advanced Auto Crafter", new ArrayList<ResourceLocation>(0));
    public static final ConfigValue<Integer> COMMON_HEAT_GENERATOR_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("block.heat_generator", "Heat Generator", 10000);
    public static final ConfigValue<Integer> COMMON_HEAT_GENERATOR_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.heat_generator", "Heat Generator", 500);
    public static final ConfigValue<Float> COMMON_HEAT_GENERATOR_ENERGY_PRODUCTION_MULTIPLIER = ModConfigs.registerEnergyProductionMultiplierConfigValue("block.heat_generator", "Heat Generator");
    public static final ConfigValue<Integer> COMMON_THERMAL_GENERATOR_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("block.thermal_generator", "Thermal Generator", 40960);
    public static final ConfigValue<Integer> COMMON_THERMAL_GENERATOR_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.thermal_generator", "Thermal Generator", 2048);
    public static final ConfigValue<Float> COMMON_THERMAL_GENERATOR_ENERGY_PRODUCTION_MULTIPLIER = ModConfigs.registerEnergyProductionMultiplierConfigValue("block.thermal_generator", "Thermal Generator");
    public static final ConfigValue<Integer> COMMON_THERMAL_GENERATOR_FLUID_TANK_CAPACITY = ModConfigs.registerFluidTankCapacityConfigValue("block.thermal_generator", "Thermal Generator", 8);
    public static final ConfigValue<Integer> COMMON_BLOCK_PLACER_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("block.block_placer", "Block Placer", 2048);
    public static final ConfigValue<Integer> COMMON_BLOCK_PLACER_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.block_placer", "Block Placer", 128);
    public static final ConfigValue<Integer> COMMON_BLOCK_PLACER_ENERGY_CONSUMPTION_PER_TICK = ModConfigs.registerEnergyConsumptionPerTickConfigValue("block.block_placer", "Block Placer", 32);
    public static final ConfigValue<Integer> COMMON_BLOCK_PLACER_PLACEMENT_DURATION = COMMON_CONFIG.register(new IntegerConfigValue("block.block_placer.placement_duration", "The time the Block Placer requires to place a block in ticks", 20, 1, null));
    public static final ConfigValue<List<@NotNull ResourceLocation>> COMMON_BLOCK_PLACER_PLACEMENT_BLACKLIST = COMMON_CONFIG.register(new ResourceLocationListConfigValue("block.block_placer.placement_blacklist", "Blocks in this list can not be placed by the Block Placer.", (List<ResourceLocation>)new ArrayList<ResourceLocation>(0)));
    public static final ConfigValue<Integer> COMMON_ASSEMBLING_MACHINE_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("block.assembling_machine", "Assembling Machine", 8192);
    public static final ConfigValue<Integer> COMMON_ASSEMBLING_MACHINE_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.assembling_machine", "Assembling Machine", 512);
    public static final ConfigValue<Integer> COMMON_ASSEMBLING_MACHINE_ENERGY_CONSUMPTION_PER_TICK = ModConfigs.registerEnergyConsumptionPerTickConfigValue("block.assembling_machine", "Assembling Machine", 256);
    public static final ConfigValue<Integer> COMMON_ASSEMBLING_MACHINE_RECIPE_DURATION = ModConfigs.registerRecipeDurationConfigValue("block.assembling_machine", "Assembling Machine", 200);
    public static final ConfigValue<Integer> COMMON_POWERED_LAMP_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.powered_lamp", "Powered Lamp", 1);
    public static final ConfigValue<Integer> COMMON_POWERED_FURNACE_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("block.powered_furnace", "Powered Furnace", 2048);
    public static final ConfigValue<Integer> COMMON_POWERED_FURNACE_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.powered_furnace", "Powered Furnace", 128);
    public static final ConfigValue<Integer> COMMON_POWERED_FURNACE_ENERGY_CONSUMPTION_PER_TICK = ModConfigs.registerEnergyConsumptionPerTickConfigValue("block.powered_furnace", "Powered Furnace", 2);
    public static final ConfigValue<Float> COMMON_POWERED_FURNACE_RECIPE_DURATION_MULTIPLIER = COMMON_CONFIG.register(new FloatConfigValue("block.powered_furnace.recipe_duration_multiplier", "The multiplier by which the time a recipe of the Powered Furnace requires is multiplied by.\n=> If set to 2 the Powered Furnace will be as fast as the normal Furnace.", Float.valueOf(1.0f), Float.valueOf(0.0f), null));
    public static final ConfigValue<List<@NotNull ResourceLocation>> COMMON_POWERED_FURNACE_RECIPE_BLACKLIST = ModConfigs.registerRecipeBlacklistValue("block.powered_furnace", "Powered Furnace", new ArrayList<ResourceLocation>(0));
    public static final ConfigValue<Integer> COMMON_ADVANCED_POWERED_FURNACE_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("block.advanced_powered_furnace", "Advanced Powered Furnace", 16384);
    public static final ConfigValue<Integer> COMMON_ADVANCED_POWERED_FURNACE_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.advanced_powered_furnace", "Advanced Powered Furnace", 1024);
    public static final ConfigValue<Integer> COMMON_ADVANCED_POWERED_FURNACE_ENERGY_CONSUMPTION_PER_INPUT_PER_TICK = COMMON_CONFIG.register(new IntegerConfigValue("block.advanced_powered_furnace.energy_consumption_per_input_per_tick", "The energy consumption per input of the Advanced Powered Furnace in FE per tick.", 256, 1, null));
    public static final ConfigValue<Float> COMMON_ADVANCED_POWERED_FURNACE_RECIPE_DURATION_MULTIPLIER = COMMON_CONFIG.register(new FloatConfigValue("block.advanced_powered_furnace.recipe_duration_multiplier", "The multiplier by which the time a recipe of the Advanced Powered Furnace requires is multiplied by.\n=> If set to 6 the Advanced Powered Furnace will be as fast as the normal Furnace.", Float.valueOf(1.0f), Float.valueOf(0.0f), null));
    public static final ConfigValue<List<@NotNull ResourceLocation>> COMMON_ADVANCED_POWERED_FURNACE_RECIPE_BLACKLIST = ModConfigs.registerRecipeBlacklistValue("block.advanced_powered_furnace", "Advanced Powered Furnace", new ArrayList<ResourceLocation>(0));
    public static final ConfigValue<Integer> COMMON_PLANT_GROWTH_CHAMBER_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("block.plant_growth_chamber", "Plant Growth Chamber", 4096);
    public static final ConfigValue<Integer> COMMON_PLANT_GROWTH_CHAMBER_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.plant_growth_chamber", "Plant Growth Chamber", 256);
    public static final ConfigValue<Integer> COMMON_PLANT_GROWTH_CHAMBER_ENERGY_CONSUMPTION_PER_TICK = ModConfigs.registerEnergyConsumptionPerTickConfigValue("block.plant_growth_chamber", "Plant Growth Chamber", 32);
    public static final ConfigValue<Float> COMMON_PLANT_GROWTH_CHAMBER_RECIPE_DURATION_MULTIPLIER = ModConfigs.registerRecipeDurationMultiplierConfigValue("block.plant_growth_chamber", "Plant Growth Chamber");
    public static final ConfigValue<Integer> COMMON_STONE_SOLIDIFIER_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("block.stone_solidifier", "Stone Solidifier", 4096);
    public static final ConfigValue<Integer> COMMON_STONE_SOLIDIFIER_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.stone_solidifier", "Stone Solidifier", 256);
    public static final ConfigValue<Integer> COMMON_STONE_SOLIDIFIER_CONSUMPTION_PER_TICK = ModConfigs.registerEnergyConsumptionPerTickConfigValue("block.stone_solidifier", "Stone Solidifier", 128);
    public static final ConfigValue<Integer> COMMON_STONE_SOLIDIFIER_TANK_CAPACITY = ModConfigs.registerFluidTankCapacityConfigValue("block.stone_solidifier", "Stone Solidifier", 8);
    public static final ConfigValue<Integer> COMMON_STONE_SOLIDIFIER_RECIPE_DURATION = ModConfigs.registerRecipeDurationConfigValue("block.stone_solidifier", "Stone Solidifier", 25);
    public static final ConfigValue<Integer> COMMON_FILTRATION_PLANT_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("block.filtration_plant", "Filtration Plant", 4096);
    public static final ConfigValue<Integer> COMMON_FILTRATION_PLANT_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.filtration_plant", "Filtration Plant", 256);
    public static final ConfigValue<Integer> COMMON_FILTRATION_PLANT_CONSUMPTION_PER_TICK = ModConfigs.registerEnergyConsumptionPerTickConfigValue("block.filtration_plant", "Filtration Plant", 128);
    public static final ConfigValue<Integer> COMMON_FILTRATION_PLANT_TANK_CAPACITY = ModConfigs.registerFluidTankCapacityConfigValue("block.filtration_plant", "Filtration Plant", 8);
    public static final ConfigValue<Integer> COMMON_FILTRATION_PLANT_RECIPE_DURATION = ModConfigs.registerRecipeDurationConfigValue("block.filtration_plant", "Filtration Plant", 1000);
    public static final ConfigValue<Integer> COMMON_FILTRATION_PLANT_DIRTY_WATER_USAGE_PER_RECIPE = COMMON_CONFIG.register(new IntegerConfigValue("block.filtration_plant.water_usage_per_recipe", "The amount of Dirty Water in mB (milli Buckets) which will be converted to Water per completed recipe in the Filtration Plant.", 100, 1, null));
    public static final ConfigValue<Integer> COMMON_FLUID_TRANSPOSER_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("block.fluid_transposer", "Fluid Transposer", 4096);
    public static final ConfigValue<Integer> COMMON_FLUID_TRANSPOSER_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.fluid_transposer", "Fluid Transposer", 256);
    public static final ConfigValue<Integer> COMMON_FLUID_TRANSPOSER_ENERGY_CONSUMPTION_PER_TICK = ModConfigs.registerEnergyConsumptionPerTickConfigValue("block.fluid_transposer", "Fluid Transposer", 128);
    public static final ConfigValue<Integer> COMMON_FLUID_TRANSPOSER_TANK_CAPACITY = ModConfigs.registerFluidTankCapacityConfigValue("block.fluid_transposer", "Fluid Transposer", 8);
    public static final ConfigValue<Integer> COMMON_FLUID_TRANSPOSER_RECIPE_DURATION = ModConfigs.registerRecipeDurationConfigValue("block.fluid_transposer", "Fluid Transposer", 200);
    public static final ConfigValue<Integer> COMMON_FLUID_FILLER_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("block.fluid_filler", "Fluid Filler", 2048);
    public static final ConfigValue<Integer> COMMON_FLUID_FILLER_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.fluid_filler", "Fluid Filler", 128);
    public static final ConfigValue<Integer> COMMON_FLUID_FILLER_ENERGY_CONSUMPTION_PER_TICK = ModConfigs.registerEnergyConsumptionPerTickConfigValue("block.fluid_filler", "Fluid Filler", 64);
    public static final ConfigValue<Integer> COMMON_FLUID_FILLER_FLUID_TANK_CAPACITY = ModConfigs.registerFluidTankCapacityConfigValue("block.fluid_filler", "Fluid Filler", 8);
    public static final ConfigValue<Integer> COMMON_FLUID_FILLER_FLUID_ITEM_TRANSFER_RATE = COMMON_CONFIG.register(new IntegerConfigValue("block.fluid_filler.fluid_item_transfer_rate", "The transfer rate an item can be filled up at by the Fluid Filler in mB (milli Buckets)", 100, 1, null));
    public static final ConfigValue<Integer> COMMON_FLUID_DRAINER_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("block.fluid_drainer", "Fluid Drainer", 2048);
    public static final ConfigValue<Integer> COMMON_FLUID_DRAINER_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.fluid_drainer", "Fluid Drainer", 128);
    public static final ConfigValue<Integer> COMMON_FLUID_DRAINER_ENERGY_CONSUMPTION_PER_TICK = ModConfigs.registerEnergyConsumptionPerTickConfigValue("block.fluid_drainer", "Fluid Drainer", 64);
    public static final ConfigValue<Integer> COMMON_FLUID_DRAINER_FLUID_TANK_CAPACITY = ModConfigs.registerFluidTankCapacityConfigValue("block.fluid_drainer", "Fluid Drainer", 8);
    public static final ConfigValue<Integer> COMMON_FLUID_DRAINER_FLUID_ITEM_TRANSFER_RATE = COMMON_CONFIG.register(new IntegerConfigValue("block.fluid_drainer.fluid_item_transfer_rate", "The transfer rate an item can be drained at by the Fluid Drainer in mB (milli Buckets)", 100, 1, null));
    public static final ConfigValue<Integer> COMMON_FLUID_PUMP_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("block.fluid_pump", "Fluid Pump", 2048);
    public static final ConfigValue<Integer> COMMON_FLUID_PUMP_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.fluid_pump", "Fluid Pump", 128);
    public static final ConfigValue<Integer> COMMON_FLUID_PUMP_CONSUMPTION_PER_TICK = ModConfigs.registerEnergyConsumptionPerTickConfigValue("block.fluid_pump", "Fluid Pump", 32);
    public static final ConfigValue<Integer> COMMON_FLUID_PUMP_FLUID_TANK_CAPACITY = ModConfigs.registerFluidTankCapacityConfigValue("block.fluid_pump", "Fluid Pump", 16);
    public static final ConfigValue<Integer> COMMON_FLUID_PUMP_NEXT_BLOCK_COOLDOWN = COMMON_CONFIG.register(new IntegerConfigValue("block.fluid_pump.next_block_cooldown", "The time the Fluid Pump requires to check the next block in ticks", 20, 1, null));
    public static final ConfigValue<Integer> COMMON_FLUID_PUMP_EXTRACTION_DURATION = COMMON_CONFIG.register(new IntegerConfigValue("block.fluid_pump.extraction_duration", "The time the Fluid Pump requires to extract fluids from a block in ticks", 100, 1, null));
    public static final ConfigValue<Integer> COMMON_FLUID_PUMP_EXTRACTION_RANGE = COMMON_CONFIG.register(new IntegerConfigValue("block.fluid_pump.extraction_range", "The horizontal extraction range of the Fluid Pump in blocks", 5, 1, null));
    public static final ConfigValue<Integer> COMMON_FLUID_PUMP_EXTRACTION_DEPTH = COMMON_CONFIG.register(new IntegerConfigValue("block.fluid_pump.extraction_depth", "The vertical extraction depth of the Fluid Pump in blocks", 64, 1, null));
    public static final ConfigValue<Integer> COMMON_DRAIN_FLUID_TANK_CAPACITY = ModConfigs.registerFluidTankCapacityConfigValue("block.drain", "Drain", 2);
    public static final ConfigValue<Integer> COMMON_DRAIN_DRAIN_DURATION = COMMON_CONFIG.register(new IntegerConfigValue("block.drain.drain_duration", "The amount of ticks the Drain requires to drain 1000 mB (milli Buckets) from the fluid source block above.", 20, 1, null));
    public static final ConfigValue<Integer> COMMON_IRON_FLUID_PIPE_FLUID_TRANSFER_RATE = COMMON_CONFIG.register(new IntegerConfigValue("block.iron_fluid_pipe.fluid_transfer_rate", "The transfer rate per tank and face of an Iron Fluid Pipe face in the extraction state in mB (milli Buckets)", 100, 1, null));
    public static final ConfigValue<Integer> COMMON_GOLDEN_FLUID_PIPE_FLUID_TRANSFER_RATE = COMMON_CONFIG.register(new IntegerConfigValue("block.golden_fluid_pipe.fluid_transfer_rate", "The transfer rate per tank and face of a Golden Fluid Pipe face in the extraction state in mB (milli Buckets)", 1000, 1, null));
    public static final ConfigValue<Integer> COMMON_FLUID_TANK_SMALL_TANK_CAPACITY = ModConfigs.registerFluidTankCapacityConfigValue("block.fluid_tank_small", "Fluid Tank (Small)", 8);
    public static final ConfigValue<Integer> COMMON_FLUID_TANK_MEDIUM_TANK_CAPACITY = ModConfigs.registerFluidTankCapacityConfigValue("block.fluid_tank_medium", "Fluid Tank (Medium)", 32);
    public static final ConfigValue<Integer> COMMON_FLUID_TANK_LARGE_TANK_CAPACITY = ModConfigs.registerFluidTankCapacityConfigValue("block.fluid_tank_large", "Fluid Tank (Large)", 128);
    public static final ConfigValue<Integer> COMMON_CHARGER_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("block.charger", "Charger", 8192);
    public static final ConfigValue<Integer> COMMON_CHARGER_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.charger", "Charger", 512);
    public static final ConfigValue<Float> COMMON_CHARGER_CHARGER_RECIPE_ENERGY_CONSUMPTION_MULTIPLIER = COMMON_CONFIG.register(new FloatConfigValue("block.charger.charger_recipe_energy_consumption_multiplier", "The multiplier by which the energy consumption of charger recipes in the Charger is multiplied by.", Float.valueOf(1.0f), Float.valueOf(0.0f), null));
    public static final ConfigValue<Integer> COMMON_ADVANCED_CHARGER_CAPACITY_PER_SLOT = COMMON_CONFIG.register(new IntegerConfigValue("block.advanced_charger.capacity_per_slot", "The energy capacity per slot of the Advanced Charger in FE.\n=> The energy capacity of the block is three times this value.", 65536, 1, null));
    public static final ConfigValue<Integer> COMMON_ADVANCED_CHARGER_TRANSFER_RATE_PER_SLOT = COMMON_CONFIG.register(new IntegerConfigValue("block.advanced_charger.transfer_rate_per_slot", "The energy transfer rate per slot of the Advanced Charger in FE per tick.\n=> The energy transfer rate of the block is three times this value.", 8192, 1, null));
    public static final ConfigValue<Float> COMMON_ADVANCED_CHARGER_CHARGER_RECIPE_ENERGY_CONSUMPTION_MULTIPLIER = COMMON_CONFIG.register(new FloatConfigValue("block.advanced_charger.charger_recipe_energy_consumption_multiplier", "The multiplier by which the energy consumption of charger recipes in the Charger is multiplied by.", Float.valueOf(1.0f), Float.valueOf(0.0f), null));
    public static final ConfigValue<Integer> COMMON_UNCHARGER_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("block.uncharger", "Uncharger", 8192);
    public static final ConfigValue<Integer> COMMON_UNCHARGER_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("block.uncharger", "Uncharger", 512);
    public static final ConfigValue<Integer> COMMON_ADVANCED_UNCHARGER_CAPACITY_PER_SLOT = COMMON_CONFIG.register(new IntegerConfigValue("block.advanced_uncharger.capacity_per_slot", "The energy capacity per slot of the Advanced Uncharger in FE.\n=> The energy capacity of the block is three times this value.", 65536, 1, null));
    public static final ConfigValue<Integer> COMMON_ADVANCED_UNCHARGER_TRANSFER_RATE_PER_SLOT = COMMON_CONFIG.register(new IntegerConfigValue("block.advanced_uncharger.transfer_rate_per_slot", "The energy transfer rate per slot of the Advanced Uncharger in FE per tick.\n=> The energy transfer rate of the block is three times this value.", 8192, 1, null));
    public static final ConfigValue<Integer> COMMON_ITEM_CONVEYOR_BELT_TICKS_PER_STEP = COMMON_CONFIG.register(new IntegerConfigValue("block.item_conveyor_belt.ticks_per_step", "The time required for the Item Conveyor Belt to transport an item one step in ticks per step", 10, 1, null));
    public static final ConfigValue<Integer> COMMON_ITEM_CONVEYOR_BELT_LOADER_TICKS_PER_ITEM = COMMON_CONFIG.register(new IntegerConfigValue("block.item_conveyor_belt_loader.ticks_per_item", "The time required for the Item Conveyor Belt Loader to extract a single item in ticks", 10, 1, null));
    public static final ConfigValue<Integer> COMMON_ITEM_CONVEYOR_BELT_SORTER_TICKS_PER_ITEM = COMMON_CONFIG.register(new IntegerConfigValue("block.item_conveyor_belt_sorter.ticks_per_item", "The time required for the Item Conveyor Belt Sorter to process a single item in ticks", 10, 1, null));
    public static final ConfigValue<Integer> COMMON_ITEM_CONVEYOR_BELT_SWITCH_TICKS_PER_ITEM = COMMON_CONFIG.register(new IntegerConfigValue("block.item_conveyor_belt_switch.ticks_per_item", "The time required for the Item Conveyor Belt Switch to process a single item in ticks", 10, 1, null));
    public static final ConfigValue<Integer> COMMON_ITEM_CONVEYOR_BELT_SPLITTER_TICKS_PER_ITEM = COMMON_CONFIG.register(new IntegerConfigValue("block.item_conveyor_belt_splitter.ticks_per_item", "The time required for the Item Conveyor Belt Splitter to process a single item in ticks", 10, 1, null));
    public static final ConfigValue<Integer> COMMON_ITEM_CONVEYOR_BELT_MERGER_TICKS_PER_ITEM = COMMON_CONFIG.register(new IntegerConfigValue("block.item_conveyor_belt_merger.ticks_per_item", "The time required for the Item Conveyor Belt Merger to process a single item in ticks", 10, 1, null));
    public static final ConfigValue<Integer> COMMON_BATTERY_BOX_MINECART_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("entity.battery_box_minecart", "Battery Box Minecart", 65536);
    public static final ConfigValue<Integer> COMMON_BATTERY_BOX_MINECART_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("entity.battery_box_minecart", "Battery Box Minecart", 512);
    public static final ConfigValue<Integer> COMMON_ADVANCED_BATTERY_BOX_MINECART_CAPACITY = ModConfigs.registerEnergyCapacityConfigValue("entity.advanced_battery_box_minecart", "Advanced Battery Box Minecart", 0x800000);
    public static final ConfigValue<Integer> COMMON_ADVANCED_BATTERY_BOX_MINECART_TRANSFER_RATE = ModConfigs.registerEnergyTransferRateConfigValue("entity.advanced_battery_box_minecart", "Advanced Battery Box Minecart", 65536);
    public static final ConfigValue<Integer> COMMON_ELECTRICIAN_BUILDING_1_PLACEMENT_WEIGHT = COMMON_CONFIG.register(new IntegerConfigValue("world.village.electrician_building_1.placement_weight", "Determines how frequent the Electrician Building 1 will be placed in villages.\n=> If set to 0 the Electrician Building 1 will never be placed.", 5, 0, 100));
    public static final Config SERVER_CONFIG = new Config(ModConfigs.getRelativeConfigFile("server.conf"), "Energized Power Server Config");
    public static final Config CLIENT_CONFIG = new Config(ModConfigs.getRelativeConfigFile("client.conf"), "Energized Power Client Config");
    public static final ConfigValue<Integer> CLIENT_ENERGIZED_POWER_BOOK_IMAGE_CYCLE_DELAY = CLIENT_CONFIG.register(new IntegerConfigValue("energized_power_book.image_cycle_delay", "The tick amount to wait between two images in the Energized Power Book", 50, 5, 1200));
    public static final ConfigValue<Boolean> CLIENT_FLUID_PUMP_RELATIVE_TARGET_COORDINATES = CLIENT_CONFIG.register(new BooleanConfigValue("block.fluid_pump.relative_target_coordinates", "If set to true relative target coordinates will be shown instead of absolute coordinates in the Fluid Pump", true));

    private ModConfigs() {
    }

    private static File getRelativeConfigFile(String fileName) {
        return FMLPaths.CONFIGDIR.get().resolve("energizedpower/" + fileName).toFile();
    }

    private static ConfigValue<Integer> registerEnergyCapacityConfigValue(String baseConfigKey, String itemName, int defaultValue) {
        return COMMON_CONFIG.register(new IntegerConfigValue(baseConfigKey + ".capacity", "The energy capacity of the " + itemName + " in FE", defaultValue, 1, null));
    }

    private static ConfigValue<Integer> registerEnergyTransferRateConfigValue(String baseConfigKey, String itemName, int defaultValue) {
        return COMMON_CONFIG.register(new IntegerConfigValue(baseConfigKey + ".transfer_rate", "The energy transfer rate of the " + itemName + " in FE per tick", defaultValue, 1, null));
    }

    private static ConfigValue<Integer> registerEnergyPeakProductionConfigValue(String baseConfigKey, String itemName, int defaultValue) {
        return COMMON_CONFIG.register(new IntegerConfigValue(baseConfigKey + ".energy_peak_production", "The peak energy production of the " + itemName + " for ideal conditions (e.g. at noon with clear sky for solar panels) in FE per tick", defaultValue, 1, null));
    }

    private static ConfigValue<Integer> registerEnergyConsumptionPerTickConfigValue(String baseConfigKey, String itemName, int defaultValue) {
        return COMMON_CONFIG.register(new IntegerConfigValue(baseConfigKey + ".energy_consumption_per_tick", "The energy consumption of the " + itemName + " if active in FE per tick", defaultValue, 1, null));
    }

    private static ConfigValue<Float> registerEnergyConsumptionMultiplierConfigValue(String baseConfigKey, String itemName) {
        return COMMON_CONFIG.register(new FloatConfigValue(baseConfigKey + ".energy_consumption_multiplier", "The multiplier by which the energy consumption of the " + itemName + " is multiplied by", Float.valueOf(1.0f), Float.valueOf(0.0f), null));
    }

    private static ConfigValue<Float> registerEnergyProductionMultiplierConfigValue(String baseConfigKey, String itemName) {
        return COMMON_CONFIG.register(new FloatConfigValue(baseConfigKey + ".energy_production_multiplier", "The multiplier by which the energy production of the " + itemName + " is multiplied by", Float.valueOf(1.0f), Float.valueOf(0.0f), null));
    }

    private static ConfigValue<Integer> registerEnergyConsumptionPerUseConfigValue(String baseConfigKey, String itemName, int defaultValue) {
        return COMMON_CONFIG.register(new IntegerConfigValue(baseConfigKey + ".energy_consumption_per_use", "The energy consumption of the " + itemName + " in FE per use", defaultValue, 1, null));
    }

    private static ConfigValue<Integer> registerFluidTankCapacityConfigValue(String baseConfigKey, String itemName, int defaultValue) {
        return COMMON_CONFIG.register(new IntegerConfigValue(baseConfigKey + ".fluid_tank_capacity", "The fluid tank capacity of the " + itemName + " in buckets (= 1000 mB)", defaultValue, 1, null));
    }

    private static ConfigValue<Integer> registerRecipeDurationConfigValue(String baseConfigKey, String itemName, int defaultValue) {
        return COMMON_CONFIG.register(new IntegerConfigValue(baseConfigKey + ".recipe_duration", "The time a recipe of the " + itemName + " requires in ticks", defaultValue, 1, null));
    }

    private static ConfigValue<Float> registerRecipeDurationMultiplierConfigValue(String baseConfigKey, String itemName) {
        return COMMON_CONFIG.register(new FloatConfigValue(baseConfigKey + ".recipe_duration_multiplier", "The multiplier by which the time a recipe of the " + itemName + " requires is multiplied by", Float.valueOf(1.0f), Float.valueOf(0.0f), null));
    }

    private static ConfigValue<List<@NotNull ResourceLocation>> registerRecipeBlacklistValue(String baseConfigKey, String itemName, @NotNull @NotNull List<@NotNull ResourceLocation> defaultValue) {
        return COMMON_CONFIG.register(new ResourceLocationListConfigValue(baseConfigKey + ".recipe_blacklist", "The recipe blacklist for the " + itemName + ".\nThe blacklist is a list of recipe ids which can not be crafted in the " + itemName, defaultValue));
    }

    private static ConfigValue<Double> registerSpeedModuleEffectValue(int tier, String tierRomanNumerals, double defaultValue) {
        return COMMON_CONFIG.register(new DoubleConfigValue("item.speed_upgrade_module_" + tier + ".effect_value", "The upgrade module effect (Production speed multiplier) of the Speed Upgrade Module (Tier " + tierRomanNumerals + ")", defaultValue, 1.0, null));
    }

    private static ConfigValue<Double> registerSpeedModuleEnergyConsumptionEffectValue(int tier, String tierRomanNumerals, double defaultValue) {
        return COMMON_CONFIG.register(new DoubleConfigValue("item.speed_upgrade_module_" + tier + ".effect_value.energy_consumption", "The upgrade module effect (Energy Consumption per tick multiplier) of the Speed Upgrade Module (Tier " + tierRomanNumerals + ")", defaultValue, 1.0, null));
    }

    private static ConfigValue<Double> registerEnergyEfficiencyModuleEffectValue(int tier, String tierRomanNumerals, double defaultValue) {
        return COMMON_CONFIG.register(new DoubleConfigValue("item.energy_efficiency_upgrade_module_" + tier + ".effect_value", "The upgrade module effect (Energy Consumption per tick multiplier) of the Energy Efficiency Upgrade Module (Tier " + tierRomanNumerals + ")", defaultValue, 0.0, 1.0));
    }

    private static ConfigValue<Double> registerEnergyCapacityModuleEffectValue(int tier, String tierRomanNumerals, double defaultValue) {
        return COMMON_CONFIG.register(new DoubleConfigValue("item.energy_capacity_upgrade_module_" + tier + ".effect_value", "The upgrade module effect (Energy capacity multiplier) of the Energy Capacity Upgrade Module (Tier " + tierRomanNumerals + ")", defaultValue, 1.0, null));
    }

    private static ConfigValue<Double> registerEnergyCapacityModuleEnergyTransferRateEffectValue(int tier, String tierRomanNumerals, double defaultValue) {
        return COMMON_CONFIG.register(new DoubleConfigValue("item.energy_capacity_upgrade_module_" + tier + ".energy_transfer_rate.effect_value", "The upgrade module effect (Energy transfer rate multiplier) of the Energy Capacity Upgrade Module (Tier " + tierRomanNumerals + ")", defaultValue, 1.0, null));
    }

    private static ConfigValue<Double> registerDurationUpgradeModuleEffectValue(int tier, String tierRomanNumerals, double defaultValue) {
        return COMMON_CONFIG.register(new DoubleConfigValue("item.duration_upgrade_module_" + tier + ".effect_value", "The upgrade module effect (Duration multiplier) of the Duration Upgrade Module (Tier " + tierRomanNumerals + ")", defaultValue, 1.0, null));
    }

    private static ConfigValue<Double> registerRangeUpgradeModuleEffectValue(int tier, String tierRomanNumerals, double defaultValue) {
        return COMMON_CONFIG.register(new DoubleConfigValue("item.range_upgrade_module_" + tier + ".effect_value", "The upgrade module effect (Range multiplier) of the Range Upgrade Module (Tier " + tierRomanNumerals + ")", defaultValue, 1.0, null));
    }

    private static ConfigValue<Integer> registerExtractionDepthUpgradeModuleEffectValue(int tier, String tierRomanNumerals, int defaultValue) {
        return COMMON_CONFIG.register(new IntegerConfigValue("item.extraction_depth_upgrade_module_" + tier + ".effect_value", "The upgrade module effect (Addition Extraction Depth in Blocks) of the Extraction Depth Upgrade Module (Tier " + tierRomanNumerals + ")", defaultValue, 1, null));
    }

    private static ConfigValue<Double> registerMoonLightUpgradeModuleEffectValue(int tier, String tierRomanNumerals, double defaultValue) {
        return COMMON_CONFIG.register(new DoubleConfigValue("item.moon_light_upgrade_module_" + tier + ".effect_value", "The upgrade module effect (Multiplier of peak energy production during nighttime relative to the peak energy production during daytime) of the Moon Light Upgrade Module (Tier " + tierRomanNumerals + ")", defaultValue, 0.0, null));
    }

    public static void registerConfigs(boolean isServer) {
        if (!COMMON_CONFIG.isLoaded()) {
            try {
                COMMON_CONFIG.read();
                LOGGER.info("Energized Power common config was successfully loaded");
            }
            catch (IOException | ConfigValidationException e) {
                LOGGER.error("Energized Power common config could not be read", (Throwable)e);
            }
        }
        if (isServer) {
            if (!SERVER_CONFIG.isLoaded()) {
                try {
                    SERVER_CONFIG.read();
                    LOGGER.info("Energized Power server config was successfully loaded");
                }
                catch (IOException | ConfigValidationException e) {
                    LOGGER.error("Energized Power server config could not be read", (Throwable)e);
                }
            }
        } else if (!CLIENT_CONFIG.isLoaded()) {
            try {
                CLIENT_CONFIG.read();
                LOGGER.info("Energized Power client config was successfully loaded");
            }
            catch (IOException | ConfigValidationException e) {
                LOGGER.error("Energized Power client config could not be read", (Throwable)e);
            }
        }
    }
}

