/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity.base;

import java.util.Optional;
import me.jddev0.ep.block.entity.base.FluidStorageMethods;
import me.jddev0.ep.block.entity.base.UpgradableMenuProvider;
import me.jddev0.ep.block.entity.base.WorkerFluidMachineBlockEntity;
import me.jddev0.ep.machine.configuration.ComparatorMode;
import me.jddev0.ep.machine.configuration.RedstoneMode;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.util.ByteUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public abstract class SimpleRecipeFluidMachineBlockEntity<F extends IFluidHandler, R extends Recipe<Container>>
extends WorkerFluidMachineBlockEntity<F, R> {
    protected final UpgradableMenuProvider menuProvider;
    protected final RecipeType<R> recipeType;

    public SimpleRecipeFluidMachineBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState, String machineName, UpgradableMenuProvider menuProvider, int slotCount, RecipeType<R> recipeType, int baseRecipeDuration, int baseEnergyCapacity, int baseEnergyTransferRate, int baseEnergyConsumptionPerTick, FluidStorageMethods<F> fluidStorageMethods, int baseTankCapacity, UpgradeModuleModifier ... upgradeModifierSlots) {
        super(type, blockPos, blockState, machineName, slotCount, baseRecipeDuration, baseEnergyCapacity, baseEnergyTransferRate, baseEnergyConsumptionPerTick, fluidStorageMethods, baseTankCapacity, upgradeModifierSlots);
        this.menuProvider = menuProvider;
        this.recipeType = recipeType;
    }

    @Override
    protected ContainerData initContainerData() {
        return new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0, 1 -> ByteUtils.get2Bytes(SimpleRecipeFluidMachineBlockEntity.this.progress, index);
                    case 2, 3 -> ByteUtils.get2Bytes(SimpleRecipeFluidMachineBlockEntity.this.maxProgress, index - 2);
                    case 4, 5 -> ByteUtils.get2Bytes(SimpleRecipeFluidMachineBlockEntity.this.energyConsumptionLeft, index - 4);
                    case 6 -> {
                        if (SimpleRecipeFluidMachineBlockEntity.this.hasEnoughEnergy) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 7 -> SimpleRecipeFluidMachineBlockEntity.this.redstoneMode.ordinal();
                    case 8 -> SimpleRecipeFluidMachineBlockEntity.this.comparatorMode.ordinal();
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: 
                    case 1: {
                        SimpleRecipeFluidMachineBlockEntity.this.progress = ByteUtils.with2Bytes(SimpleRecipeFluidMachineBlockEntity.this.progress, (short)value, index);
                        break;
                    }
                    case 2: 
                    case 3: {
                        SimpleRecipeFluidMachineBlockEntity.this.maxProgress = ByteUtils.with2Bytes(SimpleRecipeFluidMachineBlockEntity.this.maxProgress, (short)value, index - 2);
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        break;
                    }
                    case 7: {
                        SimpleRecipeFluidMachineBlockEntity.this.redstoneMode = RedstoneMode.fromIndex(value);
                        break;
                    }
                    case 8: {
                        SimpleRecipeFluidMachineBlockEntity.this.comparatorMode = ComparatorMode.fromIndex(value);
                    }
                }
            }

            public int m_6499_() {
                return 9;
            }
        };
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        this.syncEnergyToPlayer(player);
        this.syncFluidToPlayer(player);
        return this.menuProvider.createMenu(id, inventory, this, this.upgradeModuleInventory, this.data);
    }

    protected Optional<R> getRecipeFor(Container inventory) {
        return this.f_58857_.m_7465_().m_44015_(this.recipeType, inventory, this.f_58857_);
    }

    @Override
    protected final Optional<R> getCurrentWorkData() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        return this.getRecipeFor((Container)inventory);
    }

    @Override
    protected final double getWorkDataDependentWorkDuration(R workData) {
        return this.getRecipeDependentRecipeDuration(workData);
    }

    protected double getRecipeDependentRecipeDuration(R recipe) {
        return 1.0;
    }

    @Override
    protected final double getWorkDataDependentEnergyConsumption(R workData) {
        return this.getRecipeDependentEnergyConsumption(workData);
    }

    protected double getRecipeDependentEnergyConsumption(R recipe) {
        return 1.0;
    }

    @Override
    protected final boolean hasWork() {
        return this.hasRecipe();
    }

    protected boolean hasRecipe() {
        if (this.f_58857_ == null) {
            return false;
        }
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Optional<R> recipe = this.getRecipeFor((Container)inventory);
        return recipe.isPresent() && this.canCraftRecipe(inventory, (Recipe)recipe.get());
    }

    @Override
    protected final void onWorkStarted(R workData) {
        this.onStartCrafting(workData);
    }

    protected void onStartCrafting(R recipe) {
    }

    @Override
    protected final void onWorkCompleted(R workData) {
        this.craftItem(workData);
    }

    protected abstract void craftItem(R var1);

    protected abstract boolean canCraftRecipe(SimpleContainer var1, R var2);
}

