/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity.base;

import me.jddev0.ep.block.entity.base.FluidStorageMethods;
import me.jddev0.ep.block.entity.base.UpgradableFluidEnergyStorageBlockEntity;
import me.jddev0.ep.energy.IEnergizedPowerEnergyStorage;
import me.jddev0.ep.machine.configuration.ComparatorMode;
import me.jddev0.ep.machine.configuration.ComparatorModeUpdate;
import me.jddev0.ep.machine.configuration.RedstoneMode;
import me.jddev0.ep.machine.configuration.RedstoneModeUpdate;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.util.EnergyUtils;
import me.jddev0.ep.util.FluidUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public abstract class ConfigurableUpgradableFluidEnergyStorageBlockEntity<E extends IEnergizedPowerEnergyStorage, F extends IFluidHandler>
extends UpgradableFluidEnergyStorageBlockEntity<E, F>
implements RedstoneModeUpdate,
ComparatorModeUpdate {
    @NotNull
    protected RedstoneMode redstoneMode = RedstoneMode.IGNORE;
    @NotNull
    protected ComparatorMode comparatorMode = ComparatorMode.FLUID;

    public ConfigurableUpgradableFluidEnergyStorageBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState, String machineName, int baseEnergyCapacity, int baseEnergyTransferRate, FluidStorageMethods<F> fluidStorageMethods, int baseTankCapacity, UpgradeModuleModifier ... upgradeModifierSlots) {
        super(type, blockPos, blockState, machineName, baseEnergyCapacity, baseEnergyTransferRate, fluidStorageMethods, baseTankCapacity, upgradeModifierSlots);
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("configuration.redstone_mode", this.redstoneMode.ordinal());
        nbt.m_128405_("configuration.comparator_mode", this.comparatorMode.ordinal());
    }

    @Override
    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.redstoneMode = RedstoneMode.fromIndex(nbt.m_128451_("configuration.redstone_mode"));
        this.comparatorMode = nbt.m_128441_("configuration.comparator_mode") ? ComparatorMode.fromIndex(nbt.m_128451_("configuration.comparator_mode")) : ComparatorMode.FLUID;
    }

    public int getRedstoneOutput() {
        return switch (this.comparatorMode) {
            default -> throw new IncompatibleClassChangeError();
            case ComparatorMode.ITEM -> 0;
            case ComparatorMode.FLUID -> FluidUtils.getRedstoneSignalFromFluidHandler(this.fluidStorage);
            case ComparatorMode.ENERGY -> EnergyUtils.getRedstoneSignalFromEnergyStorage(this.energyStorage);
        };
    }

    @Override
    public void setNextRedstoneMode() {
        this.redstoneMode = RedstoneMode.fromIndex(this.redstoneMode.ordinal() + 1);
        this.m_6596_();
    }

    @Override
    public void setNextComparatorMode() {
        do {
            this.comparatorMode = ComparatorMode.fromIndex(this.comparatorMode.ordinal() + 1);
        } while (this.comparatorMode == ComparatorMode.ITEM);
        this.m_6596_();
    }
}

