/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import me.jddev0.ep.block.ThermalGeneratorBlock;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.block.entity.base.ConfigurableUpgradableFluidEnergyStorageBlockEntity;
import me.jddev0.ep.block.entity.base.FluidStorageSingleTankMethods;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.ExtractOnlyEnergyStorage;
import me.jddev0.ep.machine.configuration.ComparatorMode;
import me.jddev0.ep.machine.configuration.RedstoneMode;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.recipe.ThermalGeneratorRecipe;
import me.jddev0.ep.screen.ThermalGeneratorMenu;
import me.jddev0.ep.util.ByteUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThermalGeneratorBlockEntity
extends ConfigurableUpgradableFluidEnergyStorageBlockEntity<ExtractOnlyEnergyStorage, FluidTank> {
    public static final float ENERGY_PRODUCTION_MULTIPLIER = ModConfigs.COMMON_THERMAL_GENERATOR_ENERGY_PRODUCTION_MULTIPLIER.getValue().floatValue();

    public ThermalGeneratorBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.THERMAL_GENERATOR_ENTITY.get(), blockPos, blockState, "thermal_generator", ModConfigs.COMMON_THERMAL_GENERATOR_CAPACITY.getValue(), ModConfigs.COMMON_THERMAL_GENERATOR_TRANSFER_RATE.getValue(), FluidStorageSingleTankMethods.INSTANCE, ModConfigs.COMMON_THERMAL_GENERATOR_FLUID_TANK_CAPACITY.getValue() * 1000, UpgradeModuleModifier.ENERGY_CAPACITY);
    }

    @Override
    protected ExtractOnlyEnergyStorage initEnergyStorage() {
        return new ExtractOnlyEnergyStorage(0, this.baseEnergyCapacity, this.baseEnergyTransferRate){

            @Override
            public int getCapacity() {
                return Math.max(1, (int)Math.ceil((double)this.capacity * ThermalGeneratorBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CAPACITY)));
            }

            @Override
            public int getMaxExtract() {
                return Math.max(1, (int)Math.ceil((double)this.maxExtract * ThermalGeneratorBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_TRANSFER_RATE)));
            }

            @Override
            protected void onChange() {
                ThermalGeneratorBlockEntity.this.m_6596_();
                ThermalGeneratorBlockEntity.this.syncEnergyToPlayers(32);
            }
        };
    }

    @Override
    protected FluidTank initFluidStorage() {
        return new FluidTank(this.baseTankCapacity){

            protected void onContentsChanged() {
                ThermalGeneratorBlockEntity.this.m_6596_();
                ThermalGeneratorBlockEntity.this.syncFluidToPlayers(32);
            }

            public boolean isFluidValid(FluidStack stack) {
                if (!super.isFluidValid(stack) || ThermalGeneratorBlockEntity.this.f_58857_ == null) {
                    return false;
                }
                List recipes = ThermalGeneratorBlockEntity.this.f_58857_.m_7465_().m_44013_((RecipeType)ThermalGeneratorRecipe.Type.INSTANCE);
                return recipes.stream().map(ThermalGeneratorRecipe::getInput).anyMatch(inputs -> Arrays.stream(inputs).anyMatch(input -> stack.getFluid() == input));
            }
        };
    }

    @Override
    protected ContainerData initContainerData() {
        return new ContainerData(){

            public int m_6413_(int index) {
                if (index == 2) {
                    return ThermalGeneratorBlockEntity.this.redstoneMode.ordinal();
                }
                if (index == 3) {
                    return ThermalGeneratorBlockEntity.this.comparatorMode.ordinal();
                }
                if (ThermalGeneratorBlockEntity.this.f_58857_ == null || index > 1) {
                    return 0;
                }
                List recipes = ThermalGeneratorBlockEntity.this.f_58857_.m_7465_().m_44013_((RecipeType)ThermalGeneratorRecipe.Type.INSTANCE);
                int rawProduction = 0;
                block3: for (ThermalGeneratorRecipe recipe : recipes) {
                    for (Fluid fluid : recipe.getInput()) {
                        if (((FluidTank)ThermalGeneratorBlockEntity.this.fluidStorage).getFluid().getFluid() != fluid) continue;
                        rawProduction = recipe.getEnergyProduction();
                        rawProduction = (int)((float)rawProduction * ENERGY_PRODUCTION_MULTIPLIER);
                        break block3;
                    }
                }
                int productionLeft = (int)((float)(rawProduction * ((FluidTank)ThermalGeneratorBlockEntity.this.fluidStorage).getFluidAmount()) / 1000.0f);
                return switch (index) {
                    case 0, 1 -> ByteUtils.get2Bytes(productionLeft, index);
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: 
                    case 1: {
                        break;
                    }
                    case 2: {
                        ThermalGeneratorBlockEntity.this.redstoneMode = RedstoneMode.fromIndex(value);
                        break;
                    }
                    case 3: {
                        ThermalGeneratorBlockEntity.this.comparatorMode = ComparatorMode.fromIndex(value);
                    }
                }
            }

            public int m_6499_() {
                return 4;
            }
        };
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        this.syncEnergyToPlayer(player);
        this.syncFluidToPlayer(player);
        return new ThermalGeneratorMenu(id, inventory, this, this.upgradeModuleInventory, this.data);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyStorage.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.lazyFluidStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, ThermalGeneratorBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        if (blockEntity.redstoneMode.isActive((Boolean)state.m_61143_((Property)ThermalGeneratorBlock.POWERED))) {
            ThermalGeneratorBlockEntity.tickRecipe(level, blockPos, state, blockEntity);
        }
        ThermalGeneratorBlockEntity.transferEnergy(level, blockPos, state, blockEntity);
    }

    private static void tickRecipe(Level level, BlockPos blockPos, BlockState state, ThermalGeneratorBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        List recipes = level.m_7465_().m_44013_((RecipeType)ThermalGeneratorRecipe.Type.INSTANCE);
        int rawProduction = 0;
        block0: for (ThermalGeneratorRecipe recipe : recipes) {
            for (Fluid fluid : recipe.getInput()) {
                if (((FluidTank)blockEntity.fluidStorage).getFluid().getFluid() != fluid) continue;
                rawProduction = recipe.getEnergyProduction();
                rawProduction = (int)((float)rawProduction * ENERGY_PRODUCTION_MULTIPLIER);
                break block0;
            }
        }
        if (rawProduction > 0 && ((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getEnergy() < ((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getCapacity()) {
            int production = (int)((float)rawProduction * ((float)Math.min(((FluidTank)blockEntity.fluidStorage).getFluidAmount(), 50) / 1000.0f));
            production = Math.min(production, ((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getCapacity() - ((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getEnergy());
            int fluidAmount = (int)((float)production / (float)rawProduction * 1000.0f);
            production = (int)((float)(rawProduction * fluidAmount) / 1000.0f);
            ((FluidTank)blockEntity.fluidStorage).drain(fluidAmount, IFluidHandler.FluidAction.EXECUTE);
            ((ExtractOnlyEnergyStorage)blockEntity.energyStorage).setEnergy(Math.min(((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getCapacity(), ((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getEnergy() + production));
        }
    }

    private static void transferEnergy(Level level, BlockPos blockPos, BlockState state, ThermalGeneratorBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        LinkedList<IEnergyStorage> consumerItems = new LinkedList<IEnergyStorage>();
        LinkedList<Integer> consumerEnergyValues = new LinkedList<Integer>();
        int consumptionSum = 0;
        for (Direction direction : Direction.values()) {
            int received;
            IEnergyStorage energyStorage;
            LazyOptional energyStorageLazyOptional;
            BlockPos testPos = blockPos.m_121945_(direction);
            BlockEntity testBlockEntity = level.m_7702_(testPos);
            if (testBlockEntity == null || !(energyStorageLazyOptional = testBlockEntity.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_())).isPresent() || !(energyStorage = (IEnergyStorage)energyStorageLazyOptional.orElse(null)).canReceive() || (received = energyStorage.receiveEnergy(Math.min(((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getMaxExtract(), ((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getEnergy()), true)) <= 0) continue;
            consumptionSum += received;
            consumerItems.add(energyStorage);
            consumerEnergyValues.add(received);
        }
        LinkedList<Integer> consumerEnergyDistributed = new LinkedList<Integer>();
        for (int i = 0; i < consumerItems.size(); ++i) {
            consumerEnergyDistributed.add(0);
        }
        int consumptionLeft = Math.min(((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getMaxExtract(), Math.min(((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getEnergy(), consumptionSum));
        ((ExtractOnlyEnergyStorage)blockEntity.energyStorage).extractEnergy(consumptionLeft, false);
        int divisor = consumerItems.size();
        block2: while (consumptionLeft > 0) {
            int consumptionPerConsumer = consumptionLeft / divisor;
            if (consumptionPerConsumer == 0) {
                divisor = Math.max(1, divisor - 1);
                consumptionPerConsumer = consumptionLeft / divisor;
            }
            for (int i = 0; i < consumerEnergyValues.size(); ++i) {
                int consumptionDistributed = (Integer)consumerEnergyDistributed.get(i);
                int consumptionOfConsumerLeft = (Integer)consumerEnergyValues.get(i) - consumptionDistributed;
                int consumptionDistributedNew = Math.min(consumptionOfConsumerLeft, Math.min(consumptionPerConsumer, consumptionLeft));
                consumerEnergyDistributed.set(i, consumptionDistributed + consumptionDistributedNew);
                if ((consumptionLeft -= consumptionDistributedNew) == 0) break block2;
            }
        }
        for (int i = 0; i < consumerItems.size(); ++i) {
            int energy = (Integer)consumerEnergyDistributed.get(i);
            if (energy <= 0) continue;
            ((IEnergyStorage)consumerItems.get(i)).receiveEnergy(energy, false);
        }
    }
}

