/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.block.entity.base.FluidStorageMultiTankMethods;
import me.jddev0.ep.block.entity.base.SelectableRecipeFluidMachineBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.fluid.EnergizedPowerFluidStorage;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.recipe.ModRecipes;
import me.jddev0.ep.recipe.StoneSolidifierRecipe;
import me.jddev0.ep.screen.StoneSolidifierMenu;
import me.jddev0.ep.util.InventoryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StoneSolidifierBlockEntity
extends SelectableRecipeFluidMachineBlockEntity<EnergizedPowerFluidStorage, StoneSolidifierRecipe> {
    public static final int TANK_CAPACITY = 1000 * ModConfigs.COMMON_STONE_SOLIDIFIER_TANK_CAPACITY.getValue();
    private final LazyOptional<IItemHandler> lazyItemHandlerSided = LazyOptional.of(() -> new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> false, i -> i == 0));

    public StoneSolidifierBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.STONE_SOLIDIFIER_ENTITY.get(), blockPos, blockState, "stone_solidifier", StoneSolidifierMenu::new, 1, (RecipeType)ModRecipes.STONE_SOLIDIFIER_TYPE.get(), (RecipeSerializer)ModRecipes.STONE_SOLIDIFIER_SERIALIZER.get(), (int)ModConfigs.COMMON_STONE_SOLIDIFIER_RECIPE_DURATION.getValue(), ModConfigs.COMMON_STONE_SOLIDIFIER_CAPACITY.getValue(), (int)ModConfigs.COMMON_STONE_SOLIDIFIER_TRANSFER_RATE.getValue(), ModConfigs.COMMON_STONE_SOLIDIFIER_CONSUMPTION_PER_TICK.getValue(), FluidStorageMultiTankMethods.INSTANCE, TANK_CAPACITY, UpgradeModuleModifier.SPEED, UpgradeModuleModifier.ENERGY_CONSUMPTION, UpgradeModuleModifier.ENERGY_CAPACITY);
    }

    @Override
    protected ItemStackHandler initInventoryStorage() {
        return new ItemStackHandler(this.slotCount){

            protected void onContentsChanged(int slot) {
                StoneSolidifierBlockEntity.this.m_6596_();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return switch (slot) {
                    case 0 -> false;
                    default -> super.isItemValid(slot, stack);
                };
            }
        };
    }

    @Override
    protected EnergizedPowerFluidStorage initFluidStorage() {
        return new EnergizedPowerFluidStorage(new int[]{this.baseTankCapacity, this.baseTankCapacity}){

            @Override
            protected void onContentsChanged() {
                StoneSolidifierBlockEntity.this.m_6596_();
                StoneSolidifierBlockEntity.this.syncFluidToPlayers(32);
            }

            @Override
            public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
                if (!super.isFluidValid(tank, stack)) {
                    return false;
                }
                return switch (tank) {
                    case 0 -> stack.isFluidEqual(new FluidStack((Fluid)Fluids.f_76193_, 1));
                    case 1 -> stack.isFluidEqual(new FluidStack((Fluid)Fluids.f_76195_, 1));
                    default -> false;
                };
            }
        };
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            return this.lazyItemHandlerSided.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.lazyFluidStorage.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    protected void craftItem(StoneSolidifierRecipe recipe) {
        if (this.f_58857_ == null || !this.hasRecipe()) {
            return;
        }
        ((EnergizedPowerFluidStorage)this.fluidStorage).drain(new FluidStack((Fluid)Fluids.f_76193_, recipe.getWaterAmount()), IFluidHandler.FluidAction.EXECUTE);
        ((EnergizedPowerFluidStorage)this.fluidStorage).drain(new FluidStack((Fluid)Fluids.f_76195_, recipe.getLavaAmount()), IFluidHandler.FluidAction.EXECUTE);
        this.itemHandler.setStackInSlot(0, recipe.m_8043_(this.f_58857_.m_9598_()).m_255036_(this.itemHandler.getStackInSlot(0).m_41613_() + recipe.m_8043_(this.f_58857_.m_9598_()).m_41613_()));
        this.resetProgress();
    }

    @Override
    protected boolean canCraftRecipe(SimpleContainer inventory, StoneSolidifierRecipe recipe) {
        return this.f_58857_ != null && ((EnergizedPowerFluidStorage)this.fluidStorage).getFluid(0).getAmount() >= recipe.getWaterAmount() && ((EnergizedPowerFluidStorage)this.fluidStorage).getFluid(1).getAmount() >= recipe.getLavaAmount() && InventoryUtils.canInsertItemIntoSlot((Container)inventory, 0, recipe.m_8043_(this.f_58857_.m_9598_()));
    }
}

