/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.block.entity.base.MenuInventoryStorageBlockEntity;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.SyncPressMoldMakerRecipeListS2CPacket;
import me.jddev0.ep.recipe.PressMoldMakerRecipe;
import me.jddev0.ep.screen.PressMoldMakerMenu;
import me.jddev0.ep.util.InventoryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PressMoldMakerBlockEntity
extends MenuInventoryStorageBlockEntity<ItemStackHandler> {
    private List<Pair<PressMoldMakerRecipe, Boolean>> recipeList = new ArrayList<Pair<PressMoldMakerRecipe, Boolean>>();
    private final LazyOptional<IItemHandler> lazyItemHandlerSided = LazyOptional.of(() -> new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 0, i -> i == 1));

    public PressMoldMakerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.PRESS_MOLD_MAKER_ENTITY.get(), blockPos, blockState, "press_mold_maker", 2);
    }

    @Override
    protected ItemStackHandler initInventoryStorage() {
        return new ItemStackHandler(this.slotCount){

            protected void onContentsChanged(int slot) {
                PressMoldMakerBlockEntity.this.m_6596_();
                if (slot == 0 && PressMoldMakerBlockEntity.this.f_58857_ != null && !PressMoldMakerBlockEntity.this.f_58857_.m_5776_()) {
                    List<Pair<PressMoldMakerRecipe, Boolean>> recipeList = PressMoldMakerBlockEntity.this.createRecipeList();
                    ModMessages.sendToPlayersWithinXBlocks(new SyncPressMoldMakerRecipeListS2CPacket(PressMoldMakerBlockEntity.this.m_58899_(), recipeList), PressMoldMakerBlockEntity.this.m_58899_(), (ResourceKey<Level>)PressMoldMakerBlockEntity.this.f_58857_.m_46472_(), 32);
                }
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return switch (slot) {
                    case 0 -> {
                        if (PressMoldMakerBlockEntity.this.f_58857_ == null || stack.m_150930_(Items.f_42461_)) {
                            yield true;
                        }
                        yield false;
                    }
                    case 1 -> false;
                    default -> super.isItemValid(slot, stack);
                };
            }
        };
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        List<Pair<PressMoldMakerRecipe, Boolean>> recipeList = this.createRecipeList();
        ModMessages.sendToPlayer(new SyncPressMoldMakerRecipeListS2CPacket(this.m_58899_(), recipeList), (ServerPlayer)player);
        return new PressMoldMakerMenu(id, inventory, this);
    }

    public int getRedstoneOutput() {
        return InventoryUtils.getRedstoneSignalFromItemStackHandler(this.itemHandler);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            return this.lazyItemHandlerSided.cast();
        }
        return super.getCapability(cap, side);
    }

    public void craftItem(ResourceLocation recipeId) {
        Recipe recipe;
        Optional<Recipe> recipe2 = this.f_58857_.m_7465_().m_44051_().stream().filter(recipeHolder -> recipeHolder.m_6423_().equals((Object)recipeId)).findFirst();
        if (recipe2.isEmpty() || !((recipe = recipe2.get()) instanceof PressMoldMakerRecipe)) {
            return;
        }
        PressMoldMakerRecipe pressMoldMakerRecipe = (PressMoldMakerRecipe)recipe;
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        if (!pressMoldMakerRecipe.m_5818_((Container)inventory, this.f_58857_) || !InventoryUtils.canInsertItemIntoSlot((Container)inventory, 1, pressMoldMakerRecipe.m_8043_(this.f_58857_.m_9598_()))) {
            return;
        }
        this.itemHandler.extractItem(0, pressMoldMakerRecipe.getClayCount(), false);
        this.itemHandler.setStackInSlot(1, pressMoldMakerRecipe.m_8043_(this.f_58857_.m_9598_()).m_255036_(this.itemHandler.getStackInSlot(1).m_41613_() + pressMoldMakerRecipe.m_8043_(this.f_58857_.m_9598_()).m_41613_()));
    }

    private List<Pair<PressMoldMakerRecipe, Boolean>> createRecipeList() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        List recipes = this.f_58857_.m_7465_().m_44013_((RecipeType)PressMoldMakerRecipe.Type.INSTANCE);
        return recipes.stream().sorted(Comparator.comparing(recipe -> recipe.m_8043_(this.f_58857_.m_9598_()).m_41778_())).map(recipe -> Pair.of((Object)recipe, (Object)recipe.m_5818_((Container)inventory, this.f_58857_))).collect(Collectors.toList());
    }

    public List<Pair<PressMoldMakerRecipe, Boolean>> getRecipeList() {
        return this.recipeList;
    }

    public void setRecipeList(List<Pair<PressMoldMakerRecipe, Boolean>> recipeList) {
        this.recipeList = recipeList;
    }
}

