/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.PoweredLampBlock;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.block.entity.base.EnergyStorageBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.ReceiveOnlyEnergyStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PoweredLampBlockEntity
extends EnergyStorageBlockEntity<ReceiveOnlyEnergyStorage> {
    public static final int MAX_RECEIVE = ModConfigs.COMMON_POWERED_LAMP_TRANSFER_RATE.getValue();

    public PoweredLampBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.POWERED_LAMP_ENTITY.get(), blockPos, blockState, MAX_RECEIVE, MAX_RECEIVE);
    }

    @Override
    protected ReceiveOnlyEnergyStorage initEnergyStorage() {
        return new ReceiveOnlyEnergyStorage(0, this.baseEnergyCapacity, this.baseEnergyTransferRate){

            @Override
            protected void onChange() {
                PoweredLampBlockEntity.this.m_6596_();
                PoweredLampBlockEntity.this.syncEnergyToPlayers(32);
            }
        };
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, PoweredLampBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        boolean isEmptyFlag = ((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy() == 0;
        int levelValue = Math.min(Mth.m_14143_((float)((float)((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy() / (float)((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getCapacity() * 14.0f)) + (isEmptyFlag ? 0 : 1), 15);
        if ((Integer)state.m_61143_((Property)PoweredLampBlock.LEVEL) != levelValue) {
            level.m_7731_(blockPos, (BlockState)state.m_61124_((Property)PoweredLampBlock.LEVEL, (Comparable)Integer.valueOf(levelValue)), 3);
        }
        ((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).setEnergy(0);
    }
}

