/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.block.entity.base.SimpleRecipeMachineBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.recipe.ModRecipes;
import me.jddev0.ep.recipe.PlantGrowthChamberFertilizerRecipe;
import me.jddev0.ep.recipe.PlantGrowthChamberRecipe;
import me.jddev0.ep.screen.PlantGrowthChamberMenu;
import me.jddev0.ep.util.RecipeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlantGrowthChamberBlockEntity
extends SimpleRecipeMachineBlockEntity<PlantGrowthChamberRecipe> {
    public static final float RECIPE_DURATION_MULTIPLIER = ModConfigs.COMMON_PLANT_GROWTH_CHAMBER_RECIPE_DURATION_MULTIPLIER.getValue().floatValue();
    private final LazyOptional<IItemHandler> lazyItemHandlerSidesSided = LazyOptional.of(() -> new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 0, i -> i > 1 && i < 6));
    private final LazyOptional<IItemHandler> lazyItemHandlerTopBottomSided = LazyOptional.of(() -> new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 1, i -> i > 1 && i < 6));
    private double fertilizerSpeedMultiplier = 1.0;
    private double fertilizerEnergyConsumptionMultiplier = 1.0;

    public PlantGrowthChamberBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.PLANT_GROWTH_CHAMBER_ENTITY.get(), blockPos, blockState, "plant_growth_chamber", PlantGrowthChamberMenu::new, 6, (RecipeType)ModRecipes.PLANT_GROWTH_CHAMBER_TYPE.get(), 1, (int)ModConfigs.COMMON_PLANT_GROWTH_CHAMBER_CAPACITY.getValue(), ModConfigs.COMMON_PLANT_GROWTH_CHAMBER_TRANSFER_RATE.getValue(), ModConfigs.COMMON_PLANT_GROWTH_CHAMBER_ENERGY_CONSUMPTION_PER_TICK.getValue(), UpgradeModuleModifier.SPEED, UpgradeModuleModifier.ENERGY_CONSUMPTION, UpgradeModuleModifier.ENERGY_CAPACITY);
    }

    @Override
    protected ItemStackHandler initInventoryStorage() {
        return new ItemStackHandler(this.slotCount){

            protected void onContentsChanged(int slot) {
                PlantGrowthChamberBlockEntity.this.m_6596_();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return switch (slot) {
                    case 0 -> {
                        if (PlantGrowthChamberBlockEntity.this.f_58857_ == null || RecipeUtils.isIngredientOfAny(PlantGrowthChamberBlockEntity.this.f_58857_, PlantGrowthChamberRecipe.Type.INSTANCE, stack)) {
                            yield true;
                        }
                        yield false;
                    }
                    case 1 -> {
                        if (PlantGrowthChamberBlockEntity.this.f_58857_ == null || RecipeUtils.isIngredientOfAny(PlantGrowthChamberBlockEntity.this.f_58857_, PlantGrowthChamberFertilizerRecipe.Type.INSTANCE, stack)) {
                            yield true;
                        }
                        yield false;
                    }
                    case 2, 3, 4, 5 -> false;
                    default -> super.isItemValid(slot, stack);
                };
            }

            public void setStackInSlot(int slot, @NotNull ItemStack stack) {
                if (slot == 0) {
                    ItemStack itemStack = this.getStackInSlot(slot);
                    if (!(PlantGrowthChamberBlockEntity.this.f_58857_ == null || stack.m_41619_() || itemStack.m_41619_() || ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemStack))) {
                        PlantGrowthChamberBlockEntity.this.resetProgress();
                    }
                }
                super.setStackInSlot(slot, stack);
            }
        };
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            if (side == Direction.UP || side == Direction.DOWN) {
                return this.lazyItemHandlerTopBottomSided.cast();
            }
            return this.lazyItemHandlerSidesSided.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128365_("recipe.speed_multiplier", (Tag)DoubleTag.m_128500_((double)this.fertilizerSpeedMultiplier));
        nbt.m_128365_("recipe.energy_consumption_multiplier", (Tag)DoubleTag.m_128500_((double)this.fertilizerEnergyConsumptionMultiplier));
    }

    @Override
    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.fertilizerSpeedMultiplier = nbt.m_128459_("recipe.speed_multiplier");
        this.fertilizerEnergyConsumptionMultiplier = nbt.m_128459_("recipe.energy_consumption_multiplier");
    }

    @Override
    protected double getRecipeDependentRecipeDuration(PlantGrowthChamberRecipe recipe) {
        return (double)((float)recipe.getTicks() * RECIPE_DURATION_MULTIPLIER) / this.fertilizerSpeedMultiplier;
    }

    @Override
    protected double getRecipeDependentEnergyConsumption(PlantGrowthChamberRecipe recipe) {
        return this.fertilizerEnergyConsumptionMultiplier;
    }

    @Override
    protected void resetProgress() {
        super.resetProgress();
        this.fertilizerSpeedMultiplier = 1.0;
        this.fertilizerEnergyConsumptionMultiplier = 1.0;
    }

    @Override
    protected void onStartCrafting(PlantGrowthChamberRecipe recipe) {
        if (this.f_58857_ == null) {
            return;
        }
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Optional fertilizerRecipe = this.f_58857_.m_7465_().m_44015_((RecipeType)PlantGrowthChamberFertilizerRecipe.Type.INSTANCE, (Container)inventory, this.f_58857_);
        if (fertilizerRecipe.isPresent()) {
            this.fertilizerSpeedMultiplier = ((PlantGrowthChamberFertilizerRecipe)fertilizerRecipe.get()).getSpeedMultiplier();
            this.fertilizerEnergyConsumptionMultiplier = ((PlantGrowthChamberFertilizerRecipe)fertilizerRecipe.get()).getEnergyConsumptionMultiplier();
            this.itemHandler.extractItem(1, 1, false);
        }
    }

    @Override
    protected void craftItem(PlantGrowthChamberRecipe recipe) {
        if (this.f_58857_ == null || !this.hasRecipe()) {
            return;
        }
        this.itemHandler.extractItem(0, 1, false);
        ArrayList<ItemStack> itemStacksInsert = new ArrayList<ItemStack>(Arrays.asList(recipe.generateOutputs(this.f_58857_.f_46441_)));
        ArrayList<Integer> emptyIndices = new ArrayList<Integer>(4);
        block0: for (ItemStack itemStack : itemStacksInsert) {
            if (itemStack.m_41619_()) continue;
            for (int i = 2; i < this.itemHandler.getSlots(); ++i) {
                int amount;
                ItemStack testItemStack = this.itemHandler.getStackInSlot(i);
                if (emptyIndices.contains(i)) continue;
                if (testItemStack.m_41619_()) {
                    emptyIndices.add(i);
                    continue;
                }
                if (!ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)testItemStack) || (amount = Math.min(itemStack.m_41613_(), testItemStack.m_41741_() - testItemStack.m_41613_())) <= 0) continue;
                this.itemHandler.setStackInSlot(i, this.itemHandler.getStackInSlot(i).m_255036_(testItemStack.m_41613_() + amount));
                itemStack.m_41764_(itemStack.m_41613_() - amount);
                if (itemStack.m_41619_()) continue block0;
            }
            if (emptyIndices.isEmpty()) continue;
            this.itemHandler.setStackInSlot(((Integer)emptyIndices.remove(0)).intValue(), itemStack);
        }
        this.resetProgress();
    }

    @Override
    protected boolean canCraftRecipe(SimpleContainer inventory, PlantGrowthChamberRecipe recipe) {
        return this.f_58857_ != null && PlantGrowthChamberBlockEntity.canInsertItemsIntoOutputSlots(inventory, new ArrayList<ItemStack>(Arrays.asList(recipe.getMaxOutputCounts())));
    }

    private static boolean canInsertItemsIntoOutputSlots(SimpleContainer inventory, List<ItemStack> itemsStacks) {
        ArrayList<Integer> checkedIndices = new ArrayList<Integer>(4);
        ArrayList<Integer> emptyIndices = new ArrayList<Integer>(4);
        block0: for (int i = Math.min(4, itemsStacks.size()) - 1; i >= 0; --i) {
            ItemStack itemStack = itemsStacks.get(i);
            for (int j = 2; j < inventory.m_6643_(); ++j) {
                if (checkedIndices.contains(j) || emptyIndices.contains(j)) continue;
                ItemStack testItemStack = inventory.m_8020_(j);
                if (testItemStack.m_41619_()) {
                    emptyIndices.add(j);
                    continue;
                }
                if (!ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)testItemStack)) continue;
                int amount = Math.min(itemStack.m_41613_(), testItemStack.m_41741_() - testItemStack.m_41613_());
                if (amount + testItemStack.m_41613_() == testItemStack.m_41741_()) {
                    checkedIndices.add(j);
                }
                if (amount == itemStack.m_41613_()) {
                    itemsStacks.remove(i);
                    continue block0;
                }
                itemStack.m_41774_(amount);
            }
            if (emptyIndices.isEmpty()) {
                return false;
            }
            int index = (Integer)emptyIndices.remove(0);
            if (itemStack.m_41613_() == itemStack.m_41741_()) {
                checkedIndices.add(index);
            }
            itemsStacks.remove(i);
        }
        return itemsStacks.isEmpty();
    }
}

