/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.block.entity.base.SimpleRecipeMachineBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.recipe.MetalPressRecipe;
import me.jddev0.ep.recipe.ModRecipes;
import me.jddev0.ep.registry.tags.EnergizedPowerItemTags;
import me.jddev0.ep.screen.MetalPressMenu;
import me.jddev0.ep.util.InventoryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetalPressBlockEntity
extends SimpleRecipeMachineBlockEntity<MetalPressRecipe> {
    private final LazyOptional<IItemHandler> lazyItemHandlerTopSided = LazyOptional.of(() -> new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 1, i -> i == 1));
    private final LazyOptional<IItemHandler> lazyItemHandlerOthersSided = LazyOptional.of(() -> new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 0, i -> i == 2));

    public MetalPressBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.METAL_PRESS_ENTITY.get(), blockPos, blockState, "metal_press", MetalPressMenu::new, 3, (RecipeType)ModRecipes.METAL_PRESS_TYPE.get(), (int)ModConfigs.COMMON_METAL_PRESS_RECIPE_DURATION.getValue(), (int)ModConfigs.COMMON_METAL_PRESS_CAPACITY.getValue(), ModConfigs.COMMON_METAL_PRESS_TRANSFER_RATE.getValue(), ModConfigs.COMMON_METAL_PRESS_ENERGY_CONSUMPTION_PER_TICK.getValue(), UpgradeModuleModifier.SPEED, UpgradeModuleModifier.ENERGY_CONSUMPTION, UpgradeModuleModifier.ENERGY_CAPACITY);
    }

    @Override
    protected ItemStackHandler initInventoryStorage() {
        return new ItemStackHandler(this.slotCount){

            protected void onContentsChanged(int slot) {
                MetalPressBlockEntity.this.m_6596_();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return switch (slot) {
                    case 0 -> {
                        if (MetalPressBlockEntity.this.f_58857_ == null || MetalPressBlockEntity.this.f_58857_.m_7465_().m_44013_((RecipeType)MetalPressRecipe.Type.INSTANCE).stream().map(MetalPressRecipe::getInput).anyMatch(ingredient -> ingredient.test(stack))) {
                            yield true;
                        }
                        yield false;
                    }
                    case 1 -> {
                        if (MetalPressBlockEntity.this.f_58857_ == null || stack.m_204117_(EnergizedPowerItemTags.METAL_PRESS_MOLDS)) {
                            yield true;
                        }
                        yield false;
                    }
                    case 2 -> false;
                    default -> super.isItemValid(slot, stack);
                };
            }

            public void setStackInSlot(int slot, @NotNull ItemStack stack) {
                if (slot == 0 || slot == 1) {
                    ItemStack itemStack = this.getStackInSlot(slot);
                    if (!(MetalPressBlockEntity.this.f_58857_ == null || stack.m_41619_() || itemStack.m_41619_() || ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemStack))) {
                        MetalPressBlockEntity.this.resetProgress();
                    }
                }
                super.setStackInSlot(slot, stack);
            }

            public int getSlotLimit(int slot) {
                if (slot == 1) {
                    return 1;
                }
                return super.getSlotLimit(slot);
            }
        };
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            if (side == Direction.UP) {
                return this.lazyItemHandlerTopSided.cast();
            }
            return this.lazyItemHandlerOthersSided.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    protected void craftItem(MetalPressRecipe recipe) {
        if (this.f_58857_ == null || !this.hasRecipe()) {
            return;
        }
        ItemStack pressMold = this.itemHandler.getStackInSlot(1).m_41777_();
        if (pressMold.m_41619_() && !pressMold.m_204117_(EnergizedPowerItemTags.METAL_PRESS_MOLDS)) {
            return;
        }
        if (pressMold.m_220157_(1, this.f_58857_.f_46441_, null)) {
            this.itemHandler.setStackInSlot(1, ItemStack.f_41583_);
        } else {
            this.itemHandler.setStackInSlot(1, pressMold);
        }
        this.itemHandler.extractItem(0, recipe.getInputCount(), false);
        this.itemHandler.setStackInSlot(2, recipe.m_8043_(this.f_58857_.m_9598_()).m_255036_(this.itemHandler.getStackInSlot(2).m_41613_() + recipe.m_8043_(this.f_58857_.m_9598_()).m_41613_()));
        this.resetProgress();
    }

    @Override
    protected boolean canCraftRecipe(SimpleContainer inventory, MetalPressRecipe recipe) {
        return this.f_58857_ != null && InventoryUtils.canInsertItemIntoSlot((Container)inventory, 2, recipe.m_8043_(this.f_58857_.m_9598_()));
    }
}

