/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.ItemConveyorBeltLoaderBlock;
import me.jddev0.ep.block.ModBlocks;
import me.jddev0.ep.block.entity.ItemConveyorBeltBlockEntity;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.block.entity.base.MenuInventoryStorageBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.screen.ItemConveyorBeltLoaderMenu;
import me.jddev0.ep.util.InventoryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemConveyorBeltLoaderBlockEntity
extends MenuInventoryStorageBlockEntity<ItemStackHandler> {
    private static final int TICKS_PER_ITEM = ModConfigs.COMMON_ITEM_CONVEYOR_BELT_LOADER_TICKS_PER_ITEM.getValue();
    private final LazyOptional<IItemHandler> lazyItemHandlerSided = LazyOptional.of(() -> new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 0, i -> i == 0));

    public ItemConveyorBeltLoaderBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.ITEM_CONVEYOR_BELT_LOADER_ENTITY.get(), blockPos, blockState, "item_conveyor_belt_loader", 1);
    }

    @Override
    protected ItemStackHandler initInventoryStorage() {
        return new ItemStackHandler(this.slotCount){

            protected void onContentsChanged(int slot) {
                ItemConveyorBeltLoaderBlockEntity.this.m_6596_();
            }

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new ItemConveyorBeltLoaderMenu(id, inventory, this);
    }

    public int getRedstoneOutput() {
        return InventoryUtils.getRedstoneSignalFromItemStackHandler(this.itemHandler);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            return this.lazyItemHandlerSided.cast();
        }
        return super.getCapability(cap, side);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, ItemConveyorBeltLoaderBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        if (level.m_46467_() % (long)TICKS_PER_ITEM == 0L && ((Boolean)state.m_61143_((Property)ItemConveyorBeltLoaderBlock.ENABLED)).booleanValue()) {
            if (!blockEntity.itemHandler.getStackInSlot(0).m_41619_()) {
                ItemConveyorBeltLoaderBlockEntity.insertItemStackIntoItemConveyorBelt(level, blockPos, state, blockEntity, blockEntity.itemHandler.getStackInSlot(0).m_41777_());
            }
            if (blockEntity.itemHandler.getStackInSlot(0).m_41619_()) {
                ItemConveyorBeltLoaderBlockEntity.extractItemStackFromBlockEntity(level, blockPos, state, blockEntity);
            }
        }
    }

    private static void insertItemStackIntoItemConveyorBelt(Level level, BlockPos blockPos, BlockState state, ItemConveyorBeltLoaderBlockEntity blockEntity, ItemStack itemStackToInsert) {
        Direction direction = (Direction)blockEntity.m_58900_().m_61143_((Property)ItemConveyorBeltLoaderBlock.FACING);
        BlockPos testPos = blockPos.m_121945_(direction);
        BlockState testBlockState = level.m_8055_(testPos);
        if (!testBlockState.m_60713_((Block)ModBlocks.ITEM_CONVEYOR_BELT.get())) {
            return;
        }
        BlockEntity testBlockEntity = level.m_7702_(testPos);
        if (!(testBlockEntity instanceof ItemConveyorBeltBlockEntity)) {
            return;
        }
        LazyOptional itemStackStorageLazyOptional = testBlockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, direction.m_122424_());
        if (!itemStackStorageLazyOptional.isPresent()) {
            return;
        }
        IItemHandler itemStackStorage = (IItemHandler)itemStackStorageLazyOptional.orElseGet(null);
        for (int i = 0; i < itemStackStorage.getSlots(); ++i) {
            if (!itemStackStorage.insertItem(i, itemStackToInsert, false).m_41619_()) continue;
            blockEntity.itemHandler.setStackInSlot(0, ItemStack.f_41583_);
            break;
        }
    }

    private static void extractItemStackFromBlockEntity(Level level, BlockPos blockPos, BlockState state, ItemConveyorBeltLoaderBlockEntity blockEntity) {
        Direction direction = ((Direction)blockEntity.m_58900_().m_61143_((Property)ItemConveyorBeltLoaderBlock.FACING)).m_122424_();
        BlockPos testPos = blockPos.m_121945_(direction);
        BlockEntity testBlockEntity = level.m_7702_(testPos);
        if (testBlockEntity == null) {
            return;
        }
        LazyOptional itemStackStorageLazyOptional = testBlockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, direction.m_122424_());
        if (!itemStackStorageLazyOptional.isPresent()) {
            return;
        }
        IItemHandler itemStackStorage = (IItemHandler)itemStackStorageLazyOptional.orElseGet(null);
        for (int i = 0; i < itemStackStorage.getSlots(); ++i) {
            ItemStack extracted = itemStackStorage.extractItem(i, 1, false);
            if (extracted.m_41619_()) continue;
            blockEntity.itemHandler.setStackInSlot(0, extracted);
            break;
        }
    }
}

