/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.ItemConveyorBeltBlock;
import me.jddev0.ep.block.ModBlockStateProperties;
import me.jddev0.ep.block.ModBlocks;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.block.entity.base.InventoryStorageBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.inventory.ItemStackPacketUpdate;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.ItemStackSyncS2CPacket;
import me.jddev0.ep.util.InventoryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemConveyorBeltBlockEntity
extends InventoryStorageBlockEntity<ItemStackHandler>
implements ItemStackPacketUpdate {
    private static final int TICKS_PER_STEP = ModConfigs.COMMON_ITEM_CONVEYOR_BELT_TICKS_PER_STEP.getValue();
    private final LazyOptional<IItemHandler> lazyItemHandlerFrontSided = LazyOptional.of(() -> new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 0, i -> i == 3));
    private final LazyOptional<IItemHandler> lazyItemHandlerOthersSided = LazyOptional.of(() -> new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 1, i -> i == 3));

    public ItemConveyorBeltBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.ITEM_CONVEYOR_BELT_ENTITY.get(), blockPos, blockState, 4);
    }

    @Override
    protected ItemStackHandler initInventoryStorage() {
        return new ItemStackHandler(this.slotCount){

            protected void onContentsChanged(int slot) {
                ItemConveyorBeltBlockEntity.this.m_6596_();
                for (int i = 0; i < this.getSlots(); ++i) {
                    if (ItemConveyorBeltBlockEntity.this.f_58857_ == null || ItemConveyorBeltBlockEntity.this.f_58857_.m_5776_()) continue;
                    ModMessages.sendToPlayersWithinXBlocks(new ItemStackSyncS2CPacket(i, this.getStackInSlot(i), ItemConveyorBeltBlockEntity.this.m_58899_()), ItemConveyorBeltBlockEntity.this.m_58899_(), (ResourceKey<Level>)ItemConveyorBeltBlockEntity.this.f_58857_.m_46472_(), 64);
                }
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return switch (slot) {
                    case 0, 1 -> true;
                    case 2, 3 -> false;
                    default -> super.isItemValid(slot, stack);
                };
            }

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }

    public int getRedstoneOutput() {
        return InventoryUtils.getRedstoneSignalFromItemStackHandler(this.itemHandler);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            Direction facing = ((ModBlockStateProperties.ConveyorBeltDirection)((Object)this.m_58900_().m_61143_(ItemConveyorBeltBlock.FACING))).getDirection();
            if (side.m_122424_() == facing) {
                return this.lazyItemHandlerFrontSided.cast();
            }
            return this.lazyItemHandlerOthersSided.cast();
        }
        return super.getCapability(cap, side);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, ItemConveyorBeltBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        if (level.m_46467_() % 100L == 0L) {
            for (int i = 0; i < blockEntity.itemHandler.getSlots(); ++i) {
                if (level.m_5776_()) continue;
                ModMessages.sendToPlayersWithinXBlocks(new ItemStackSyncS2CPacket(i, blockEntity.itemHandler.getStackInSlot(i), blockPos), blockPos, (ResourceKey<Level>)level.m_46472_(), 64);
            }
        }
        if (level.m_46467_() % (long)TICKS_PER_STEP == 0L) {
            int slotCount = blockEntity.itemHandler.getSlots();
            if (!blockEntity.itemHandler.getStackInSlot(slotCount - 1).m_41619_()) {
                ItemConveyorBeltBlockEntity.insertItemStackIntoBlockEntity(level, blockPos, state, blockEntity, blockEntity.itemHandler.getStackInSlot(slotCount - 1).m_41777_());
            }
            for (int i = slotCount - 2; i >= 0; --i) {
                ItemStack toItemStack;
                ItemStack fromItemStack = blockEntity.itemHandler.getStackInSlot(i);
                if (fromItemStack.m_41619_() || !(toItemStack = blockEntity.itemHandler.getStackInSlot(i + 1)).m_41619_()) continue;
                blockEntity.itemHandler.setStackInSlot(i, ItemStack.f_41583_);
                blockEntity.itemHandler.setStackInSlot(i + 1, fromItemStack);
            }
        }
    }

    private static void insertItemStackIntoBlockEntity(Level level, BlockPos blockPos, BlockState state, ItemConveyorBeltBlockEntity blockEntity, ItemStack itemStackToInsert) {
        BlockEntity testBlockEntity;
        LazyOptional itemStackStorageLazyOptional;
        ModBlockStateProperties.ConveyorBeltDirection facing = (ModBlockStateProperties.ConveyorBeltDirection)((Object)blockEntity.m_58900_().m_61143_(ItemConveyorBeltBlock.FACING));
        Direction facingDirection = facing.getDirection();
        BlockPos testPos = blockPos.m_121945_(facingDirection);
        if (facing.isAscending()) {
            testPos = testPos.m_121945_(Direction.UP);
        }
        LazyOptional lazyOptional = itemStackStorageLazyOptional = (testBlockEntity = level.m_7702_(testPos)) == null ? null : testBlockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, facingDirection.m_122424_());
        if (itemStackStorageLazyOptional == null || !itemStackStorageLazyOptional.isPresent()) {
            BlockState testBlockState = level.m_8055_(testPos = testPos.m_121945_(Direction.DOWN));
            if (!testBlockState.m_60713_((Block)ModBlocks.ITEM_CONVEYOR_BELT.get())) {
                return;
            }
            ModBlockStateProperties.ConveyorBeltDirection testFacing = (ModBlockStateProperties.ConveyorBeltDirection)((Object)testBlockState.m_61143_(ItemConveyorBeltBlock.FACING));
            if (!testFacing.isDescending() || testFacing.getDirection() != facingDirection) {
                return;
            }
            testBlockEntity = level.m_7702_(testPos);
            if (!(testBlockEntity instanceof ItemConveyorBeltBlockEntity)) {
                return;
            }
            itemStackStorageLazyOptional = testBlockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, facingDirection.m_122424_());
            if (!itemStackStorageLazyOptional.isPresent()) {
                return;
            }
        }
        IItemHandler itemStackStorage = (IItemHandler)itemStackStorageLazyOptional.orElseGet(null);
        for (int i = 0; i < itemStackStorage.getSlots(); ++i) {
            if (!itemStackStorage.insertItem(i, itemStackToInsert, false).m_41619_()) continue;
            blockEntity.itemHandler.setStackInSlot(blockEntity.itemHandler.getSlots() - 1, ItemStack.f_41583_);
            break;
        }
    }

    public int getSlotCount() {
        return this.itemHandler.getSlots();
    }

    public ItemStack getStack(int slot) {
        return this.itemHandler.getStackInSlot(slot);
    }

    @Override
    public void setItemStack(int slot, ItemStack itemStack) {
        this.itemHandler.setStackInSlot(slot, itemStack);
    }
}

