/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.FluidTankBlock;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.block.entity.base.FluidStorageSingleTankMethods;
import me.jddev0.ep.block.entity.base.MenuFluidStorageBlockEntity;
import me.jddev0.ep.machine.CheckboxUpdate;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.FluidSyncS2CPacket;
import me.jddev0.ep.screen.FluidTankMenu;
import me.jddev0.ep.util.FluidUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidTankBlockEntity
extends MenuFluidStorageBlockEntity<FluidTank>
implements CheckboxUpdate {
    private final FluidTankBlock.Tier tier;
    private boolean ignoreNBT;
    private FluidStack fluidFilter = FluidStack.EMPTY;

    public static BlockEntityType<FluidTankBlockEntity> getEntityTypeFromTier(FluidTankBlock.Tier tier) {
        return switch (tier) {
            default -> throw new IncompatibleClassChangeError();
            case FluidTankBlock.Tier.SMALL -> (BlockEntityType)ModBlockEntities.FLUID_TANK_SMALL_ENTITY.get();
            case FluidTankBlock.Tier.MEDIUM -> (BlockEntityType)ModBlockEntities.FLUID_TANK_MEDIUM_ENTITY.get();
            case FluidTankBlock.Tier.LARGE -> (BlockEntityType)ModBlockEntities.FLUID_TANK_LARGE_ENTITY.get();
        };
    }

    public FluidTankBlockEntity(BlockPos blockPos, BlockState blockState, FluidTankBlock.Tier tier) {
        super(FluidTankBlockEntity.getEntityTypeFromTier(tier), blockPos, blockState, tier.getResourceId(), FluidStorageSingleTankMethods.INSTANCE, tier.getTankCapacity());
        this.tier = tier;
    }

    @Override
    protected FluidTank initFluidStorage() {
        return new FluidTank(this.baseTankCapacity){

            protected void onContentsChanged() {
                FluidTankBlockEntity.this.m_6596_();
                FluidTankBlockEntity.this.syncFluidToPlayers(64);
            }

            public boolean isFluidValid(FluidStack stack) {
                if (!super.isFluidValid(stack)) {
                    return false;
                }
                return FluidTankBlockEntity.this.fluidFilter.isEmpty() || (FluidTankBlockEntity.this.ignoreNBT ? FluidTankBlockEntity.this.fluidFilter.getFluid().m_6212_(stack.getFluid()) : FluidTankBlockEntity.this.fluidFilter.isFluidEqual(stack));
            }
        };
    }

    @Override
    protected ContainerData initContainerData() {
        return new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> {
                        if (FluidTankBlockEntity.this.ignoreNBT) {
                            yield 1;
                        }
                        yield 0;
                    }
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        FluidTankBlockEntity.this.ignoreNBT = value != 0;
                    }
                }
            }

            public int m_6499_() {
                return 1;
            }
        };
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        this.syncFluidToPlayer(player);
        ModMessages.sendToPlayer(new FluidSyncS2CPacket(1, this.fluidFilter, 0, this.f_58858_), (ServerPlayer)player);
        return new FluidTankMenu(id, inventory, this, this.data);
    }

    public FluidTankBlock.Tier getTier() {
        return this.tier;
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, FluidTankBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        if (level.m_46467_() % 100L == 0L) {
            blockEntity.syncFluidToPlayers(64);
        }
    }

    public int getRedstoneOutput() {
        return FluidUtils.getRedstoneSignalFromFluidHandler(this.fluidStorage);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.lazyFluidStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128379_("ignore_nbt", this.ignoreNBT);
        nbt.m_128365_("fluid_filter", (Tag)this.fluidFilter.writeToNBT(new CompoundTag()));
    }

    @Override
    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.ignoreNBT = nbt.m_128471_("ignore_nbt");
        this.fluidFilter = FluidStack.loadFluidStackFromNBT((CompoundTag)nbt.m_128469_("fluid_filter"));
    }

    public void setIgnoreNBT(boolean ignoreNBT) {
        this.ignoreNBT = ignoreNBT;
        FluidTankBlockEntity.m_155232_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (BlockState)this.m_58900_());
    }

    @Override
    public void setCheckbox(int checkboxId, boolean checked) {
        switch (checkboxId) {
            case 0: {
                this.setIgnoreNBT(checked);
            }
        }
    }

    public void setFluidFilter(FluidStack fluidFilter) {
        this.fluidFilter = fluidFilter.copy();
        FluidTankBlockEntity.m_155232_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (BlockState)this.m_58900_());
        ModMessages.sendToPlayersWithinXBlocks(new FluidSyncS2CPacket(1, fluidFilter, 0, this.m_58899_()), this.m_58899_(), (ResourceKey<Level>)this.f_58857_.m_46472_(), 64);
    }

    @Override
    public FluidStack getFluid(int tank) {
        return switch (tank) {
            case 0 -> super.getFluid(tank);
            case 1 -> this.fluidFilter;
            default -> null;
        };
    }

    @Override
    public int getTankCapacity(int tank) {
        if (tank == 0) {
            return super.getTankCapacity(tank);
        }
        return 0;
    }

    @Override
    public void setFluid(int tank, FluidStack fluidStack) {
        switch (tank) {
            case 0: {
                super.setFluid(tank, fluidStack);
                break;
            }
            case 1: {
                this.fluidFilter = fluidStack.copy();
            }
        }
    }

    @Override
    public void setTankCapacity(int tank, int capacity) {
        if (tank == 0) {
            super.setTankCapacity(tank, capacity);
        }
    }
}

